/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

#ifndef __KZ_NOTEBOOK_H__
#define __KZ_NOTEBOOK_H__

#include "kz-window.h"
#include "kz-tab-label.h"

G_BEGIN_DECLS

#define KZ_TYPE_NOTEBOOK		(kz_notebook_get_type ())
#define KZ_NOTEBOOK(obj)		(GTK_CHECK_CAST ((obj), KZ_TYPE_NOTEBOOK, KzNotebook))
#define KZ_NOTEBOOK_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), KZ_TYPE_NOTEBOOK, KzNotebookClass))
#define KZ_IS_NOTEBOOK(obj)		(GTK_CHECK_TYPE ((obj), KZ_TYPE_NOTEBOOK))
#define KZ_IS_NOTEBOOK_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), KZ_TYPE_NOTEBOOK))
#define KZ_NOTEBOOK_GET_CLASS(obj)	(GTK_CHECK_GET_CLASS ((obj), KZ_TYPE_NOTEBOOK, KzNotebookClass))

typedef struct _KzNotebook      KzNotebook;
typedef struct _KzNotebookClass KzNotebookClass;

struct _KzNotebook
{
	GtkNotebook parent;
};

struct _KzNotebookClass
{
	GtkNotebookClass parent_class;
};

typedef enum {
	KZ_NOTEBOOK_CLOSE_INACTIVE,
	KZ_NOTEBOOK_CLOSE_BACKWARD,
	KZ_NOTEBOOK_CLOSE_FORWARD
} KzNotebookCloseCondition;

GType       kz_notebook_get_type          (void) G_GNUC_CONST;
GtkWidget  *kz_notebook_new               (KzWindow *kz);
KzTabLabel *kz_notebook_open_new_tab	  (KzNotebook *notebook, KzEmbed *embed, KzTabLabel *label);
KzTabLabel *kz_notebook_open_new_tab_at_pos(KzNotebook *notebook, KzEmbed *embed, KzTabLabel *label, gint pos);
gboolean    kz_notebook_close_tab	  (KzNotebook *notebook, GtkWidget *widget);
gboolean    kz_notebook_close_tabs	  (KzNotebook *notebook, KzNotebookCloseCondition condition, gint pos);
gboolean    kz_notebook_close_all_tab     (KzNotebook *notebook);
gboolean    kz_notebook_move_tab          (KzNotebook *src_notebook, KzNotebook *dest_notebook, GtkWidget *widget);
void	    kz_notebook_next_tab	  (KzNotebook *notebook);
void	    kz_notebook_prev_tab	  (KzNotebook *notebook);
GtkWidget  *kz_notebook_reorder_tab	  (KzNotebook *notebook, GtkWidget *widget, gint pos);
gboolean    kz_notebook_scroll_tab	  (KzNotebook *notebook, GdkScrollDirection direction);
GtkWidget  *kz_notebook_get_nth_page      (KzNotebook *notebook, gint page_num);
gint        kz_notebook_page_num          (KzNotebook *notebook, GtkWidget *child);
gint	    kz_notebook_get_current_page  (KzNotebook *notebook);
void	    kz_notebook_set_current_page  (KzNotebook *notebook, gint page_num);
gint        kz_notebook_get_n_pages       (KzNotebook *notebook);

G_END_DECLS

#endif /* __KZ_NOTEBOOK_H__ */
