/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_APP_H__
#define __KZ_APP_H__

#include <gtk/gtk.h>

#include "kz-favicon.h"
#include "kz-search.h"
#include "kz-profile.h"
#include "kz-root-bookmark.h"
#include "kz-migemo.h"

G_BEGIN_DECLS

#define KZ_TYPE_APP		   (kz_app_get_type ())
#define KZ_APP(obj)		   (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_APP, KzApp))
#define KZ_APP_CLASS(klass)	   (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_APP, KzAppClass))
#define KZ_IS_APP(obj)	   (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_APP))
#define KZ_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_APP))
#define KZ_APP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_APP, KzAppClass))

typedef struct _KzApp   	KzApp;
typedef struct _KzAppClass	KzAppClass;

struct _KzApp
{
	GObject parent;
};

struct _KzAppClass
{
	GObjectClass parent_class;
};

GType      kz_app_get_type      (void) G_GNUC_CONST;

KzApp     *kz_app_new           (gint argc, gchar **argv);

const gchar	*kz_app_get_user_dir		(KzApp *app);
const gchar	*kz_app_get_history_dir		(KzApp *app);
const gchar	*kz_app_get_history_time_stamp	(KzApp *app);
const gchar	*kz_app_get_popup_dir		(KzApp *app);
const gchar	*kz_app_get_favicon_dir		(KzApp *app);
const gchar	*kz_app_get_smartbookmark_history_dir	(KzApp *app);
const gchar	*kz_app_get_form_data_dir	(KzApp *app);
const gchar	*kz_app_get_clips_dir		(KzApp *app);
const gchar	*kz_app_get_thumbnails_dir	(KzApp *app);
const gchar	*kz_app_get_system_data_dir	(KzApp *app);
const gchar	*kz_app_get_system_kz_data_dir	(KzApp *app);
const gchar	*kz_app_get_system_ruby_ext_dir	(KzApp *app);
const gchar	*kz_app_get_system_config_dir	(KzApp *app);
const gchar	*kz_app_get_system_icons_dir	(KzApp *app);
const gchar	*kz_app_get_system_pixmaps_dir	(KzApp *app);

GtkWidget *kz_app_create_new_window (KzApp *app, const gchar *uri);

GtkWidget *kz_app_restore_session   (KzApp *app);
void       kz_app_save_session      (KzApp *app);

void       kz_app_init_dependencies (KzApp *app, gpointer initial_address);
void       kz_app_quit_dependencies (KzApp *app);

typedef enum {
	KZ_UI_LEVEL_INVALID  = 0,
	KZ_UI_LEVEL_BEGINNER = 1,
	KZ_UI_LEVEL_MEDIUM   = 2,
	KZ_UI_LEVEL_EXPERT   = 4,
	KZ_UI_LEVEL_CUSTOM   = 8,
	KZ_UI_LEVEL_ALL      = 0xFFFF
} KzUILevel;

KzUILevel       kz_app_get_ui_level        (KzApp *app);
KzFavicon      *kz_app_get_favicon         (KzApp *app);
KzSearch       *kz_app_get_search          (KzApp *app);
void		kz_app_set_search          (KzApp *app, const gchar *search);
KzRootBookmark *kz_app_get_root_bookmark   (KzApp *app);
KzProfile      *kz_app_get_profile         (KzApp *app);
KzProfile      *kz_app_get_proxy           (KzApp *app);
const GList    *kz_app_get_window_list     (KzApp *app);
GtkWidget      *kz_app_get_window_from_tab (KzApp *app, GtkWidget *tab);
#if USE_MIGEMO
KzMigemo       *kz_app_get_migemo          (KzApp *app);
#endif

G_END_DECLS

#endif /* __KZ_APP_H__ */
