/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KAZEHAKASE_H__
#define __KAZEHAKASE_H__

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif /* HAVE_CONFIG_H */

#include <string.h>
#include <glib.h>
#include "kz-app.h"
#include "kz-profile.h"
G_BEGIN_DECLS

#define KAZEHAKASE_URI "http://kazehakase.sourceforge.jp/"
#define KZ_THUMB_HEIGHT 200

#define HISTORY_DIR   G_DIR_SEPARATOR_S"."PACKAGE G_DIR_SEPARATOR_S"history"G_DIR_SEPARATOR_S

extern KzApp	      *kz_app;

#define KZ_CONF_GET(s, k, v, t)					\
	kz_profile_get_value(kz_app_get_profile(kz_app),	\
			     s, k, &(v), sizeof(v),		\
			     KZ_PROFILE_VALUE_TYPE_##t)
#define KZ_CONF_SET(s, k, v, t)					\
	kz_profile_set_value(kz_app_get_profile(kz_app),	\
			     s, k, &(v), sizeof(v),		\
			     KZ_PROFILE_VALUE_TYPE_##t)
#define KZ_CONF_GET_STR(s, k)					\
	kz_profile_get_string(kz_app_get_profile(kz_app), s, k)
#define KZ_CONF_SET_STR(s, k, v)				\
	 kz_profile_set_value(kz_app_get_profile(kz_app),	\
			      s, k,				\
			      (gchar *)v,			\
			      strlen((gchar *)v) + 1,		\
			      KZ_PROFILE_VALUE_TYPE_STRING)
#define KZ_GET_UI_LEVEL	       kz_app_get_ui_level(kz_app)
#define KZ_GET_GLOBAL_PROFILE  kz_app_get_profile(kz_app)
#define KZ_GET_PROXY           kz_app_get_proxy(kz_app)
#define KZ_GET_FAVICON         kz_app_get_favicon(kz_app)
#define KZ_GET_ROOT_BOOKMARK   kz_app_get_root_bookmark(kz_app)
#define KZ_GET_CURRENT_SESSION kz_app_get_root_bookmark(kz_app)->current_session
#define KZ_GET_MENU_BOOKMARK   kz_app_get_root_bookmark(kz_app)->menu
#define KZ_GET_SMART_BOOKMARK  kz_app_get_root_bookmark(kz_app)->smarts
#define KZ_GET_BAR_BOOKMARK    kz_app_get_root_bookmark(kz_app)->bookmark_bars
#define KZ_GET_CLIP_BOOKMARK   kz_app_get_root_bookmark(kz_app)->clip
#define KZ_GET_SEARCH	       kz_app_get_search(kz_app)
#define KZ_GET_WINDOW_LIST     kz_app_get_window_list(kz_app)
#define KZ_GET_MIGEMO          kz_app_get_migemo(kz_app)

#define KZ_GET_USER_DIR		kz_app_get_user_dir(kz_app)
#define KZ_GET_HISTORY_DIR	kz_app_get_history_dir(kz_app)
#define KZ_GET_HISTORY_TIME_STAMP	kz_app_get_history_time_stamp(kz_app)
#define KZ_GET_POPUP_DIR	kz_app_get_popup_dir(kz_app)
#define KZ_GET_FAVICON_DIR	kz_app_get_favicon_dir(kz_app)
#define KZ_GET_SMARTBOOKMARK_HISTORY_DIR	kz_app_get_smartbookmark_history_dir(kz_app)
#define KZ_GET_FORM_DATA_DIR	kz_app_get_form_data_dir(kz_app)
#define KZ_GET_CLIPS_DIR	kz_app_get_clips_dir(kz_app)
#define KZ_GET_THUMBNAILS_DIR	kz_app_get_thumbnails_dir(kz_app)
#define KZ_GET_SYSTEM_DATA_DIR	kz_app_get_system_data_dir(kz_app)
#define KZ_GET_SYSTEM_KZ_DATA_DIR	kz_app_get_system_kz_data_dir(kz_app)
#define KZ_GET_SYSTEM_RUBY_EXT_DIR	kz_app_get_system_ruby_ext_dir(kz_app)
#define KZ_GET_SYSTEM_CONFIG_DIR	kz_app_get_system_config_dir(kz_app)
#define KZ_GET_SYSTEM_ICONS_DIR	kz_app_get_system_icons_dir(kz_app)
#define KZ_GET_SYSTEM_PIXMAPS_DIR	kz_app_get_system_pixmaps_dir(kz_app)


#define KZ_SET_SEARCH(engine_name)	kz_app_set_search(kz_app, engine_name)


G_END_DECLS

#endif /* __KAZEAKASE_H__ */
