/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_MOZ_THUMBNAIL_PROGRESS_LISTENER_H__
#define __KZ_MOZ_THUMBNAIL_PROGRESS_LISTENER_H__

#include "egg-pixbuf-thumbnail.h"

#include "kz-gecko-embed.h"
#include "kz-mozthumbnailcreator.h"

#include <nsIWebProgressListener.h>


class KzMozThumbnailProgressListener : public nsIWebProgressListener
{
 public:
	KzMozThumbnailProgressListener (const gchar *filename,
					const gchar *uri,
					time_t mtime,
					EggPixbufThumbSize size,
					KzMozThumbnailCreator *creator);
	virtual ~KzMozThumbnailProgressListener ();

	NS_DECL_ISUPPORTS
	NS_DECL_NSIWEBPROGRESSLISTENER

 private:
	gchar *mFilename;
	gchar *mURI;
	time_t mMtime;
	EggPixbufThumbSize mSize;
	KzMozThumbnailCreator *mCreator;
};


#endif /* __KZ_MOZ_THUMBNAIL_PROGRESS_LISTENER_H__ */
