/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  2003-12-17 Hiroyuki Ikezoe <poincare@ikezoe.net>
 *   these codes picked from EphyEventListner.cpp in epiphany-1.0.6.    
 */

#include "kz-mozeventlistener.h"

#include <nsCOMPtr.h>
#include <nsIDOMNode.h>
#include <nsIDOMElement.h>
#define MOZILLA_STRICT_API
#include <nsEmbedString.h>
#undef MOZILLA_STRICT_API
#include <nsIDOMDocument.h>
#include <nsIURI.h>
#include <nsIDOMEventTarget.h>
#include <nsIDOMEvent.h>
#include <nsIDOM3Node.h>

#include "kz-mozutils.h"
#include "kz-favicon.h"

KzMozEventListener::KzMozEventListener(void)
{
	NS_INIT_ISUPPORTS();
	mOwner = nsnull;
}

KzMozEventListener::~KzMozEventListener()
{
}

NS_IMPL_ISUPPORTS1(KzMozEventListener, nsIDOMEventListener)

nsresult
KzMozEventListener::Init(KzMozEmbed *aOwner)
{
	mOwner = aOwner;
	return NS_OK;
}

nsresult
KzMozEventListener::HandleLink (nsIDOMNode *node)
{
	nsresult result;

	nsCOMPtr<nsIDOMElement> linkElement;
	linkElement = do_QueryInterface (node);
	if (!linkElement) return NS_ERROR_FAILURE;

	nsEmbedString name;

	nsEmbedCString crel("rel");
	nsEmbedString rel;
	NS_CStringToUTF16(crel, NS_CSTRING_ENCODING_UTF8, rel);

	result = linkElement->GetAttribute (rel, name);
	if (NS_FAILED(result)) return NS_ERROR_FAILURE;

	nsEmbedString link;
	nsEmbedCString chref("href");
	nsEmbedString href;
	NS_CStringToUTF16(chref, NS_CSTRING_ENCODING_UTF8, href);

	result = linkElement->GetAttribute (href, link);
	if (NS_FAILED (result) || !link.Length()) return NS_ERROR_FAILURE;

	nsCOMPtr<nsIDOMDocument> domDoc;
	result = node->GetOwnerDocument(getter_AddRefs(domDoc));
	if (NS_FAILED(result) || !domDoc) return NS_ERROR_FAILURE;

	nsCOMPtr<nsIDOM3Node> domnode = do_QueryInterface(domDoc);
     	if(!domnode) return NS_ERROR_FAILURE;

	nsEmbedString spec;
	domnode->GetBaseURI(spec);

	nsEmbedCString cSpec;
	NS_UTF16ToCString(spec, NS_CSTRING_ENCODING_UTF8, cSpec);

	nsCOMPtr<nsIURI> baseURI;
	NewURI(getter_AddRefs(baseURI), cSpec.get());
	if (!baseURI) return NS_ERROR_FAILURE;

	nsEmbedCString linkstring;
	NS_UTF16ToCString(link, NS_CSTRING_ENCODING_UTF8, linkstring);
	nsEmbedCString url;
	result = baseURI->Resolve (linkstring, url);
	if (NS_FAILED (result)) return NS_ERROR_FAILURE;

	nsEmbedCString cName;
	NS_UTF16ToCString(name, NS_CSTRING_ENCODING_UTF8, cName);
	if (!g_ascii_strcasecmp(cName.get(),"SHORTCUT ICON") ||
	    !g_ascii_strcasecmp(cName.get(),"ICON"))
	{
		KzFavicon *kzfav = kz_favicon_get_instance();
		char *favicon_uri = g_strdup (url.get());
		const char *document_uri = kz_embed_get_location(KZ_EMBED(mOwner));
		kz_favicon_get_icon_from_uri(kzfav, favicon_uri, document_uri);
		g_free (favicon_uri);
		g_object_unref(kzfav);
	}
	else //if (link.EqualsIgnoreCase("ALTERNATE"))
	{
		kz_embed_set_nav_link(KZ_EMBED(mOwner),
				      cName.get(),
				      cName.get());
	}
		
	return NS_OK;
}	

NS_IMETHODIMP
KzMozEventListener::HandleEvent(nsIDOMEvent* aDOMEvent)
{
	nsCOMPtr<nsIDOMEventTarget> eventTarget;
	
	aDOMEvent->GetTarget(getter_AddRefs(eventTarget));

	nsresult result;
	nsCOMPtr<nsIDOMNode> node = do_QueryInterface(eventTarget, &result);
	if (NS_FAILED(result) || !node) return NS_ERROR_FAILURE;

	HandleLink (node);

	return NS_OK;
}
