/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  #Id: $
 */

#ifndef __KZ_BOOKMARK_EDIT_WIN_H__
#define __KZ_BOOKMARK_EDIT_WIN_H__

#include <gtk/gtk.h>
#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_EDIT_WIN		(kz_bookmark_edit_win_get_type ())
#define KZ_BOOKMARK_EDIT_WIN(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_EDIT_WIN, KzBookmarkEditWin))
#define KZ_BOOKMARK_EDIT_WIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_BOOKMARK_EDIT_WIN, KzBookmarkEditWinClass))
#define KZ_IS_BOOKMARK_EDIT_WIN(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_EDIT_WIN))
#define KZ_IS_BOOKMARK_EDIT_WIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_BOOKMARK_EDIT_WIN))
#define KZ_BOOKMARK_EDIT_WIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_BOOKMARK_EDIT_WIN, KzBookmarkEditWinClass))

typedef struct _KzBookmarkEditWin      KzBookmarkEditWin;
typedef struct _KzBookmarkEditWinClass KzBookmarkEditWinClass;
typedef struct _KzBookmarkEditWinPriv  KzBookmarkEditWinPriv;

struct _KzBookmarkEditWin
{
	GtkDialog dialog;

	GtkWidget *bookmark_edit;

	KzBookmarkEditWinPriv *priv;
};

struct _KzBookmarkEditWinClass
{
	GtkDialogClass parent_class;
};

GtkType    kz_bookmark_edit_win_get_type (void);
GtkWidget *kz_bookmark_edit_win_new      (KzBookmark *bookmark);

G_END_DECLS

#endif /* __KZ_BOOKMARK_EDIT_WIN_H__ */
