unit untTopicBrowserIE;

interface

uses
  Classes, ComCtrls, Controls, OleCtrls, SHDocVw_TLB, MSHTML_TLB,
  untTopic, SysUtils, untGlobal, Forms, untHintWindow,
  untTool, ExtCtrls, windows, untBBSCore, BmRegExp, untTopicBrowser,
  HTMLDocumentEvent, StrUtils;

type

  TTopicBrowserIE = class(TTopicBrowser)
  protected
    FDownloadComplete : boolean;
    FLogLoadedCount : Integer;
    FBrowser        : TWebBrowser;
    FReplaceMode    : integer;
    FReceivedIndex  : integer;
    FWaitInitialize : boolean;
    FStartIndex     : integer;
    FRestoredPos    : boolean;
    FNoScroll       : boolean;
		FHtmlEvent      : THTMLDocumentEventSink;
    FOutputedHeader : Boolean;
    FReserveRefresh : Boolean;
    procedure BrowserInitialize();
    procedure Browser_NavigateComplete2(Sender: TObject; const pDisp: IDispatch; var URL: OleVariant);
    procedure Browser_StatusTextChange(Sender: TObject; const Text: WideString);
    procedure Browser_BeforeNavigate(Sender: TObject; const pDisp: IDispatch; var URL: OleVariant; var Flags: OleVariant; var TargetFrameName: OleVariant; var PostData: OleVariant; var Headers: OleVariant; var Cancel: WordBool);
    procedure BrowserOutput(output : string);
    function  DatToHtml(body: string): string;
    function  ReplaceString(MatchStr: string): string;
    procedure RestoreScrollPosition;
    procedure JumpMessage(msgno : integer); override;
    function  OnContextMenu(Sender: TObject): WordBool;
    function  MsgToHtml(msg : TTopicMessage) : string;
  public
    procedure   SaveScrollPosition; override;
    procedure   ChangeViewLimit(NewLimit: integer); override;
    procedure   SearchText(str: string); override;
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy;    override;
    procedure   CloseTopic; override;
    procedure   Reload;   override;
    procedure   SetTextSize(TextSize: Integer);
    procedure Topic_MessageReceived(sender: TObject); override;
    procedure Topic_ChangeDownloadState(Sender : TObject);override;
  end;

implementation

uses
  untBBSFramework;
  
{ TTopicBrowserIE }

// Xe[^Xo[̕ω
procedure TTopicBrowserIE.Browser_StatusTextChange(Sender: TObject;
                                                   const Text: WideString);
begin
  ChangeStatusText(Text);
end;

// bZ[WM
procedure TTopicBrowserIE.Topic_MessageReceived(sender: TObject);
var
  i           : integer;
  msg         : TTopicMessage;
  html        : string;
  SleepCount  : integer;
  WriteCount  : integer;
  WriteTiming : integer;
label
  First;

begin
  if FLoading = false then
  begin
First:
    FLoading := true;

    FDownloading:= true;

    WriteTiming := 10;
    WriteCount  := 0;
    SleepCount  := 0;
    i :=  FReceivedIndex;

    while i < Topic.MessageList.Count do
    begin
      Inc(SleepCount);
      Inc(WriteCount);
      if SleepCount > 50 then
      begin
        SleepCount := 0;
        if WriteCount > WriteTiming then
        begin
          WriteCount := 0;
          BrowserOutput(html);
          Application.ProcessMessages;
          html := '';

          case WriteTiming of
             0 : WriteTiming := 10;
            10 : WriteTiming := 50;
            50 : WriteTiming := 1000;
          end;
        end;
      end;

      i := FReceivedIndex;
      if i < Topic.MessageList.Count then
      begin
        FReceivedIndex := i + 1;
        msg := TTopicMessage(Topic.MessageList[i]);
        Inc(i);

        if msg.IsNewMessage = false then
        begin
          Inc(FLogLoadedCount);
          if (msg.Index > 1) and (FViewLimit > 0) then
          begin
            if Topic.GotMessageCount - FLogLoadedCount > FViewLimit then
            begin
              goto First;
            end;
          end;
        end else
        begin
          FNewMsg := true;
        end;

        if (FStartIndex = 0) and (msg.Index > 1) then
        begin
          FStartIndex := msg.Index;
        end;

        // XN[
        if not FRestoredPos and msg.IsNewMessage then
        begin
          WriteCount := 0;
          BrowserOutput(html);
          html := '';
          RestoreScrollPosition;
        end;

        //this.ImageIndex = 4;

        // 
        html := html + MsgToHtml(msg);
        //BrowserOutput(output);

        msg.IsNewMessage := false;
      end;
    end;

    BrowserOutput(html);
    Application.ProcessMessages;

    FLoading := false;

    if FReceivedIndex >= Topic.MessageList.Count then
    begin
      // XN[
      RestoreScrollPosition;
    end;

    Topic_ChangeDownloadState(Topic);
  end;
end;

constructor TTopicBrowserIE.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FHtmlEvent := nil;

  // uEU̐
  FBrowser := TWebBrowser.Create(self);
  TWinControl(FBrowser).Parent := self;
  FBrowser.Align   := alClient;
  FBrowser.Visible := true;
  FBrowser.OnNavigateComplete2 := Browser_NavigateComplete2;
  FBrowser.OnStatusTextChange  := Browser_StatusTextChange;
  FBrowser.OnBeforeNavigate2   := Browser_BeforeNavigate;

  BrowserInitialize();

end;

destructor TTopicBrowserIE.Destroy;
begin
  FBrowser.Free;
  FHtmlEvent.Free;

  inherited;
end;

procedure TTopicBrowserIE.Reload;
begin
  FLogLoadedCount := 0;
  inherited;
end;

procedure TTopicBrowserIE.ChangeViewLimit(NewLimit: integer);
begin

  Fviewlimit := newlimit;
	if Topic <> nil then
  begin
    SaveScrollPosition();
    BrowserInitialize();

    FLogLoadedCount := 0;
    if Topic <> nil then
    begin
      FNewMsg := false;
      gBBSCore.DownloadTopic(Topic, self);
    end;
  end;
end;

// uEȔ
procedure TTopicBrowserIE.Browser_NavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
var
  Disp: DispHTMLDocument;//ISimpleCom;
begin

  if FWaitInitialize = true then
  begin
 		FWaitInitialize := false;

    Disp := FBrowser.Document as DispHTMLDocument;
    FHtmlEvent := THTMLDocumentEventSink.Create(Self, Disp, HTMLDocumentEvents2);
    FHtmlEvent.OnContextMenu := OnContextMenu;
  end;

end;

function TTopicBrowserIE.OnContextMenu(Sender: TObject): WordBool;
var
	Doc: IHtmlDocument2;
	Range: IHTMLTxtRange;
	s: string;
  msgno : integer;
begin
  Result := True;

	Doc := FBrowser.Document as IHtmlDocument2;
	Range := Doc.selection.createRange as IHTMLTxtRange;
	s := StringReplace(Range.text, '@', ' ', [rfReplaceAll]);
	s := ZenkakuToHankaku(Trim(s));
  msgno := StrToIntNeo(s);
  if msgno > 0 then
    if ChangeStatusText('jump://goto/' + IntToStr(msgno)) then
      result := false;
end;

{ --------------------------------------------------------
  ֐: BrowserInitialize
  pr  : uEȔ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowserIE.BrowserInitialize();
var
  I : Integer;
begin

  FReserveRefresh := false;
  FReceivedIndex  := 0;
  FLogLoadedCount := 0;
  FStartIndex     := 0;
  FRestoredPos    := false;
  FOutputedHeader := false;

  FWaitInitialize := true;
  FBrowser.Navigate('about:blank');

  // o܂ő҂
  for I := 0 to 10000 do
  begin
    if FWaitInitialize = false then
    begin
      break;
    end else
    begin
      Application.ProcessMessages;
    end;
  end;
end;

{ --------------------------------------------------------
  ֐: SaveScrollPosition
  pr  : XN[ʒu̕ۑ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowserIE.SaveScrollPosition;
var
  body: Variant;
  top: Integer;
  scrollheight: Integer;
  lastspace: Integer;
begin

  body := (FBrowser.Document as IHTMLDocument2).body;
  top          := body.scrollTop;
  scrollheight := body.scrollHeight;
  lastspace    := scrollheight  -  top;
  Topic.ScrollPosition := lastspace;
  Topic.SaveIdx();
end;

{ --------------------------------------------------------
  ֐: BrowserOutput
  pr  : uEU֏o
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowserIE.BrowserOutput(output: string);
begin
  if(FReserveRefresh) then
    BrowserInitialize;

  if FOutputedHeader = false then
  begin
    output := StringReplace(gConfig.HeaderHtml, '&THREADURL', Topic.BrowserUrl, [rfReplaceAll]) + output;
    FOutputedHeader := true;
  end;
  OleVariant(FBrowser.Document as IHTMLDocument2).write(output);
end;

{ --------------------------------------------------------
  ֐: SearchText
  pr  : 
    : str - 
  ߂l: Ȃ
  l  :
  ------------------------------------------------------ }
procedure TTopicBrowserIE.SearchText(str: string);
var
  I    : integer;
  msg  : TTopicMessage;
  html : string;
  find : boolean;
begin

  BrowserInitialize;

  for I := 0 to Topic.MessageList.Count -1 do
  begin
    msg := TTopicMessage(Topic.MessageList[I]);

    find := AnsiContainsText(msg.PostName, str);
    if not find then
    begin
      find := AnsiContainsText(msg.Postemail, str);
      if not find then
      begin
        find := AnsiContainsText(msg.RestStr, str);
        if not find then
        begin
          find := AnsiContainsText(msg.Body, str);
        end;
      end;
    end;

    if find then
    begin
      msg  := TTopicMessage(Topic.MessageList[I]);
      html := MsgToHtml(msg);
      BrowserOutput(html);
    end;
  end;

  FReserveRefresh := true;
end;

// XN[
procedure TTopicBrowserIE.RestoreScrollPosition;
var
  body: OleVariant;
  scrollheight: Integer;
  top: Integer;

begin
  inherited;

  if FRestoredPos = true then
  begin
    exit;
  end;
  FRestoredPos := true;

  if FNoScroll then
  begin
    FNoScroll := false;
    exit;
  end;

  Application.ProcessMessages;

  body := (FBrowser.Document as IHTMLDocument2).body;
  scrollheight := body.scrollHeight;
  top := scrollheight  -  Topic.ScrollPosition;
  body.scrollTop := top;
end;

procedure TTopicBrowserIE.Browser_BeforeNavigate(Sender: TObject;
                                                 const pDisp: IDispatch;
                                                 var URL,
                                                     Flags,
                                                     TargetFrameName,
                                                     PostData,
                                                     Headers: OleVariant;
                                                 var Cancel: WordBool);
begin
  if URL = 'about:blank' then
  begin
    exit;
  end;

  Cancel := true;
  inherited RaiseNavigateUrlEvent(URL);
end;

procedure TTopicBrowserIE.JumpMessage(msgno: integer);
begin
  inherited;

  if msgno < FStartIndex then
  begin

    //FTopic.ScrollPosition := -1;
    FNoScroll := true;
    ChangeViewLimit(Topic.GotMessageCount - msgno + 1);

  end else
  begin

    OleVariant(FBrowser.Document).body.scrollTop
	  	:= OleVariant(FBrowser.Document).anchors.item('a' + IntToStr(msgno) ).offsetTop;
  end;

end;

{ --------------------------------------------------------
  ֐: DatToHtml
  pr  : >>1 ̕ϊ
    : body - Ώۂ̕
  ߂l: Ȃ
  l  : ϊ̕
  ------------------------------------------------------ }
function TTopicBrowserIE.DatToHtml(body: string): string;
var
  AWK : TAwkStr;
begin

  body := EraseATag(body);
  AWK := TAwkStr.Create(nil);
  AWK.OnReplaceString := ReplaceString;

  // XԍɃN\
  FReplaceMode := 1;
  AWK.RegExp := '(&gt;|)+[0-9O-X]+([-|[][0-9O-X]+)?';
  AWK.GSub('', body);

  // URLɃN\
  FReplaceMode := 2; 
  AWK.RegExp := 'h*ttp://[a-zA-Z_/%@\-~\.0-9&=%\?#;:\,\+]+';
  AWK.GSub('', body);

  AWK.Free;
  result := body;
end;

function TTopicBrowserIE.ReplaceString(MatchStr : string) : string;
var
  strNum : string;
  I      : integer;
  isnum  : char;
  check  : string;

begin
  case FReplaceMode of
    1:
    begin
      check := ZenkakuToHankaku(MatchStr);
      for i := Length(check)  downto 1 do
      begin
        isnum := check[i];
        if (isnum in ['0'..'9']) or (isnum = '-') then
          strNum := isnum + strNum;
      end;

      result := '<A HREF="jump://goto/' + strNum + '">' + MatchStr + '</A>';
    end;
    2:
    begin
      check := Matchstr;
      if Copy(check, 1, 1) <> 'h' then
      begin
        check := 'h' + check;
      end;

      if Pos('#', check) <> 0 then
      begin
        result := '<a href="' + AnsiReplaceText(check, '#', '[%23]') + '">' + MatchStr + '</a>'
      end else
      begin
        result := '<a href="' + check + '">' + MatchStr + '</a>';
      end;
    end;
  end;
end;

procedure TTopicBrowserIE.Topic_ChangeDownloadState(Sender: TObject);
begin
  inherited;

  Case Topic.DownloadState of
    dsNone:
    begin
      FDownloadComplete := true;
    end;
    else
    begin
      FDownloadComplete := false;
    end;
  end;
end;

procedure TTopicBrowserIE.CloseTopic;
begin
  inherited;

  FHtmlEvent.Free;
  BrowserInitialize();
end;

procedure TTopicBrowserIE.SetTextSize(TextSize : Integer);
var
  size, rc: OleVariant;

begin
  if (TextSize < 0) or (TextSize > 4) then
    Exit;

  if Assigned(FBrowser.Document) then
  begin
    size := TextSize;
    FBrowser.ExecWB(OLECMDID_ZOOM , OLECMDEXECOPT_DONTPROMPTUSER, size, rc);
  end;
end;

function TTopicBrowserIE.MsgToHtml(msg: TTopicMessage): string;
var
  outputhtml : string;
  mailname   : string;
  strBody    : string;

begin
  if msg.IsNewMessage = false then
  begin
    outputhtml := gConfig.ResHtml
  end else
  begin
    outputhtml := gConfig.NewResHtml;
  end;

  if msg.PostEmail <> '' then
  begin
    if gConfig.HideMailAddress then
    begin
      mailname := '<A HREF="mailto:' + msg.PostEmail+ '">' +
                  msg.PostName + '</A>';
    end else
    begin
      mailname := '<B>' + msg.PostName + '</B></B> [' + msg.PostEmail+ ']';
    end;
  end else
  begin
    mailname := msg.PostName;
  end;

  outputhtml := StringReplace(outputhtml, '&MAILNAME', '<B>' + mailname + '</B>', [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&NUMBER',   '<a href="menu://at/' + IntToStr(msg.Index) + '">' + IntToStr(msg.Index) + '</a>', [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&DATE',     msg.RestStr, [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&PLAINNUMBER',IntToStr(msg.Index), [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&MAIL', msg.Postemail, [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&NAME', '<B>' + msg.PostName + '</B>', [rfReplaceAll]);
  outputhtml := StringReplace(outputhtml, '&THREADURL', Topic.BrowserUrl, [rfReplaceAll]);

  strBody := DatToHtml(msg.Body);
  outputhtml := StringReplace(outputhtml, '&MESSAGE',  strBody, [rfReplaceAll]);
  outputhtml := '<a name="a' + IntToStr(msg.Index) + '"></a>' + outputhtml + #13#10;

  result := outputhtml;

end;

end.

