unit untTopicBrowser;

interface

uses
  Classes, ComCtrls, Controls,
  untTopic, SysUtils, untGlobal, Forms,
  untTool, ExtCtrls, windows, untBBSCore, BmRegExp, StrUtils,
  untHintWindow, Math, untBBSFramework;

type
  TTopicStateType = (stStatusText, stDownloadState);
  TTopicStateChangeEvent = procedure(Topic: TTopic;
                                     EventType: TTopicStateType) of object;
  TNavigateUrlEvent = procedure(sender : TObject; URL : string) of object;

  TPopupManager = class(TObject)
  private
    function GetMessages(Msgs : TList; const First, Last : Integer) : string;
    function ParseMailto(const URI : string) : string;
    function ParseJump(Topic : TTopic; const URI : string) : string;
  public
    function GetPopupMessages(Topic : TTopic; const URI : string) : string;
  end;

  TTopicBrowser = class(TPanel)
  protected
    FBBSGetTopic: TBBSGetTopic;
    FLoading: Boolean;
    FViewLimit: Integer;
    FReloadTimer: TTimer;
    FNewMsg: Boolean;
    FAutoReload: Boolean;
    FDownloading: Boolean;
    FImageIndex: integer;
    FCaption: string;
    FClearNewMsgFlag: Boolean;
    procedure SetAutoReload(const Value: Boolean);
    procedure AutoReloadTimer(sender : TObject);
    procedure RaiseNavigateUrlEvent(Url : string);
    procedure JumpMessage(msgno : integer); virtual; abstract;
    function  ChangeStatusText(statustext: string): boolean;
  public
    Topic: TTopic;
    Caption: string;
    ImageIndex: integer;
    OnNavigateUrl: TNavigateUrlEvent;
    OnMessageReceived, OnComplete: TNotifyEvent;
    OnChangeDownloadState: TNotifyEvent;
    property    AutoReload : Boolean read FAutoReload write SetAutoReload;
    procedure   SaveScrollPosition(); virtual; abstract;
    procedure   OpenTopic(tp: TTopic); virtual;
    procedure   CloseTopic(); virtual;
    procedure   Reload(); virtual;
    procedure   ClearNewMsg();
    procedure   SearchText(str : string); virtual; abstract;
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    procedure   ChangeViewLimit(NewLimit : integer); virtual; abstract;
    procedure Topic_MessageReceived(sender : TObject);  virtual; abstract;
    procedure Topic_ChangeDownloadState(Sender: TObject); virtual;
  end;

implementation

{ TopicBrowser }

//  \bh 

{ --------------------------------------------------------
  pr  : RXgN^
  l  : Ȃ
  ------------------------------------------------------ }
constructor TTopicBrowser.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  self.BevelInner := bvNone;
  self.BevelOuter := bvNone;

  FLoading := false;
  FImageIndex := -1;
  FReloadTimer := TTimer.Create(self);
  FReloadTimer.Enabled  := false;
  FReloadTimer.Interval := 60000;
  FReloadTimer.OnTimer  := AutoReloadTimer;
end;

{ --------------------------------------------------------
  pr  : fXgN^
  l  : Ȃ
  ------------------------------------------------------ }
destructor TTopicBrowser.Destroy;
begin

  FReloadTimer.Free;

  inherited;
end;

procedure TTopicBrowser.Reload;
begin
  gBBSCore.DownloadTopic(Topic, self);
end;
{ --------------------------------------------------------
  pr  : gsbNJ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.OpenTopic(tp: TTopic);

begin
  if Assigned(Topic) then
  begin
    CloseTopic();
  end;

  Topic := tp;
  if Assigned(Topic) then
  begin
    Topic.IsOpened := true;
    FCaption := Topic.Title;
    FNewMsg := false;
    FViewLimit := gConfig.ViewLimit;
    gBBSCore.DownloadTopic(Topic, self);
  end else
  begin
    FCaption := '';
  end;
end;

{ --------------------------------------------------------
  ֐: CloseTopic
  pr  : gsbN
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.CloseTopic;
begin
  if Topic <> nil then
  begin
    Topic.IsOpened := false;
    Topic.FreeMessage;
    SaveScrollPosition();
    SetAutoReload(false);
  end;

  Topic := nil;
  FCaption  := '';
  FImageIndex := -1;
end;

{ --------------------------------------------------------
  ֐: ClearNewMsg
  pr  : V}[N̎O
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopicBrowser.ClearNewMsg;
begin
  if FClearNewMsgFlag = true then
  begin
    exit;
  end;
  FClearNewMsgFlag := true;
  FNewMsg := false;
  Topic_ChangeDownloadState(Topic);
  FClearNewMsgFlag := false;
end;

//  Cxg 

// ԕω
procedure TTopicBrowser.Topic_ChangeDownloadState(Sender: TObject);
begin
  Case Topic.DownloadState of
    dsNone:
    begin
      if FNewMsg = true then
      begin
        FImageIndex := 0
      end else if FAutoReload = true then
      begin
        FImageIndex := 1
      end else
      begin
        FImageIndex := -1;
      end;

      if FDownloading = true then
      begin
        FDownloading := false;

        // vOANeBułȂ
        // ^Cgo[_ł
        if FNewMsg and (Application.Active = false) then
        begin
          FlashWindow(Application.Handle, True);
        end;
      end;
    end;
    dsError:      FImageIndex := 2;
    dsFreezed:    FImageIndex := 3;
    dsStarting:   FImageIndex := 4;
    dsProcessing: FImageIndex := 5;
    dsDatLoaded:
    begin

      //RestoreScrollPosition;

    end;
  end;

  if Assigned(OnChangeDownloadState) then
  begin
    OnChangeDownloadState(self);
  end;
end;

// I[g[h
procedure TTopicBrowser.AutoReloadTimer(sender: TObject);
begin
  if FNewMsg = false then
    Reload;
end;

//  vpeB 

// I[g[hݒ
procedure TTopicBrowser.SetAutoReload(const Value: Boolean);
begin
  FAutoReload := Value;
  FReloadTimer.Enabled := Value;
  Topic_ChangeDownloadState(Topic);
end;

//  vCx[g֐ 

procedure TTopicBrowser.RaiseNavigateUrlEvent(Url: string);
var
  msgno: integer;
  p: Integer;
  urlStr: string;
begin

  if AnsiStartsText('Jump://goto/', Url) then
  begin
    p := Pos('-', Url);
    if p <> 0 then
    begin
      urlStr := Copy(Url, 0, p - 1)
    end else
    begin
      UrlStr := Url;
    end;
    msgno := StrToIntNeo(CopyAfter(UrlStr, 13));
    JumpMessage(msgno);

  end else
  begin
    if Assigned(OnNavigateUrl) then
    begin
      OnNavigateUrl(self, Url);
    end;
  end;
end;

function TTopicBrowser.ChangeStatusText(statustext: string) : boolean;
var
  msgText  : string;
  popupManager : TPopupManager;
begin 
  popupManager := TPopupManager.Create; 
  msgText := popupManager.GetPopupMessages(Topic, statustext);

  if msgText <> '' then
  begin
    ToolTip.SetHint(msgText); 
    Result := True;
  end else 
  begin
    ToolTip.UnVisible;
    Result := False; 
  end; 

  popupManager.Free; 
end;

{ TPopupManager }

function  TPopupManager.GetMessages(Msgs : TList; const First, Last : Integer) : string;
var
  i : Integer;
  FirstPos, LastPos : Integer;
  Msg : string;
begin
  // eg. >>0
  if (First < 1) and (Last < 0) then
  begin
    Result := '';
    Exit;
  end;

  FirstPos := Max(First - 1, 0);

  LastPos := Min(Last, Msgs.Count);
  Dec(LastPos);

  // eg. >>100000 or >>10-9
  if (FirstPos >= msgs.Count) or ((LastPos >= 0) and (FirstPos > LastPos)) then
  begin
    Result := '';
    Exit;
  end;

  if LastPos > 0 then
  begin

    for i := FirstPos to LastPos do
    begin
      if I > FirstPos + 20 then
      begin
        msg := msg + '(ȗ܂)';
        break;
      end else
        msg := msg + TTopicMessage(Msgs[i]).ForPopup + #10#10
    end
  end else
    msg := TTopicMessage(Msgs[FirstPos]).ForPopup;

  Result := msg;
end;

function  TPopupManager.ParseMailto(const URI : string): string;
begin
  Result := CopyAfter(URI, 8);
end;

// \n+(-\n+)? only
function  TPopupManager.ParseJump(Topic : TTopic; const URI : string): string;
var
  Text : string;
  p : Integer;
  First , Last : Integer;

begin
  Text := CopyAfter(URI, 13);

  p := Pos('-', Text);
  if p <> 0 then
  begin
    First := StrToInt(Copy(Text, 0, p - 1));
    Last  := StrToInt(Copy(Text, p + 1, Length(Text)));
  end else
  begin
    First := StrToInt(Text);
    Last  := -1;
  end;

  Result := GetMessages(Topic.MessageList, First, Last);
end;

function TPopupManager.GetPopupMessages(Topic: TTopic; const URI: string): string;
begin
  if Copy(URI, 1, 7) = 'mailto:' then
    Result := ParseMailto(URI)
  else if Copy(URI, 1, 12) = 'jump://goto/' then
    Result := ParseJump(Topic, URI)
  else
    Result := '';
end;

end.
