unit untAllSubscribedTopicsLoadThread;

interface

uses
  Classes, SysUtils, StrUtils,
  RegExpr,
  untBoard, untGlobal,
  IdThreadMgr, IdThread;

type

  TAllSubscribedTopicsLoadThread = class(TIdThread)
  private
    onlineBoard: TOnlineBoard;
    topicId: string;
    procedure LoadLog(const path: string);
    procedure AddTopic;
  public
    Board: TAllSubscribedTopics;
    procedure Run; override;
  end;

implementation

uses
  untConfig, untTopic;

{ TAllSubscribedTopicsLoadThread }

procedure TAllSubscribedTopicsLoadThread.Run;
var
  path : string;
begin
  inherited;

  Board.IsDownloading := true;

  path := DIR_LOG;
  if AnsiEndsText('\', DIR_LOG) then
  begin
    path := Copy(path, 0, Length(path) - 1);
  end;
  LoadLog(path);

  Board.IsDownloading := false;

  Stop();
end;

//  vCx[g֐ 

{ --------------------------------------------------------
  ֐: LoadLog
  pr  : O̓ǂݍ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TAllSubscribedTopicsLoadThread.LoadLog(const path: string);
var
  regex: TRegExpr;
  searchRec: TSearchRec;
  foundPath: string;
  server: string;
  boardname: string;

begin
  regex := TRegExpr.Create;
  regex.Expression := '^' + DIR_LOG + '\' + '(.+?)\\(.+?)\\(.+?)\.i';

  if FindFirst(path +  '\*.*', faAnyFile, searchRec) = 0 then
  begin
    repeat
      if (searchRec.Name <> '.') and (searchRec.Name <> '..') then
      begin
        foundPath := path + '\' + searchRec.Name;

        if (searchRec.Attr and faDirectory) <> 0 then
        begin
          LoadLog(foundPath);
        end;

        if AnsiEndsText('.i', searchRec.Name) then
        begin
          // gsbN̓ǂݍ
          if Regex.Exec(foundPath) then
          begin
            server      := Regex.Substitute('$1');
            boardname   := Regex.Substitute('$2');
            topicid     := Regex.Substitute('$3');
            onlineBoard := gBoardList.GetBoard(server, boardname);

            Synchronize(AddTopic);
          end;
        end;
      end;
    until FindNext(searchRec) <> 0;
    FindClose(searchRec);
  end;
  Regex.Free;
end;

procedure TAllSubscribedTopicsLoadThread.AddTopic;
var
  topic: TTopic;
  
begin
  topic := gBBSCore.GetTopic(onlineBoard, topicid);
  self.Board.AddTopic(topic);
end;

end.

