unit untTopic;

interface

uses
  SysUtils, Classes, Contnrs, Dialogs, Forms, DzURL, BmRegexp,
  untTool, SyncObjs, untStreamTool,
  untBBSSub, RegExpr;

type

  TTopicMessage = class
  private
    function GetForPopup: string;
  public
    Index        : Integer;
    Body         : string;
    PostName     : string;
		Postemail    : string;
    RestStr      : string;
    IsNewMessage : Boolean;
    property ForPopup: string read GetForPopup;
  end;

  TDownloadState = (dsNone, dsStarting, dsProcessing, dsDatLoaded, dsError, dsFreezed);
  TWriteDoneEvent = procedure(sender : TObject; ErrorMessage : string) of object;

  TTopic = class
  private
    FBoardName: string;
    FBoardServer: string;
    FBoardId: string;
    FMessageList: TList;
    FDefaultTopicChangeDownloadStateFunction: TNotifyEvent;
    function  GetDatUrl: string;
    function  GetBrowserUrl: string;
    procedure SetDefaultTopicChangeDownloadStateFunction(const Value: TNotifyEvent);
  protected
  public
    IsGotLog: boolean;
    IsFavorite: boolean;
    IsInBox: boolean;
    IsError: Boolean;
    IsDownloadingTopic: Boolean;
    IsPosingArticle: Boolean;
    IsFreezed: boolean;
    IsOpened: boolean;
    Loaded: boolean;
    GZip: Boolean;
    TopicId: string;
    TopicPath: string;
    Title: string;
    MessageCount: Integer;
    Index: Integer;
    Board: TObject;
    GotMessageCount: Integer;
    NewMessageCount: Integer;
    WroteName: string;
    WroteEmail: string;
    ScrollPosition: Integer;
    LocalDir: string;
    Priority: Integer;
    Memo: string;
    LoadedNumber: integer;
    LastModified: string;
    NewReceivedMessage: TTopicMessage;
    WriteError: string;
    LastReadDate: string;
    LastWriteDate: string;
    NoIndex: Boolean;
    StatusText: string;
    DownloadState: TDownloadState;
    DatSize: integer;
    property DatUrl: string read GetDatUrl;
    property BrowserUrl: string read GetBrowserUrl;
    property MessageList: TList read FMessageList;
    procedure LoadLog;
    procedure SaveToLog(const newDat: string);
    constructor Create(b : TObject; ti : string);
    destructor  Destroy(); override;
    procedure SaveIdx();
    procedure CheckWriteFolder;
    procedure EraseLog;
    procedure EraseMessageList;
    procedure AddNewMessage(msg : TTopicMessage);
    property  DefaultTopicChangeDownloadStateFunction : TNotifyEvent read FDefaultTopicChangeDownloadStateFunction write SetDefaultTopicChangeDownloadStateFunction;
    procedure FreeMessage;
    function ParseDat(const line: string; var Title: string): TTopicMessage;
  end;

implementation

uses
  untBoard, untGlobal, untBBSCore;


{ TTopic }

procedure TTopic.SaveToLog(const newDat: string);
var
  logpath: string;
  datFile: TextFile;

begin
  // DATt@C̏o
  logpath := LocalDir + TopicId + '.d';
  AssignFile(datFile, logpath);
  if not FileExists(logpath) then
  begin
    ReWrite(datFile);
  end;
  Append(datFile);
  Write(datFile, newDat);
  Flush(datFile);
  CloseFile(datFile);
end;


procedure TTopic.LoadLog;
var
  i, j        : Integer;
  msg         : TTopicMessage;
  logpath     : string;
  lines       : TStringList;
  items       : TStringArray;
  title       : string;

begin
  if Loaded then
  begin
    exit;
  end;

  SetLength(items, 0);

  lines := TStringList.Create;

  logpath := LocalDir + TopicId + '.d';

  if FileExists(logpath) = true then
  begin
    // [Jǂݍ
    lines.LoadFromFile(logpath);
    for i := 0 to lines.Count - 1 do
    begin
      msg := ParseDat(lines[i], Title);
      AddNewMessage(msg);
{      if msg.Index > LoadedIndex then
      begin
        msg.IsNewMessage := true;
      end;
}
      if (i = 0) and (title <> '') then
      begin
        self.Title := title;
      end;
    end;
  end else
  begin
    // Of[^AÂ``
    // ÔȂ炻炩ǂݍ
    logpath := LocalDir + TopicId + '.dat';
    if FileExists(logpath) then
    begin
      lines.LoadFromFile(logpath);
      for i := 0 to lines.Count - 1 do
      begin
        items := Split(lines[i], ',');
        for j := 0 to 3 do
        begin
          items[j] := StringReplace(items[j], 'M', ',', [rfReplaceAll]);
        end;

        msg := TTopicMessage.Create;
        msg.PostName  := items[0];
        msg.PostEmail := items[1];
        msg.RestStr   := items[2];
        msg.Body      := items[3];
        AddNewMessage(msg);
      end;
    end;
{        FNewDat := FNewDat    +
                   msgName    + '<>'
                 + msgEmail   + '<>'
                 + msgRestStr + '<>'
                 + msgBody    + #13#10;
}
  end;
  lines.Free;
  if MessageList.Count > 0 then
  begin
  	GotMessagecount := MessageList.Count;

    DownloadState := dsDatLoaded;
  end;
end;

function TTopic.ParseDat(const line: string; var Title: string): TTopicMessage;
var
  items: TStringArray;
  msg: TTopicMessage;

begin
  msg := TTopicMessage.Create;
  items := Split(line, '<>');
  if Length(items) > 3 then
  begin
    msg.PostName  := items[0];
    msg.PostEmail := items[1];
    msg.RestStr   := items[2];
    msg.Body      := items[3];
  end;

  Title := '';
  if Length(items) > 4 then
  begin
    Title := items[4];
  end;

  result := msg
end;

//  vpeB 
function TTopic.GetDatUrl: string;
var
  b : TOnlineBoard;
begin
  //UpdateBoardInfo();
  b := TOnlineBoard(Board);

  if b.BBSType = btJBBS then
    result := 'http://' + b.Server
            + '/bbs/read.cgi?BBS=' + b.BoardName
            + '&KEY=' + TopicId
  else
  	result := 'http://' + b.Server + '/'
            + b.BoardName  +	'/dat/'
            + TopicId + '.dat';
end;

function TTopic.GetBrowserUrl : string;
var
  b : TOnlineBoard;
begin
  b := TOnlineBoard(Board);

  if b.BBSType = btJBBS then
    result := 'http://' + b.Server
            + '/bbs/read.cgi?BBS=' + b.BoardName
            + '&KEY=' + TopicId
  else
    result := 'http://' + b.Server + '/test/read.cgi/'  +
              b.BoardName  + '/' + TopicId + '/';
end;

//  \bh 

{ --------------------------------------------------------
  pr  : RXgN^
  l  : Ȃ
  ------------------------------------------------------ }
constructor TTopic.Create(b: TObject; ti: string);
var
  idxpath      : string;
  idxlines     : TStringList;
  idxitems     : TStringArray;
  state        : Integer;
  onlineboard  : TOnlineBoard;
  
label
  NoIdx;

begin
  Loaded := false;

  Board   := b;
  TopicId := ti;

  SetLength(idxitems, 0);

  GotMessageCount := 0;
  NewMessageCount := 0;

  onlineboard := TOnlineBoard(Board);
  if not gFolderAlias.GetFolderPath(onlineboard.Server, onlineboard.BoardName, TopicId + '.i', LocalDir) then
  begin
    gFolderAlias.GetFolderPath(onlineboard.Server, onlineboard.BoardName, TopicId + '.idx', LocalDir)
  end;

  // IDX t@CΓǂݍ
  NoIndex := true;
  if DirectoryExists(LocalDir) = true then
  begin
    idxpath := localdir + TopicId + '.i';
    if FileExists(idxpath) = false then
    begin
      idxpath := localdir + TopicId + '.idx';
      if FileExists(idxpath) = false then
      begin
        goto NoIdx;
      end;
    end;

    idxlines := TStringList.Create();
    idxlines.LoadFromFile(idxpath);
    if idxlines.Count > 0 then
    begin
      idxitems := Split(idxlines[0], #9);
      if Length(idxitems) >= 18 then
      begin
        NoIndex := false;

        state := StrToIntNeo(idxitems[1]);
        IsFreezed       := Boolean(state and 16);
        IsGotLog        := Boolean(state and 32);
        IsFavorite      := Boolean(state and 64);

        Priority        := StrToInt(idxitems[2]);
        Title           := idxitems[3];
        MessageCount    := StrToInt(idxitems[7]);
        GotMessageCount := StrToInt(idxitems[8]);
        NewMessageCount := StrToInt(idxitems[9]);
        LastReadDate    := idxitems[10];
        LastWriteDate   := idxitems[11];
        FBoardName       := idxitems[12];
        DatSize         := StrToInt(idxitems[13]);
        WroteName       := idxitems[14];
        WroteEmail      := idxitems[15];
        ScrollPosition  := StrToInt(idxitems[16]);
        Memo            := idxitems[17];
      end;

      // only 88 item
      if Length(idxitems) > 21 then
        LastModified    := idxitems[21];

      // ver0.23 add
      if Length(idxitems) > 22 then
      begin
        state    := StrToIntNeo(idxitems[22]);
        IsInBox := Boolean(state and 16);
        Gzip    := Boolean(state and 32);
      end;

    end;
    idxlines.Free;
  end;

NoIdx:
  FMessageList := TList.Create;
end;

{ --------------------------------------------------------
  pr  : fXgN^
  l  : Ȃ
  ------------------------------------------------------ }
destructor TTopic.Destroy;
begin
  FreeMessage;
  FMessageList.Free;
  inherited;
end;

{ --------------------------------------------------------
  pr  : Idxt@C̋L^
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.SaveIdx;
var
  line    : string;
  state   : Integer;
  state2  : Integer;
  idxpath : string;
begin

  CheckWriteFolder;

  NoIndex := false;

  state := 0;
  if(IsFreezed)  then state := state or 16;
  if(IsGotLog)   then state := state or 32;
	if(IsFavorite) then state := state or 64;

  state2 := 0;
  if(IsInBox)    then state2 := state2 or 16;
  if(GZip)       then state2 := state2 or 32;

  line := '88' + #9 +
          IntToStr(state) + #9 +
					IntToStr(Priority) + #9 +
					Title + #9 +
          FBoardServer + #9 +
					FBoardId + #9 +
				  TopicId + #9 +
					IntToStr(MessageCount) + #9 +
					IntToStr(GotMessageCount) + #9 +
					IntToStr(NewMessageCount) + #9 +
					LastReadDate  + #9 +
					LastWriteDate + #9	+
					FBoardName + #9 +
					IntToStr(Datsize) + #9 +
					WroteName + #9 +
					WroteEmail + #9 +
					IntToStr(ScrollPosition) + #9 +
					Memo + #9 +
          #9 +
          #9 +
          #9 +
          LastModified + #9 +
          IntToStr(state2) + #9;

  // ۑ
  idxpath := LocalDir + TopicId + '.i';
  WriteFile(idxpath, line);
end;

procedure TTopic.FreeMessage;
var
  i: Integer;

begin
  for i := 0 to FMessageList.Count - 1 do
  begin
    TTopicMessage(FMessageList[i]).Free;
  end;
  FMessageList.Clear;
  Loaded := false;
end;

procedure TTopic.EraseMessageList;
var
  datpath : string;
begin
	datpath := LocalDir + TopicId + '.d';
  DeleteFile(datpath);
  FreeMessage;
  Messagecount    := 0;
  GotMessageCount := 0;
  NewMessageCount := 0;
  Datsize         := 0;
end;

{ --------------------------------------------------------
  pr  : O̍폜
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.EraseLog;
var
  idxpath : string;
  datpath : string;

begin
  Application.ProcessMessages;
  // 폜
  idxpath := LocalDir + TopicId + '.i';
	datpath := LocalDir + TopicId + '.d';
  DeleteFile(idxpath);
  DeleteFile(datpath);

  FreeMessage;
//  FMessagecount    := 0;
  Priority        := 0;
  Gotmessagecount := 0;
  Newmessagecount := 0;
  LastReadDate    := '';
  LastWriteDate   := '';
  Memo            := '';
  Isgotlog        := false;
  Datsize         := 0;

  if IsFavorite then
  begin
    gBoardList.FavoriteBoard.RemoveTopic(self);
  end;
  StatusText := 'u' + Title + 'ṽO폜܂';
end;

//  vCx[g֐ 
procedure TTopic.CheckWriteFolder;
begin

  // tH_Ȃ΍
  if DirectoryExists(LocalDir) = false then
  begin
    CreateFullDir(LocalDir);
  end;
end;

procedure TTopic.AddNewMessage(msg: TTopicMessage);
begin
  msg.Index := FMessageList.Count + 1;
  FMessageList.Add(msg);
end;

procedure TTopic.SetDefaultTopicChangeDownloadStateFunction(
  const Value: TNotifyEvent);
begin
  FDefaultTopicChangeDownloadStateFunction := Value;
end;


{ TTopicMessage }

// |bvAbvp̃bZ[W
function TTopicMessage.GetForPopup: string;
var
  puretext : string;
  regex    : TRegExpr;
begin

  puretext := IntToStr(Index)       + ' ' +
              'OF'   + PostName + ' ' +
              'eF' + RestStr  + #10 +
              Body;

  // HTML^O
	puretext := StringReplace(puretext, '<br>', #10, [rfReplaceAll]);
  regex := TRegExpr.Create;
  regex.Expression := '<.*?>';
  puretext := regex.Replace(puretext, '');
  regex.Free;

  // ꕶϊ
  puretext := StringReplace(puretext, '&gt;', '>', [rfReplaceAll]);
  puretext := StringReplace(puretext, '&lt;', '<', [rfReplaceAll]);

  result := puretext;

end;

end.
