unit untBoard;

interface

uses
  SysUtils, untTool, Classes, Forms, StrUtils,
  untBBSSub, RegExpr, untTopic;

type

  TTopicReceivedEvent = procedure(Sender : TObject; Topic : TTopic) of object;
  
  TBoard = class
  private
    FCategory     : string;
    FDisplayName  : string;
    FOnTopicReceived: TTopicReceivedEvent;
    FIsDownloading: boolean;
    FBoardid: integer;
    procedure SetOnTopicReceived(const Value: TTopicReceivedEvent);
    procedure SetIsDownloading(const Value: boolean);
    procedure SetCategory(const Value: string);
    procedure SetDisplayName(const Value: string);
    procedure SetBoardid(const Value: integer);
  public
		property  Category    : string read FCategory write SetCategory;
		property  DisplayName : string read FDisplayName write SetDisplayName;
		property  Boardid     : integer read FBoardid write SetBoardid;
    property  OnTopicReceived : TTopicReceivedEvent read FOnTopicReceived write SetOnTopicReceived;
    property  IsDownloading : boolean read FIsDownloading write SetIsDownloading;
    constructor Create(BoardId : integer);
    procedure Download(); virtual; abstract;
    procedure RaiseTopicReceivedEvent(Topic: TTopic);
  end;

  TOnlineBoard = class(TBoard)
  private
    FModTime  : Integer; 
    FWriteError: string;
    FBBSType: TBBSType;
    FServer: string;
    FBoardName: string;
    procedure SetServer(const Value: string);
    function  GetBoardUrl()   : string;
    function  GetSubjectTxtUrl: string;
    function  GetBbsCgiUrl  : string;
    procedure SetModTime(const Value : Integer);
    procedure SetWriteError(const Value: string);
    procedure SetBBSType(const Value: TBBSType);
    procedure SetBoardName(const Value: string);
  public
    property  BBSType       : TBBSType read FBBSType write SetBBSType;
    property  BoardUrl      : string read GetBoardUrl;
    property  SubjectTxtUrl : string read GetSubjectTxtUrl;
    property  BbsCgiUrl     : string read GetBbsCgiUrl;
    property  WriteError    : string read FWriteError write SetWriteError;
    property  Server        : string read FServer write SetServer;
    property  BoardName     : string read FBoardName write SetBoardName;
    property  ModTime       : Integer read FModTime write SetModTime;
    procedure Download(); override;
    destructor Destroy; override;
  end;

  TOfflineBoard = class(TBoard)
  private
    FLoadedLog : Boolean;
    FIdxPath   : string;
    FTopicList : TList;
    procedure LoadLog();
  public
    constructor Create(BoardId : integer; idxpath : string);
    destructor  Destroy; override;
    procedure Download(); override;
    procedure AppendTopic(Topic: TTopic);
    procedure RemoveTopic(Topic: TTopic);
    procedure Save(); virtual;
    procedure Patrol();
    function  IsHave(Topic: TTopic) : boolean;
    procedure Sort(Compare: TListSortCompare);
  end;

  TAllSubscribedTopics = class(TOfflineBoard)
  private
    FLoadedLog : Boolean;
    procedure ThreadTerminated(Sender: TObject);
  public
    constructor Create(BoardId : Integer);
    destructor  Destroy; override;
    procedure Download(); override;
    procedure AddTopic(topic: TTopic);
    procedure Save; override;
  end;

implementation

uses
  untGlobal, untAllSubscribedTopicsLoadThread;

{ TBoard }

//  vpeB 

procedure TBoard.SetBoardid(const Value: integer);
begin
  FBoardid := Value;
end;

procedure TBoard.SetCategory(const Value: string);
begin
  FCategory := Value;
end;

procedure TBoard.SetDisplayName(const Value: string);
begin
  FDisplayName := Value;
end;

procedure TBoard.SetOnTopicReceived(const Value: TTopicReceivedEvent);
begin
  FOnTopicReceived := Value;
end;

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : BoardId
  @@@: DisplayName
  @@@; Category
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TBoard.Create(BoardId : integer);
begin
  FBoardId := BoardId;
end;

{ --------------------------------------------------------
  ֐: RaiseTopicReceivedEvent
  pr  : TopicM|`Cxg𔭍s
    : Topic
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBoard.RaiseTopicReceivedEvent(Topic: TTopic);
begin
  if Assigned(FOnTopicReceived) then
  begin
    FOnTopicReceived(self, Topic);
  end;
end;

{ TOnlineBoard }

//  vpeB 

procedure TOnlineBoard.SetServer(const Value: string);
begin
  FServer := Value;

  // BBSType𔻒f

  if Pos('jbbs', Value) > 0 then
    FBBSType := btJBBS
  else if Pos('machibbs.com', Value) > 0 then
    FBBSType := btJBBS
  else if Pos('shitaraba.com', Value) > 0 then
    FBBSType := btShitaraba
  else if Pos('www.mitinoku.jp', Value) > 0 then
    FBBSType := btMitinoku
  else
    FBBSType := bt2ch;

end;

procedure TOnlineBoard.SetBoardName(const Value: string);
begin
  FBoardName := Value;
end;

procedure TOnlineBoard.SetWriteError(const Value: string);
begin
  FWriteError := Value;
end;

procedure TBoard.SetIsDownloading(const Value: boolean);
begin
  FIsDownloading := Value;
end;

procedure TOnlineBoard.SetBBSType(const Value: TBBSType);
begin
  FBBSType := Value;
end;

function TOnlineBoard.GetBoardUrl: string;
begin
  result := 'http://' + FServer + '/' + FBoardName + '/';
end;

function TOnlineBoard.GetSubjectTxtUrl: string;
begin
  result := GetBoardUrl() + 'subject.txt';
end;

function TOnlineBoard.GetBbsCgiUrl: string;
begin
  result := 'http://' + FServer + '/test/bbs.cgi';
end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TOnlineBoard.Destroy;
begin

  inherited;
end;

procedure TOnlineBoard.Download;
begin
  inherited;

  gBBSCore.DownloadBoard(self);
end;


//  Cxg 

{ TOfflineBoard }

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : idxpath
  @@@: BoardName
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TOfflineBoard.Create(BoardId: integer; idxpath: string);
begin
  inherited Create(BoardId);

  FIdxPath := idxpath;
  FTopicList := TList.Create;
end;

{ --------------------------------------------------------
  ֐: Download
  pr  : gsbN̎MJn
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TOfflineBoard.Download;
var
  i: Integer;

begin
  inherited;

  FLoadedLog := false;
  FTopicList.Clear;
  LoadLog();

  for i := 0 to FTopicList.Count - 1 do
  begin
    RaiseTopicReceivedEvent(FTopicList[i]);
  end;
end;

{ --------------------------------------------------------
  ֐: AppendTopic
  pr  : gsbN̒ǉ
    : Topic
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TOfflineBoard.AppendTopic(Topic: TTopic);
begin
  FLoadedLog := false;
  FTopicList.Clear;
  LoadLog();

  FTopicList.Insert(0, Topic);
  //Topic.SaveIdx;
  Save();
end;

{ --------------------------------------------------------
  ֐: RemoveTopic
  pr  : gsbN̍폜
    : Topic
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TOfflineBoard.RemoveTopic(Topic: TTopic);
begin

  FLoadedLog := false;
  FTopicList.Clear;
  LoadLog();

  FTopicList.Remove(Topic);
  //Topic.SaveIdx;
  Save();
end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TOfflineBoard.Destroy;
begin
  FTopicList.Free;

  inherited;
end;

{ --------------------------------------------------------
  ֐: Patrol
  pr  : 
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TOfflineBoard.Patrol;
var
  i: Integer;
  topic: TTopic;

begin
  LoadLog();

  for i := 0 to FTopicList.Count - 1 do
  begin
    Application.ProcessMessages;
    topic := TTopic(FTopicList[i]);

    //*: Ń^u̐V}[N͂
    //Ȃ΂ȂȂBۗB

    gBBSCore.DownloadTopic(topic, self);
    // Ŏ擾bZ[W͍폜Ȃ
    // XJƂŏɕ\Ă܂
    topic.FreeMessage;
  end;
end;

//  vCx[g֐ 

{ --------------------------------------------------------
  ֐: LoadLog
  pr  : O̓ǂݍ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TOfflineBoard.LoadLog;
var
  stlLog    : TStringList;
  topic     : TTopic;
  i         : Integer;
  regex     : TRegExpr;
  server    : string;
  boardname : string;
  topicid   : string;
  board     : TOnlineBoard;
begin

  regex := TRegExpr.Create;
  try
    regex.Expression := '^(.+?)\\(.+?)\\(.+?)\.idx';

    if FLoadedLog = false then
    begin
      if FileExists(FIdxPath) then
      begin

        stlLog := TStringList.Create;
        stlLog.LoadFromFile(FIdxPath);

        // gsbN̓ǂݍ
        for i := 0 to stlLog.Count - 1 do
        begin
          if (stlLog[i] <> '') and (Regex.Exec(stlLog[i])) then
          begin
            server    := Regex.Substitute('$1');
            boardname := Regex.Substitute('$2');
            topicid   := Regex.Substitute('$3');
            board := gBoardList.GetBoard(server, boardname);

            topic := gBBSCore.GetTopic(board, topicid);
            topic.IsInBox := true;
            FTopicList.Add(topic);
          end;
        end;
        stlLog.Free;
      end;
      FLoadedLog := true;
    end;
  finally
    regex.Free;
  end;
end;

{ --------------------------------------------------------
  ֐: Save
  pr  : ۑ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TOfflineBoard.Save;
var
  i       : Integer;
  topic   : TTopic;
  stlSave : TStringList;
  board   : TOnlineBoard;
begin

  LoadLog();

  stlSave := TStringList.Create;
  try
    for i := 0 to FTopicList.Count - 1 do
    begin
      topic := TTopic(FTopicList[i]);
      board := TOnlineBoard(topic.Board);
      stlSave.Add(board.Server + '\' + board.BoardName + '\' + topic.TopicId + '.idx');
    end;
    stlSave.SaveToFile(FIdxPath);
  finally
    stlSave.Free;
  end;
end;

function TOfflineBoard.IsHave(Topic: TTopic): boolean;
begin
  LoadLog();

  if FTopicList.IndexOf(Topic) > -1 then
  begin
    result := true
  end else
  begin
    result := false;
  end;
end;

procedure TOnlineBoard.SetModTime(const Value : Integer); 
begin 
  FModTime := Value; 
end;

{ --------------------------------------------------------
  ֐: Sort
  pr  : ёւ
    : Compare
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TOfflineBoard.Sort(Compare: TListSortCompare);
begin
  FTopicList.Sort(Compare);
end;

{ TAllSubscribedTopics }

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : BoardId
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TAllSubscribedTopics.Create(BoardId: Integer);
begin
  inherited Create(BoardId, AppPath('g܂'));

  FLoadedLog := False;
end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TAllSubscribedTopics.Destroy;
begin
  inherited;
end;

{ --------------------------------------------------------
  pr  : gsbN̎MJn
  l  : Ȃ
  ------------------------------------------------------ }
procedure TAllSubscribedTopics.Download;
var
  aThread: TAllSubscribedTopicsLoadThread;

begin
  FTopicList.Clear;

  aThread := TAllSubscribedTopicsLoadThread.Create(true);
  with aThread do
  begin
    FreeOnTerminate := True;
    OnTerminate := ThreadTerminated;
    Board := self;
    Start;
  end;
end;

procedure TAllSubscribedTopics.ThreadTerminated(Sender: TObject);
begin
  if FLoadedLog = false then
  begin
    FLoadedLog := true;
  end;
end;

procedure TAllSubscribedTopics.AddTopic(topic: TTopic);
begin
  FTopicList.Add(topic);

  inherited RaiseTopicReceivedEvent(topic);
end;

procedure TAllSubscribedTopics.Save;
begin
  // S擾̓t@CɕۑȂ
end;
end.
