unit untBBSCore;

interface

uses
  Classes, Contnrs, SyncObjs, SysUtils, Forms,
  untBoard, untBBSFramework, untTopic;

type
  TBoardStateType = (bsTopicReceived, bsWriteDone);
  TBoardStateChangeEvent = procedure(Board: TBoard;
                                     EventType: TBoardStateType) of object;

  TBBSCore = class
  private
    FTopicCache: TStringList;
    FTopicErase: TStringList;
    FBoardStateChangeEvents : array of TBoardStateChangeEvent;
    FDefaultTopicChangeDownloadStateFunction: TNotifyEvent;
    procedure SetDefaultTopicChangeDownloadStateFunction(
                                  const Value: TNotifyEvent);
  public
    constructor Create;
    destructor  Destroy; override;
    procedure DownloadBoard(aboard: TOnlineBoard);
    procedure GC;
    procedure AddBoardStateChangeEvent(Item: TBoardStateChangeEvent);
    procedure RemoveBoardStateChangeEvent(Item: TBoardStateChangeEvent);
    procedure RaiseBoardStateChangeEvent(Board : TBoard;
                                         EventType: TBoardStateType);
    procedure FreeTopic(const Topic: TTopic);

    function  GetTopic(Board : TOnlineBoard; TopicId: string): TTopic;
    function  GetTopicByURL(URL : string) : TTopic;
    function  PostArticle(Board: TOnlineBoard;
                          TopicId, PostName, PostEmail,PostBody: string): TThread;
    procedure MakeTopic(Board: TOnlineBoard;
                        Title, PostName, PostEmail, PostBody: string);

    property  DefaultTopicChangeDownloadStateFunction: TNotifyEvent read FDefaultTopicChangeDownloadStateFunction write SetDefaultTopicChangeDownloadStateFunction;
    procedure DownloadTopic(tp: TTopic; sender: TObject);
  end;

implementation

uses
  untBBS2ch,
  untBBS2chKako,  
  untTopicPostThread,
  untGlobal,
  untTopicBrowser;

//  \bh 

procedure TBBSCore.DownloadTopic(tp: TTopic; sender: TObject);
var
  topicBrowser: TTopicBrowser;
  bbsTopic: TBBSGetTopic;
  board: TOnlineBoard;

begin
  board := TOnlineBoard(tp.Board);
  bbsTopic := CreateBBSGetTopic(board.Server, board.BoardName, tp.TopicId);

  with bbsTopic do
  begin
    if Sender is TTopicBrowser then
    begin
      topicBrowser          := TTopicBrowser(Sender);
      OnChangeDownloadState := topicBrowser.Topic_ChangeDownloadState;
      OnMessageReceived     := topicBrowser.Topic_MessageReceived;
    end;
    Download(tp);
  end;

  // ʐMJn
  if bbsTopic is TBBS2chGetTopic then
  begin
    if TBBS2chGetTopic(bbsTopic).ResponseCode = 416 then
    begin
      // W[sȂŏŃgC
      bbsTopic.Retry(tp);
    end else if (bbsTopic.ErrorCode = etAbone) or
                (bbsTopic.ErrorCode = etParse) or
                (bbsTopic.ErrorCode = etBrokenGZip) then
    begin
      // ځ[񂩉̓G[gzipĂȂ烊gC
      bbsTopic.Retry(tp);
    end else if TBBS2chGetTopic(bbsTopic).Freezed then
    begin
      // DAT
      bbsTopic.Free;
      bbsTopic := CreateBBSGetTopic(board.Server, board.BoardName, tp.TopicId, btKako);
      bbsTopic.Download(tp);
    end;
  end;

  if (gConfig.SessionId <> '') and
     (bbsTopic is TBBS2chGetKakoTopic) and
     not TBBS2chGetKakoTopic(bbsTopic).IsExists then
  begin
    bbsTopic.Free;
    bbsTopic := CreateBBSGetTopic(board.Server, board.BoardName, tp.TopicId, btDolib);
    bbsTopic.Download(tp);
  end;
  bbsTopic.Free;
end;

{ --------------------------------------------------------
  pr  : RXgN^
  l  : Ȃ
  ------------------------------------------------------ }
constructor TBBSCore.Create;
begin
  FTopicCache := TStringList.Create;
  FTopicErase := TStringList.Create;
  FTopicCache.Sorted := true;
end;

{ --------------------------------------------------------
  pr  : fXgN^
  l  : Ȃ
  ------------------------------------------------------ }
destructor TBBSCore.Destroy;
var
  i : integer;
begin

  for i := 0 to FTopicCache.Count - 1 do
  begin
    FTopicErase.Add(FTopicCache[i]);
  end;
  GC;
  FTopicCache.Free;
  FTopicErase.Free;
  inherited;
end;

procedure TBBSCore.GC;
var
  i, j: integer;
begin
  // ݔ
  for i := 0 to FTopicErase.Count - 1 do
  begin
    j := FTopicCache.IndexOf(FTopicErase[i]);
    // Ƃ͍폜
    if j <> -1 then
    begin
      FTopicCache.Objects[j].Free;
      FTopicCache.Delete(j);
    end;
  end;
  FTopicErase.Clear;
end;


procedure TBBSCore.FreeTopic(const Topic: TTopic);
var
  index: integer;

begin
  index := FTopicCache.IndexOf(Topic.TopicPath);
  if index > - 1 then
  begin
    if not Topic.IsOpened then
    begin
      FTopicErase.Add(Topic.TopicPath);
    end;
  end;
end;

{ --------------------------------------------------------
  pr  : gsbN̎擾
  l  : Ȃ
  ------------------------------------------------------ }
function TBBSCore.GetTopic(Board : TOnlineBoard; TopicId: string): TTopic;
var
  index: Integer;
  newtopic: TTopic;
  topicPath: string;
begin
  newtopic := nil;
  // LbVǂݎ
  topicPath := IntToStr(Board.BoardId) + ':' + TopicId;
  index := FTopicCache.IndexOf(topicPath);
  if index > - 1 then
  begin
    newtopic := TTopic(FTopicCache.Objects[index]);
  end;

  // VgsbN
  if newtopic = nil then
  begin
    newtopic := TTopic.Create(Board, TopicId);
    newtopic.DefaultTopicChangeDownloadStateFunction := FDefaultTopicChangeDownloadStateFunction;
    newtopic.TopicPath := topicPath;
    FTopicCache.AddObject(topicPath, newtopic);
  end;

  result := newtopic;
end;

{ --------------------------------------------------------
  pr  : gsbN̎擾
  l  : Ȃ
  ------------------------------------------------------ }
function TBBSCore.GetTopicByURL(URL: string): TTopic;
begin
  result := nil;
end;


{ --------------------------------------------------------
  pr  : gsbNXg̃_E[h
    : OnlineBoard - Ώۂ̃{[h
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.DownloadBoard(aboard: TOnlineBoard);
var
  BBSTopicList : TBBSGetTopicList;

begin
  aBoard.IsDownloading := true;
  BBSTopicList := CreateBBSGetTopicList(aBoard.Server, aBoard.BoardName);
  with BBSTopicList do
  begin
    Board := aBoard;
    Get;
    Free;
  end;
  aBoard.IsDownloading := false;
end;

{ --------------------------------------------------------
  ֐: PostArticle
  pr  : bZ[W̓e
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
function TBBSCore.PostArticle(Board: TOnlineBoard;
                              TopicId, PostName, PostEmail, PostBody: string): TThread;
var
  PostThread : TTopicPostThread;
begin

  // epXbh𗧂グ
  PostThread := TTopicPostThread.Create(Board, TopicId, '', PostName, PostEmail, PostBody);
  PostThread.Priority := tpLower;
  PostThread.FreeOnTerminate := true;
  result := PostThread;
end;

{ --------------------------------------------------------
  ֐: MakeTopic
  pr  : gsbN̍쐬
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.MakeTopic(Board: TOnlineBoard; Title, PostName, PostEmail,
  PostBody: string);
var
  PostThread : TTopicPostThread;
begin

  // epXbh𗧂グ
  PostThread := TTopicPostThread.Create(Board, '', Title, PostName, PostEmail, PostBody);
  PostThread.Priority := tpLower;
  PostThread.Resume;
end;

{ --------------------------------------------------------
  ֐: AddBoardStateChangeEvent
  pr  : {[hXVCxgւ̓o^
    : Item -
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.AddBoardStateChangeEvent(Item: TBoardStateChangeEvent);
var
  intLength : integer;
begin

  intLength := Length(FBoardStateChangeEvents);
  SetLength(FBoardStateChangeEvents, intLength + 1);
  FBoardStateChangeEvents[intLength] := Item;

  //FBoardStateChangeEvents.Add(Item);
end;

{ --------------------------------------------------------
  ֐: RemoveBoardStateChangeEvent
  pr  : {[hXVCxg폜
    : Item - 
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.RemoveBoardStateChangeEvent(
  Item: TBoardStateChangeEvent);
var
  I : Integer;
  intMax : integer;
begin

  intMax := Length(FBoardStateChangeEvents) - 1;
  for I := 0 to intMax do
    if @FBoardStateChangeEvents[I] = @Item then
    begin
      FBoardStateChangeEvents[I] := FBoardStateChangeEvents[intMax];
      break;
    end;

  SetLength(FBoardStateChangeEvents, intMax);

end;

{ --------------------------------------------------------
  ֐: RaiseBoardStateChangeEvent
  pr  : Cxg̔s
    : Board     - gsbN
  @@@: EventType - Cxg̎
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.RaiseBoardStateChangeEvent(Board: TBoard;
  EventType: TBoardStateType);
var
  I : integer;
begin

  for I := 0 to Length(FBoardStateChangeEvents) - 1 do
    if Assigned(FBoardStateChangeEvents[I]) then
      TBoardStateChangeEvent(FBoardStateChangeEvents[I])(Board, EventType);

end;

procedure TBBSCore.SetDefaultTopicChangeDownloadStateFunction(
                                        const Value: TNotifyEvent);
begin
  FDefaultTopicChangeDownloadStateFunction := Value;
end;


end.
