unit untBBSJBBS;

interface

uses
  Classes, Dialogs, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL, jconvert,
  untTool, untHttp, untGlobal, untConfig,
  untBBSFramework;

type

  TBBSJBBSGetTopic = class(TBBSGetTopic)
  private
    FHttp            : TAsyncHttp;
    FURL             : string;
    FReadPosition    : integer;
    FReceivedIndex   : integer;
    FBufferLines     : string;
    FServer          : string;
  protected
    procedure HttpReceived(Sender: TObject); override;
    procedure HttpComplete(Sender: TObject); override;
    procedure HttpStatus(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBSJBBSPostArticle = class(TBBSPostArticle)
  private
    FServer  : string;
    FBoardId : string;
    FTopicId : string;
    procedure HTTPRedirect(Sender: TObject; var dest: String;
      var NumRedirect: Integer; var Handled: Boolean;
      var VMethod: TIdHTTPMethod);
  public
    procedure   Post(PostName, PostEmail, Body : string); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBSJBBSGetTopicList = class(TBBSGetTopicList)
  private
    FHttp         : TAsyncHttp;
    FServer       : string;
    FBoardId      : string;
    FReadPosition : integer;
    procedure HttpReceived(Sender: TObject);
    procedure HttpComplete(Sender: TObject);
    procedure HttpStatus(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId : string);
    destructor  Destroy; override;
  end;

implementation

{ TBBSJBBSGetTopic }

uses untTopic;

constructor TBBSJBBSGetTopic.Create(Server, BoardId, TopicId : string);
begin
  inherited Create();

  FServer := Server;
  FURL := 'http://' + Server
        + '/bbs/read.pl?BBS=' + BoardId
        + '&KEY=' + TopicId;

  FHttp := TAsyncHttp.Create;
  FHttp.OnReceived := HttpReceived;
  FHttp.OnStatus   := HttpStatus;
  FHttp.OnComplete := HttpComplete;
  FHttp.UserAgent  := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  gConfig.InitReadProxy(FHttp);

end;

destructor TBBSJBBSGetTopic.Destroy;
begin
  FHttp.Free;
  inherited;
end;

procedure TBBSJBBSGetTopic.Get;
begin
  inherited;

  FReadPosition := 0;

  if FTopic.DatSize > 0 then
  begin
    FReceivedIndex := FTopic.DatSize;
  end;

  FHttp.Get(FURL);

end;

procedure TBBSJBBSGetTopic.HttpReceived(Sender: TObject);
var
  line       : string;
  RegExp     : TRegExpr;
  msgNo      : integer;
  msgName    : string;
  msgEmail   : string;
  msgRestStr : string;
  msgBody    : string;
  RegOK      : boolean;
  I          : Integer;
begin
  RegExp := TRegExpr.Create;

  msgno := -1;
  for I := FReadPosition to FHttp.ReceivedLines.Count - 1 do
  begin
    line          := ConvertJCode(FHttp.ReceivedLines[I], SJIS_OUT);
    FBufferLines  := FBufferLines + line;
    FReadPosition := I + 1;

    RegOK := false;
    RegExp.Expression := '<dt>(.+?) .+<b>(.*?)</[bB]></font>(.+?)<br><dd>(.*?)<br><br>$';
    if RegExp.Exec(FBufferLines) then
    begin
      RegOK      := true;
      msgno      := StrToIntNeo(RegExp.Substitute('$1'));
      msgEmail   := '';
      msgName    := RegExp.Substitute('$2');
      msgRestStr := RegExp.Substitute('$3');
      msgBody    := RegExp.Substitute('$4');
    end else
    begin
      RegExp.Expression := '<dt>(.+?) .+<a href="mailto:(.*?)"><b>(.*?)</[bB]></a> (.+?)<br><dd>(.*?)<br><br>$';
      if RegExp.Exec(FBufferLines) then
      begin
        RegOK      := true;
        msgno      := StrToIntNeo(RegExp.Substitute('$1'));
        msgEmail   := RegExp.Substitute('$2');
        msgName    := RegExp.Substitute('$3');
        msgRestStr := RegExp.Substitute('$4');
        msgBody    := RegExp.Substitute('$5');
      end;
    end;

    if RegOK then
    begin
      FBufferLines := '';

      if msgno = FReceivedIndex + 1 then
      begin
        Inc(FReceivedIndex);

        // sǉ
        FArticleList.Add(msgName    + '<>'
                       + msgEmail   + '<>'
                       + msgRestStr + '<>'
                       + msgBody    + '<>');
      end;
    end;


  end;

  Regexp.Free;
  inherited;
end;

procedure TBBSJBBSGetTopic.HttpComplete(Sender: TObject);
begin
  FTopic.DatSize := FReceivedIndex;
  inherited;
end;

procedure TBBSJBBSGetTopic.HttpStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: string);
begin
  case AStatus of
    hsConnecting : ChangeStatusText(FServer + 'ɐڑ');
    hsConnected  : ChangeStatusText(FServer + 'ɐڑ܂');
  end;
end;

{ TBBSJBBSPostArticle }

constructor TBBSJBBSPostArticle.Create(Server, BoardId, TopicId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;
end;

destructor TBBSJBBSPostArticle.Destroy;
begin

  inherited;
end;

procedure TBBSJBBSPostArticle.Post(PostName, PostEmail, Body: string);
var
  PostData : TStringList;
  intTime  : integer;
  response : string;
  ErrorMsg : string;
begin

  FHttp.Request.Referer := 'http://' + FServer + '/' + FBoardId  + '/index2.html';
  //FHttp.CookieManager   := TIdCookieManager.Create(nil);
  FHttp.HTTPOptions := [];
  FHttp.Request.CustomHeaders.Add('Cookie: NAME=' + UrlEncode(PostName)
                               + '&Cookie: MAIL=' + UrlEncode(PostEmail) +';');
  FHttp.OnRedirect := HTTPRedirect;
  
  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400);
  PostData := TStringList.Create;
  PostData.Add('submit='  + UrlEncode('') + '&' +
               'NAME='    + UrlEncode(PostName)   + '&' +
               'MAIL='    + UrlEncode(PostEmail)  + '&' +
               'MESSAGE=' + UrlEncode(Body)       + '&' +
               'BBS='     + FBoardId              + '&' +
               'KEY='     + FTopicId              + '&' +
               'TIME='    + IntToStr(intTime));

  try
    response := FHttp.Post('http://' + FServer + '/bbs/write.cgi', PostData);
  except on Exception do ;
  end;

  PostData.Free;

  if ErrorMsg <> '' then
    RaiseError(etPostArticle, ErrorMsg)
  else
    if Assigned(FOnComplete) then FOnComplete(self);

end;

procedure TBBSJBBSPostArticle.HTTPRedirect(Sender: TObject; var dest: String;
  var NumRedirect: Integer; var Handled: Boolean;
  var VMethod: TIdHTTPMethod);
begin
  Handled := false;
end;

{ TBBSJBBSGetTopicList }

constructor TBBSJBBSGetTopicList.Create(Server, BoardId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;

  FHttp := TAsyncHttp.Create;
  FHttp.OnReceived        := HttpReceived;
  FHttp.OnStatus          := HttpStatus;
  FHttp.OnComplete        := HttpComplete;
  FHttp.UserAgent := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  gConfig.InitReadProxy(FHttp);
end;

destructor TBBSJBBSGetTopicList.Destroy;
begin
  FHttp.Free;

  inherited;
end;

procedure TBBSJBBSGetTopicList.Get;
begin
  inherited;

  FHttp.Get('http://' + FServer + '/' + FBoardId + '/subject.txt');

end;

procedure TBBSJBBSGetTopicList.HttpReceived(Sender: TObject);
var
  line: string;
  regEx: TRegExpr;
  i: Integer;

  topic: TTopic;
  topicId: string;
  topicTitle: string;
  topicMsgCount: integer;
begin

  regEx := TRegExpr.Create;
  try
    regEx.Expression := '^(.+?)\.cgi,(.*)\((.+)\)$';

    for i := FReadPosition to FHttp.ReceivedLines.Count - 1 do
    begin
      FReadPosition := i + 1;
      line := FHttp.ReceivedLines[i];

      if regEx.Exec(line) then
      begin
        topicId       := regex.Substitute('$1');
        topicTitle    := regex.Substitute('$2');
        topicMsgCount := StrToIntNeo(Regex.Substitute('$3'));

        // ꕶϊ
        topicTitle := StringReplace(topicTitle, '&gt;', '>', [rfReplaceAll]);
        topicTitle := StringReplace(topicTitle, '&lt;', '<', [rfReplaceAll]);

        // gsbN̐
        topic              := gBBSCore.GetTopic(Board, topicId);
        topic.Index        := i + 1;
        topic.Title        := topicTitle;
        topic.MessageCount := topicMsgCount;
        topic.NoIndex      := false;

        // Cxgs
        Board.RaiseTopicReceivedEvent(topic);
      end else
      begin
        RaiseError(etParse, '̓G[');
      end;
    end;
   finally
    regEx.Free;
  end
end;

procedure TBBSJBBSGetTopicList.HttpComplete(Sender: TObject);
begin
  if Assigned(FOnComplete) then
  begin
    FOnComplete(self);
  end;
end;

procedure TBBSJBBSGetTopicList.HttpStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: string);
begin
  case AStatus of
    hsConnecting : ChangeStatusText(FServer + 'ɐڑ');
    hsConnected  : ChangeStatusText(FServer + 'ɐڑ܂');
  end;
end;

end.
