unit untBBS2chKako;

interface

uses
  Classes, Dialogs, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL,  
  untStreamTool, untTool,
  untBBSFramework, untBBS2ch,
  untLoginForm;

type

  TBBS2chGetKakoTopic = class(TBBS2chGetTopic)
  protected
    function  GetURL : string; override;
    procedure HttpComplete(Sender: TObject); override;
  public
    IsExists: Boolean;
    constructor Create(Server, BoardId, TopicId : string);
  end;

implementation

{ TBBS2chGetKakoTopic }

constructor TBBS2chGetKakoTopic.Create(Server, BoardId, TopicId: string);
begin
  inherited Create(Server, BoardId, TopicId);

  FHttp.UseGzip := true;
  FRawMode := true;

end;

function TBBS2chGetKakoTopic.GetURL: string;
begin
  if Length(FTopicId) > 9 then
    result := 'http://' + FServer + '/' + FBoardId + '/kako/' + Copy(FTopicId, 1, 4)
                     + '/' + Copy(FTopicId, 1, 5) + '/' + FTopicId + '.dat.gz'
  else
    result := 'http://' + FServer + '/' + FBoardId + '/kako/' + Copy(FTopicId, 1, 3)
                     + '/' + FTopicId + '.dat.gz';
end;

procedure TBBS2chGetKakoTopic.HttpComplete(Sender: TObject);
begin
  // ߋOȂ炠߂
  if Assigned(OnComplete) then
    OnComplete(self);
end;
end.
