unit untBBS2chDolib;

interface

uses
  Classes, Dialogs, SysUtils,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL,
  untStreamTool, untTool,
  untBBSFramework, untBBS2ch,
  untLoginForm;

type
  TBBS2chDolibTopic = class(TBBS2chGetTopic)
  public
    Freezed : Boolean;
    function  GetURL : string; override;
    constructor Create(Server, BoardId, TopicId: string);
    destructor Destroy; override;
  end;

implementation

uses
  untGlobal;

{ TBBS2chDolibTopic }

constructor TBBS2chDolibTopic.Create(Server, BoardId, TopicId: string);
begin
  inherited Create(Server, BoardId, TopicId);

  FHttp.UseGzip := true;
  FRawMode := true;

end;

destructor TBBS2chDolibTopic.Destroy;
begin

  inherited;
end;

function TBBS2chDolibTopic.GetURL: string;
begin
  result := 'http://' + FServer + '/test/offlaw.cgi/' +
           FBoardId + '/' + FTopicId + '/?raw=.' +
           IntToStr(FTopic.DatSize) + '&sid=' + UrlEncode(gConfig.SessionId);
end;
end.
