unit untBBS2ch;

interface

uses
  Classes, Dialogs, SysUtils, Forms,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL,
  untStreamTool, untTool,
  untGlobal,
  untHttp, untLog, untBoard, untBBSFramework;

type

  TBBS2chGetTopic = class(TBBSGetTopic)
  protected
    FRetry        : Integer;
    FHttp         : TAsyncHttp;
    FNoFirstLine  : boolean;
    FReadPosition : integer;
    FRawMode : Boolean;
    FServer  : string;
    FBoardId : string;
    FTopicId : string;
    FResponseCode : Integer;
    procedure HttpReceived(Sender: TObject); override;
    procedure HttpStatus(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
    procedure HttpComplete(Sender: TObject); override;
    function  GetURL: string; virtual; 
  public
    Freezed: boolean;
    property    ResponseCode : Integer read FResponseCode;
    procedure   Get(); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBS2chPostArticle = class(TBBSPostArticle)
  private
    FServer  : string;
    FBoardId : string;
    FTopicId : string;
  public
    procedure   Post(PostName, PostEmail, Body : string); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBS2chGetTopicList = class(TBBSGetTopicList)
  private
    FHttp         : TAsyncHttp;
    FServer       : string;
    FBoardId      : string;
    FReadPosition : integer;
    procedure HttpReceived(Sender: TObject);
    procedure HttpStatus(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId : string);
    destructor  Destroy; override;
  end;

implementation

uses
  untConfig,
  untTopic;

{ TBBS2chGetTopic }

procedure TBBS2chGetTopic.HttpComplete(Sender: TObject);
var
  contentsize : integer;
begin
  FResponseCode := FHttp.ResponseCode;
  if (FHttp.ResponseCode <> 304) then
  begin
    if (FHttp.ResponseCode < 200) or
       (FHttp.ResponseCode > 299) then
    begin
      RaiseError(etDatFreezed, 'DAT܂');
      Freezed := true;
    end;
  end;

  if FHttp.ErrorCode = heBrokenGZip then
  begin
    RaiseError(etBrokenGZip, 'gzipG[');
  end;

  FLastModified := FHttp.LastModified;
  contentsize   := FHttp.ContentLength;

  if contentsize > 0 then
  begin
    if FTopic.DatSize = 0 then
    begin
      FTopic.DatSize := contentsize
    end else
    begin
      FTopic.DatSize := FTopic.DatSize + contentsize - 1;
    end;
  end;

  inherited;
end;

procedure TBBS2chGetTopic.HttpReceived(Sender: TObject);
var
  line   : string;
  regExp : TRegExpr;
  i      : Integer;
begin
  if Application.Terminated then
  begin
    exit;
  end;

  regExp := TRegExpr.Create;
  try
    regExp.Expression := '^(.*?)<>(.*?)<>(.*?)<>(.*?)<>(.*?)';

    for i := FReadPosition to FHttp.ReceivedLines.Count - 1 do
    begin
      FReadPosition := i + 1;

      line := FHttp.ReceivedLines[i];

      // Ol܂`FbN
      if FNoFirstLine then
      begin
        FNoFirstLine := false;
        if FTopic.DatSize > 0 then
        begin
          if line = '' then
          begin
            continue;
          end else
          begin
            RaiseError(etAbone, '폜ځ[ŃOl܂悤ł');
            exit;
          end;
        end
      end;

      // sǉ
      if RegExp.Exec(line) then
      begin
        FArticleList.Add(line)
      end else
      begin
        RaiseError(etParse, '̓G[');
        FArticleList.Add('<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                         '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                         '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                         '<FONT COLOR="Gray">[Ă܂]</FONT><>');
      end;
    end;
  finally
    Regexp.Free;
  end;
  inherited;
end;

procedure TBBS2chGetTopic.HttpStatus(ASender: TObject;
                                  const AStatus: TIdStatus;
                                  const AStatusText: string);
begin
  case AStatus of
    hsConnecting:
    begin
      if Assigned(OnChangeDownloadState) then
      begin
        ChangeStatusText(FServer + 'ɐڑ');
      end;
    end;
    hsConnected:
    begin
      if Assigned(OnChangeDownloadState) then
      begin
        ChangeStatusText(FServer + 'ɐڑ܂');
      end;
    end;
  end;
end;

constructor TBBS2chGetTopic.Create(Server, BoardId, TopicId : string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;

  FHttp := TAsyncHttp.Create;
  FHttp.OnReceived := HttpReceived;
  FHttp.OnStatus   := HttpStatus;
  FHttp.OnComplete := HttpComplete;
  FHttp.UserAgent := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  gConfig.InitReadProxy(FHttp);
end;

destructor TBBS2chGetTopic.Destroy;
begin
  FHttp.Free;

  inherited;
end;

procedure TBBS2chGetTopic.Get;
begin
  FReadPosition := 0;

  if FTopic.DatSize > 0 then
  begin
    FHttp.StartRange := FTopic.DatSize - 1
  end else
  begin
    FHttp.StartRange := 0;
  end;

  FNoFirstLine := true;

  FHttp.LastModified := FLastModified;
  FHttp.Get(GetURL);
end;

function TBBS2chGetTopic.GetURL: string;
begin
  result := 'http://' + FServer + '/' + FBoardId + '/dat/' + FTopicId + '.dat';
end;

{ TBBS2chPostArticle }

constructor TBBS2chPostArticle.Create(Server, BoardId, TopicId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;
end;

destructor TBBS2chPostArticle.Destroy;
begin

  inherited;
end;

procedure TBBS2chPostArticle.Post(PostName, PostEmail, Body: string);
var
  PostData  : TStringList;
  intTime   : integer;
  response  : string;
  ErrorMsg  : string;
  writedata : string;
  compdata  : string;
begin

  FHttp.Request.Referer := 'http://' + FServer + '/' + FBoardId  + '/index2.html';
  FHttp.CookieManager   := TIdCookieManager.Create(nil);
  FHttp.HTTPOptions := [];
  FHttp.Request.CustomHeaders.Add('Cookie: NAME=' + UrlEncode(PostName)
                               + '&Cookie: MAIL=' + UrlEncode(PostEmail) +';');

  PostData := TStringList.Create;
  writedata := 'submit='  + UrlEncode('') + '&' +
               'FROM='    + UrlEncode(PostName)   + '&' +
               'mail='    + UrlEncode(PostEmail)  + '&' +
               'MESSAGE=' + UrlEncode(Body)       + '&' +
               'bbs='     + FBoardId              + '&' +
               'key='     + FTopicId;

  if gConfig.Sessionid <> '' then
    writedata := writedata + '&sid=' + UrlEncode(gConfig.Sessionid);

  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400 - 32400);
  compdata := writedata + '&' + 'time=' + IntToStr(intTime);
  PostData.Add(compdata);

  response := FHttp.Post('http://' + FServer + '/test/bbs.cgi', PostData);
  if Pos('݂܂', response) = 0 then
  begin

    PostData.Free;
    PostData := TStringList.Create;

    intTime := Round((FHttp.Response.Date - EncodeDate(1970, 1, 1)) * 86400) - 32400 - 100;
    compdata := writedata + '&' + 'time=' + IntToStr(intTime);
    PostData.Add(compdata);

    response := FHttp.Post('http://' + FServer + '/test/bbs.cgi', PostData);
    if Pos('݂܂', response) = 0 then
    begin
      ErrorMsg := CopyMiddle(response, '<b>', '</b>');
    end;
  end;

  PostData.Free;
  FHttp.CookieManager.Free;
  FHttp.CookieManager := nil;

  if ErrorMsg <> '' then
    RaiseError(etPostArticle, ErrorMsg)
  else
    if Assigned(FOnComplete) then
      FOnComplete(self);
end;

{ TBBS2chGetTopicList }

constructor TBBS2chGetTopicList.Create(Server, BoardId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;

  FHttp := TAsyncHttp.Create;
  FHttp.OnReceived        := HttpReceived;
  FHttp.OnStatus          := HttpStatus;
  //FHttp.OnComplete        := HttpComplete;
  FHttp.UserAgent := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  FHttp.UseGzip := true;
  gConfig.InitReadProxy(FHttp);
end;

destructor TBBS2chGetTopicList.Destroy;
begin
  FHttp.Free;
  inherited;
end;

procedure TBBS2chGetTopicList.Get;
begin
  inherited;
  FReadPosition := 0;
  FHttp.Get('http://' + FServer + '/' + FBoardId + '/subject.txt');
end;

procedure TBBS2chGetTopicList.HttpReceived(Sender: TObject);
var
  line: string;
  regEx: TRegExpr;
  i: Integer;

  topic: TTopic;
  topicId: string;
  topicTitle: string;
  topicMsgCount: integer;
begin

  regEx := TRegExpr.Create;
  try
    regEx.Expression := '^(.+?)\.dat<>(.*) \((.+?)\)$';

    for i := FReadPosition to FHttp.ReceivedLines.Count - 1 do
    begin
      FReadPosition := i + 1;
      line := FHttp.ReceivedLines[i];

      if regEx.Exec(line) then
      begin
        topicId       := regex.Substitute('$1');
        topicTitle    := regex.Substitute('$2');
        topicMsgCount := StrToIntNeo(Regex.Substitute('$3'));

        // ꕶϊ
        topicTitle := StringReplace(topicTitle, '&gt;', '>', [rfReplaceAll]);
        topicTitle := StringReplace(topicTitle, '&lt;', '<', [rfReplaceAll]);

        // gsbN̐
        topic              := gBBSCore.GetTopic(Board, topicId);
        topic.Index        := i + 1;
        topic.Title        := topicTitle;
        topic.MessageCount := topicMsgCount;
        topic.NoIndex      := false;

        // Cxgs
        Board.RaiseTopicReceivedEvent(topic);
      end else
      begin
        RaiseError(etParse, '̓G[');
      end;
    end;
   finally
    regEx.Free;
  end
end;


procedure TBBS2chGetTopicList.HttpStatus(ASender: TObject;
                                         const AStatus: TIdStatus;
                                         const AStatusText: string);
begin
  case AStatus of
    hsConnecting : ChangeStatusText(FServer + 'ɐڑ');
    hsConnected  : ChangeStatusText(FServer + 'ɐڑ܂');
  end;
end;

end.
