unit untTopicPostThread;

interface

uses
  Classes, SysUtils, Dialogs, DzURL,
  untStreamTool, untTool,
  untBoard, untOnlineBoard, untGlobal, untTopic;

type
  TTopicPostThread = class(TThread)
  private
    FTopic: TTopic;
    FParent: TOnlineBoard;
    FTitle:       string;
    FPostName:    string;
    FPostEmail:   string;
    FPostBody:    string;
    FErrorString: string;
    FErrorCode: TFrameworkErrorType;
  protected
    procedure SyncOnStatus;
    procedure SyncOnComplete;
    procedure RaiseBBSError;
    procedure BBS_Complete(Sender : TObject);
    procedure BBS_Error(Sender: TObject;
                        const ErrorCode: TFrameworkErrorType;
                        const ErrorString: string);
    procedure BBS_StatusChange(Sender: TObject);
  public
    OnComplete: TNotifyEvent;
    OnStatusChange: TNotifyEvent;
    OnError: TFrameworkError;
    procedure   Execute; override;
    constructor Create(Parent: TOnlineBoard;
                       Topic: TTopic;
                       const Title,
                             PostName,
                             PostEmail,
                             PostBody: string);
  end;

implementation

{ TTopicPostThread }

constructor TTopicPostThread.Create(Parent: TOnlineBoard;
                                    Topic: TTopic;
                                    const Title,
                                          PostName,
                                          PostEmail,
                                          PostBody: string);
begin
  inherited Create(true);

  FTopic := Topic;
  FTopic.OnStateChange := BBS_StatusChange;
  FTopic.OnComplete    := BBS_Complete;
  FTopic.OnError       := BBS_Error;

  FParent    := Parent;
  FPostName  := PostName;
  FPostEmail := PostEmail;
  FPostBody  := PostBody;
  FTitle     := Title;
end;

procedure TTopicPostThread.Execute;
begin
  inherited;

  // 
  FTopic.Post(FPostName, FPostEmail, FPostBody);

  Terminate;
end;

procedure TTopicPostThread.BBS_Complete(Sender: TObject);
begin
  if Assigned(OnComplete) then
  begin
    Synchronize(SyncOnComplete);
  end;
end;

procedure TTopicPostThread.SyncOnComplete;
begin
  OnComplete(self);
end;

procedure TTopicPostThread.SyncOnStatus;
begin
  OnStatusChange(self);
end;

procedure TTopicPostThread.BBS_StatusChange(Sender: TObject);
begin
  if Assigned(OnStatusChange) then
  begin
    Synchronize(SyncOnStatus);
  end;
end;

procedure TTopicPostThread.BBS_Error(Sender: TObject;
                                     const ErrorCode: TFrameworkErrorType;
                                     const ErrorString: string);
begin
  FErrorString := ErrorString;
  FErrorCode   := ErrorCode;
  Synchronize(RaiseBBSError);
end;

procedure TTopicPostThread.RaiseBBSError;
begin
  if Assigned(OnError) then
  begin
    OnError(self, FErrorCode, FErrorString);
  end;
end;

end.
