unit untKakikomi;

interface 

uses 
  Classes,  SysUtils; 

type
  TKakikomi = class(TObject) 
  private 
    FFileName : string; 
    function GetKakikomi(const Date, Title, URL, Name, EMail, Body : string) : string; 
  public 
    constructor Create(FileName : string); 
    destructor  Destroy; override; 
    procedure Write(const Date, Title, URL, Name, EMail, Body : string); 
  end; 

implementation 

constructor TKakikomi.Create(FileName : string); 
begin 
  FFileName := FileName; 
end; 

destructor TKakikomi.Destroy; 
begin 
  inherited; 
end; 

procedure TKakikomi.Write(const Date, Title, URL, Name, EMail, Body : string); 
var 
  FileStream : TFileStream; 
  Mode: Word; 
  Kakikomi : string; 
begin 
  if FileExists(FFileName) then 
    Mode := fmOpenReadWrite or fmShareDenyWrite 
  else 
    Mode := fmCreate or fmShareDenyWrite; 

  FileStream := TFileStream.Create(FFileName, Mode); 

  FileStream.Seek(0, soFromEnd); 
  Kakikomi := GetKakikomi(Date, Title, URL, Name, EMail, Body); 
  FileStream.WriteBuffer(PChar(Kakikomi)^, Length(Kakikomi)); 

  FileStream.Free; 
end; 


function TKakikomi.GetKakikomi(const Date, Title, URL, Name, EMail, Body : string) : string; 
var 
  S : string; 
begin 
  S :=     '--------------------------------------------' + #13#10; 
  S := S + 'Date   : ' + Date  + #13#10; 
  S := S + 'Subject: ' + Title + #13#10; 
  S := S + 'URL    : ' + URL   + #13#10; 
  S := S + 'From   : ' + Name  + #13#10; 
  S := S + 'Mail   : ' + EMail + #13#10; 
  S := S + #13#10; 
  S := S + Body + #13#10; 
  S := S + #13#10; 

  Result := S; 
end; 

end.  

