unit untFolderAlias;

interface

uses
  Classes, Contnrs, SysUtils,
  untTool;

type

  TAlias = class
  public
    DisplayName : string;
    BoardName   : string;
    Folders     : TStringList;
    constructor Create;
    destructor  Destroy; override;
  end;

  TFolderAlias = class
  private
    FAliasList: TObjectList;
  public
    constructor Create;
    destructor  Destroy; override;
    function    GetFolderPath(const Server, BoardName, FileName: string; var resultpath : string): boolean;
    procedure   AddAlias(const BoardName, DisplayName, Server: string);
    procedure   Save;
  end;

implementation

uses
  untGlobal, untConfig;

{ TBoardAlias }

constructor TFolderAlias.Create;
var
  lines: TStringList;
  i, parseMode: integer;
  alias: TAlias;
  filePath: string;
  items: TStringArray;

begin
  alias := nil;
  SetLength(items, 0);

  FAliasList := TObjectList.Create;

  filePath := AppPath(FILE_BOARDALIAS);
  if not FileExists(filepath) then
  begin
    exit;
  end;

  // Alias f[^̓ǂݍ
  lines := TStringList.Create;
  lines.LoadFromFile(filePath);
  parseMode := 0;
  for i := 0 to lines.Count - 1 do
  begin
    if lines[i] = '' then
    begin
      parseMode := 0;
      continue;
    end;
    if parseMode = 0 then
    begin
      alias := TAlias.Create;
      FAliasList.Add(alias); 

      items := Split(lines[i], #9, 2);
      alias.DisplayName := items[0];
      alias.BoardName   := items[1];
      parseMode := 1;
    end else
    if parseMode = 1 then
    begin
      alias.Folders.Add(Lowercase(lines[i]));
    end;
  end;
  lines.Free;
end;

destructor TFolderAlias.Destroy;
begin
  FAliasList.Free;

  inherited;
end;

function TFolderAlias.GetFolderPath(const Server,
                                          BoardName,
                                          FileName: string;
                                      var ResultPath: string): boolean;
var
  i, j, k: integer;
  alias: TAlias;
  folder: string;

begin
  // LowerCaseLiveSoccerȂȂ
  folder := Server + '\' + BoardName;
  folder := StringReplace(folder, '/', '_', [rfReplaceAll]);

  // }b`aliasf[^݂Ȃ΁Aw肳ꂽACeԂ
  ResultPath := AppPath(DIR_LOG + folder + '\');
  result := false;

  // Alias f[^̌
  for i := 0 to FAliasList.Count - 1 do
  begin
    alias := TAlias(FAliasList[i]);
    for j := 0 to alias.Folders.Count - 1 do
    begin
      if alias.Folders[j] = folder then
      begin
        // w肳ꂽt@C݂tH_Ԃ
        for k := 0 to alias.Folders.Count - 1 do
        begin
          if FileExists(AppPath(DIR_LOG + alias.Folders[k] + '\' + FileName)) then
          begin
            ResultPath := AppPath(DIR_LOG + alias.Folders[k] + '\');
            result := true;
            exit;
          end;
        end;
        // t@C݂Ȃ΁Aalias̍ŏ̃ACeԂ
        ResultPath := AppPath(DIR_LOG + alias.Folders[0] + '\');
        result := false;
        exit;
      end;
    end;
  end;
end;

procedure TFolderAlias.AddAlias(const BoardName, DisplayName, Server: string);
var
  i: integer;
  alias: TAlias;
  folder: string;
  match: boolean;

begin
  alias := nil;

  folder := LowerCase(Server + '\' + BoardName);
  folder := StringReplace(folder, '/', '_', [rfReplaceAll]);

  // Alias f[^̌
  match := false;
  for i := 0 to FAliasList.Count - 1 do
  begin
    alias := TAlias(FAliasList[i]);
    if (alias.DisplayName = DisplayName) and
       (alias.BoardName   = BoardName) then
    begin
      match := true;
      break;
    end;
  end;

  // }b`ȂΐVǉ
  if not match then
  begin
    alias := TAlias.Create;
    alias.DisplayName := DisplayName;
    alias.BoardName   := BoardName;
    FAliasList.Add(alias);
  end;

  if alias.Folders.IndexOf(folder) = - 1 then
  begin
    alias.Folders.Add(folder);
  end;
end;

procedure TFolderAlias.Save;
var
  saveFile: TStringList;
  i, j: integer;
  alias: TAlias;

begin
  savefile := TStringList.Create;

  for i := 0 to FAliasList.Count - 1 do
  begin
    alias := TAlias(FAliasList[i]);
    saveFile.Add(alias.DisplayName + #9 + alias.BoardName);

    for j := 0 to alias.Folders.Count - 1 do
    begin
      saveFile.Add(alias.Folders[j]);
    end;
    saveFile.Add('');
  end;

  saveFile.SaveToFile(AppPath(FILE_BOARDALIAS));

  saveFile.Free;
end;

{ TAlias }

constructor TAlias.Create;
begin
  Folders := TStringList.Create;
end;

destructor TAlias.Destroy;
begin
  Folders.Free;

  inherited;
end;

end.
