unit untBoard2ch;

interface

uses
  untOnlineBoard, IdComponent, untTopic, untTopicBrowser;

type
  TBoard2ch = class(TOnlineBoard)
  private
    FLastModified: string;
  protected
    procedure HttpReceived(Sender: TObject); override;
  public
    procedure SendTopicList; override;
    function HasTopicListChange: boolean;
  end;

implementation

uses
  untTopic2ch, untGlobal, untBoard, untHttp, untConfig;

function TBoard2ch.HasTopicListChange: boolean;
begin
  if FLastModified = '' then
  begin
    result := true;
    exit;
  end;
  State := stArrivalChecking;
  FHttp := TAsyncHttp.Create;
  FHttp.UserAgent := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  FHttp.OnStatus := HttpStatusChange;
  FHttp.URL := SubjectURL;
  gConfig.InitReadProxy(FHttp);
  FHttp.Head;
  result := false;
  if FHttp.LastModified <> FLastModified then
  begin
    result := true;
  end;
  FHttp.Free;
  State := stIdling;
end;

procedure TBoard2ch.SendTopicList;
begin
  inherited;

  FHttp.UseGzip := true;
  FHttp.OnReceived := HttpReceived;
  FHttp.Get;

  FLastModified := FHttp.LastModified;
  
  inherited SendTopicListComplete;
end;

procedure TBoard2ch.HttpReceived(Sender: TObject);
begin
  inherited HttpReceivedProc('^(.+?)\.dat<>(.*)\s?\((.+?)\)$');
end;

end.
