unit untAllSubscribedTopics;

interface

uses
  Classes,
  untOfflineBoard, untTopic, untOnlineBOard;

type
  TAllSubscribedTopics = class(TOfflineBoard)
  private
    FOnlineBoard: TOnlineBoard;
    FTopicId: string;
    FSize: integer;
    FDate: TDateTime;
    FIndex: integer;
    FServer: string;
    FBoardName: string;
  protected
    procedure LoadLog(const path: string);
    procedure AddTopic;
    procedure GetBoard;
  public
    constructor Create;
    procedure AppendTopic(Topic: TTopic); override;
    procedure RemoveTopic(Topic: TTopic); override;
    procedure SendTopicList; override;
    procedure Save; override;
    procedure FreeAllTopic; override;
  end;

implementation

uses
  RegExpr, SysUtils, StrUtils,
  untTool, untBoard, untConfig, untBoardList, untGlobal;

procedure TAllSubscribedTopics.FreeAllTopic;
var
  i: integer;
  tp: TTopic;
begin

  for i := 0 to TopicList.Count - 1 do
  begin
    tp := TopicList[i];
    (tp.OnlineBoard as TOnlineBoard).FreeTopic(tp);
  end;
  TopicList.Clear;
end;

constructor TAllSubscribedTopics.Create;
begin
  inherited Create(AppPath('g܂'));
end;

procedure TAllSubscribedTopics.LoadLog(const path: string);
var
  regEx: TRegExpr;
  searchRec: TSearchRec;
  foundPath: string;

  procedure SetFileSizeDate(const f: string);
  var
    r: TSearchRec;
  begin
    FindFirst(f, faAnyFile, r);
    FSize := r.Size;
    FDate := r.Time;
  end;

begin
  regEx := TRegExpr.Create;
  regEx.Expression := '^' + DIR_LOG + '\' + '(.+?)\\(.+?)\\(.+?)\.i';

  if FindFirst(path +  '\*.*', faAnyFile, searchRec) = 0 then
  begin
    repeat
      if (searchRec.Name <> '.') and (searchRec.Name <> '..') then
      begin
        foundPath := path + '\' + searchRec.Name;

        if (searchRec.Attr and faDirectory) <> 0 then
        begin
          LoadLog(foundPath);
        end;

        if AnsiEndsText('.i', searchRec.Name) then
        begin
          // gsbN̓ǂݍ
          if regEx.Exec(foundPath) then
          begin
            FServer    := Regex.Match[1];
            FBoardname := Regex.Match[2];
            FTopicid   := Regex.Match[3];
            FServer := StringReplace(FServer, '_', '/', [rfReplaceAll]);

            Inc(FIndex);
            SetFileSizeDate(path + '\' + FTopicid + '.d');
            GetBoard;
            AddTopic;
          end;
        end;
      end;
    until FindNext(searchRec) <> 0;
    FindClose(searchRec);
  end;
  Regex.Free;
end;

procedure TAllSubscribedTopics.GetBoard;
begin
  FOnlineBoard := (BoardList as TBoardList).GetBoard(FServer, FBoardname);
end;

procedure TAllSubscribedTopics.AddTopic;
var
  topic: TTopic;

begin
  topic := FOnlineBoard.GetTopic(FTopicId);
  topic.FileSize := FSize;
  topic.FileDate := FDate;
  topic.Index := FIndex;
  AppendTopic(topic);
end;

procedure TAllSubscribedTopics.SendTopicList;
var
  path: string;

begin
  State := stDownloading;
  TopicList.Clear;

  FIndex := 0;

  path := DIR_LOG;
  if AnsiEndsText('\', DIR_LOG) then
  begin
    path := Copy(path, 0, Length(path) - 1);
  end;
  LoadLog(path);

  if Assigned(OnReceived) then
  begin
    gSynchronizer.DoSynchronize(SyncOnReceived);
  end;
  if Assigned(OnComplete) then
  begin
    gSynchronizer.DoSynchronize(SyncOnComplete);
  end;
  State := stIdling;
end;

procedure TAllSubscribedTopics.AppendTopic(Topic: TTopic);
begin
  TopicList.Add(Topic);
end;

procedure TAllSubscribedTopics.RemoveTopic(Topic: TTopic);
begin
  TopicList.Remove(Topic);
end;

procedure TAllSubscribedTopics.Save;
begin
  // S̓t@CɕۑȂ
end;

end.
 