unit untStreamTool;

interface

uses
  Classes;

type

  TStreamReader = class
  private
    FStream: TStream;
  public
    constructor Create(Target: TStream);
    destructor  Destroy; override;
    function ReadLine(out BufferString : string): Boolean;
    function Read(var Buff : Char): Boolean;
    function ReadToEnd: string;
  end;

  TWriteEvent = procedure(const Buffer; Count: int64) of object;

  TMemoryStreamEx = class(TCustomMemoryStream)
  private
    FPosition: Integer;
    FOnWrite: TWriteEvent;
    procedure SetOnWrite(const Value: TWriteEvent);
  public
    property OnWrite: TWriteEvent read FOnWrite write SetOnWrite;
    function Write(const Buffer; Count: integer): integer; override;
  end;

implementation

{ TStreamReader }

constructor TStreamReader.Create(Target: TStream);
begin
  FStream := Target;
end;

destructor TStreamReader.Destroy;
begin
  inherited;
end;

function TStreamReader.Read(var Buff: Char): Boolean;
var
  intSize: Integer;

begin

  intSize := FStream.Read(Buff, 1);
  if intSize = 1 then
  begin
    result := true;
  end else
  begin
    result := false;
  end;
end;

function TStreamReader.ReadLine(out BufferString: string): Boolean;
var
  buffer, lastBuffer: Char;
  intSize, length: Integer;
  startPos: int64;
  p: PChar;
  s: string;
  nextpos: int64;

begin
  lastBuffer := #0;

  // s܂œǂݍ
  startpos := FStream.Position;
  length   := 0;
  while true do
  begin
    intSize := FStream.Read(buffer, 1);
    if intSize = 0 then
    begin
      if length <> 0 then
      begin
        break;
      end else
      begin
        result       := false;
        BufferString := '';
        exit;
      end;
    end;
    if buffer = #10 then
    begin
      if lastBuffer = #13 then
      begin
        lastBuffer := #0;
      end;
      break;
    end else
    begin
      if lastBuffer <> #0 then
      begin
        Inc(length);
      end;
      lastBuffer := buffer;
    end;
  end;

  if lastBuffer <> #0 then
  begin
    Inc(length);
  end;

  nextpos := FStream.Position;

  GetMem(p, length);
  FStream.Seek(startpos, soFromBeginning);
  FStream.Read(p^, length);
  SetString(s, p, length);
  FreeMem(p);
  BufferString := s;

  FStream.Seek(nextpos, soFromBeginning);

  if buffer = #10 then
  begin
    result := true
  end else
  begin
    result := false;
  end;
end;

function TStreamReader.ReadToEnd: string;
var
  buffer  : Array[1..255] of Char;
  intSize : Integer;
  str     : string;
begin

  //str := TStringStream.Create('');
  while true do
  begin
    intSize := FStream.Read(Buffer, SizeOf(Buffer));
    if intSize = 0 then break;

    str := str + Copy(Buffer, 1, intSize);
  end;

  result := str;
  //str.Free;
end;

{ TOnWriteStream }

procedure TMemoryStreamEx.SetOnWrite(const Value: TWriteEvent);
begin
  FOnWrite := Value;
  FPosition := 0;
end;

function TMemoryStreamEx.Write(const Buffer; Count: integer): integer;
begin
  if Assigned(FOnWrite) then
  begin
    FOnWrite(Buffer, Count);
  end;
  result := Count;
end;

end.
