unit untTopicBrowserIE;

interface

uses
  Classes, SHDocVw_TLB, HTMLDocumentEvent,
  untTopic, untTopicBrowser;

type
  TTopicBrowserIE = class(TTopicBrowser)
  private
    FBrowser: TWebBrowser;
		FHtmlEvent: THTMLDocumentEventSink;
    FLogSkipCount:    integer;
    FReceivedIndex:   integer;
    FReplaceMode:     integer;
    FStartIndex:      integer;
    FDownloadComplete: boolean;
    FRestoredPos:      boolean;
    FWaitInitialize:   boolean;
    FNoScroll:         boolean;
    FOutputedHeader:   boolean;
    FReserveRefresh:   boolean;
  protected
    procedure BrowserInitialize;
    procedure Browser_NavigateComplete2(Sender: TObject; const pDisp: IDispatch; var URL: OleVariant);
    procedure Browser_StatusTextChange(Sender: TObject; const Text: WideString);
    procedure Browser_BeforeNavigate(Sender: TObject; const pDisp: IDispatch; var URL: OleVariant; var Flags: OleVariant; var TargetFrameName: OleVariant; var PostData: OleVariant; var Headers: OleVariant; var Cancel: WordBool);
    procedure BrowserOutput(output: string);
    procedure RestoreScrollPosition;
    procedure DisplayMessageByRange;
    function  DatToHtml(body: string): string;
    function  ReplaceString(MatchStr: string): string;
    function  OnContextMenu(Sender: TObject): WordBool;
    function  MsgToHtml(msg: TTopicMessage): string;
  public
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    procedure JumpMessage(const msgNo: integer); override;
    procedure SaveScrollPosition; override;
    procedure ChangeViewLimit(NewLimit: integer); override;
    procedure SearchText(const str: string); override;
    procedure CloseTopic; override;
    procedure Reload;   override;
    procedure SetTextSize(const TextSize: Integer);
    procedure Topic_MessageReceived(Sender: TObject); override;
    procedure Topic_ChangeDownloadState(Sender: TObject); override;
    function GetTextSize: integer;
  end;

implementation

{$WARN SYMBOL_PLATFORM OFF}

uses
  Controls, MSHTML_TLB, SysUtils, BmRegExp, Forms, StrUtils,
  untOnlineBoard, untGlobal, untTool;

procedure TTopicBrowserIE.DisplayMessageByRange;
var
  msg: TTopicMessage;
  html: string;
  i: integer;

begin
  for i := FReceivedIndex to Topic.MessageList.Count - 1 do
  begin
    if RangeNoList.IndexOf(IntToStr(i + 1)) > -1 then
    begin
      msg := TTopicMessage(Topic.MessageList[i]);
      html := html + MsgToHtml(msg);
    end;
    Inc(FReceivedIndex);
  end;
  BrowserOutput(html);
  Application.ProcessMessages;
  FLoading := false;
end;

// bZ[WM
procedure TTopicBrowserIE.Topic_MessageReceived(Sender: TObject);
var
  msg: TTopicMessage;
  html: string;

begin
  if FLoading or (Topic.MessageList.Count = 0) then
  begin
    exit;
  end;

  FLoading := true;
  FDownloading:= true;

  if FReceivedIndex = 0 then
  begin
    // 1Xڂ͕K\
    msg := TTopicMessage(Topic.MessageList[FReceivedIndex]);
    html := MsgToHtml(msg);
    if msg.IsNewMessage then
    begin
      // 1XڂV̂Ƃ̓XN[Ȃ
      FNoScroll := true;
      msg.IsNewMessage := false;
    end;
    Inc(FReceivedIndex);
    Inc(FLogSkipCount);
  end;

  if (Topic.GotMessageCount > FViewLimit) and (FViewLimit > 0) then
  begin
    // \ȂXXLbv
    while FReceivedIndex < Topic.MessageList.Count do
    begin
      msg := TTopicMessage(Topic.MessageList[FReceivedIndex]);
      if msg.IsNewMessage or
         (FViewLimit + FLogSkipCount >= Topic.GotMessageCount) then
      begin
        break;
      end;
      Inc(FLogSkipCount);
      Inc(FReceivedIndex);
    end;
  end;

  while FReceivedIndex < Topic.MessageList.Count do
  begin
    msg := TTopicMessage(Topic.MessageList[FReceivedIndex]);

    if (FStartIndex = 0) and (msg.Index > 1) then
    begin
      FStartIndex := msg.Index;
    end;

    if not FRestoredPos and msg.IsNewMessage then
    begin
      // XN[
      BrowserOutput(html);
      Application.ProcessMessages;
      html := '';
      if StartNo = 0 then
      begin
        RestoreScrollPosition;
      end else if FReceivedIndex >= StartNo then
      begin
        JumpMessage(StartNo);
      end;
    end;

    // 
    html := html + MsgToHtml(msg);
    msg.IsNewMessage := false;
    Inc(FReceivedIndex);
  end;

  BrowserOutput(html);
  Application.ProcessMessages;
  FLoading := false;

  if FReceivedIndex >= Topic.MessageList.Count then
  begin
    // XN[
    if StartNo = 0 then
    begin
      RestoreScrollPosition;
    end else if FReceivedIndex >= StartNo then
    begin
      JumpMessage(StartNo);
    end;
  end;
end;

// Xe[^Xo[̕ω
procedure TTopicBrowserIE.Browser_StatusTextChange(Sender: TObject;
                                                   const Text: WideString);
begin
  inherited ChangePopup(Text);
end;

constructor TTopicBrowserIE.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FHtmlEvent := nil;

  // uEU̐
  FBrowser := TWebBrowser.Create(self);
  TWinControl(FBrowser).Parent := self;
  FBrowser.Align   := alClient;
  FBrowser.Visible := true;
  FBrowser.OnNavigateComplete2 := Browser_NavigateComplete2;
  FBrowser.OnStatusTextChange  := Browser_StatusTextChange;
  FBrowser.OnBeforeNavigate2   := Browser_BeforeNavigate;

  BrowserInitialize();
end;

destructor TTopicBrowserIE.Destroy;
begin
  FBrowser.Free;
  FHtmlEvent.Free;

  inherited;
end;

procedure TTopicBrowserIE.Reload;
begin
  FLogSkipCount := 0;
  inherited;
end;

procedure TTopicBrowserIE.ChangeViewLimit(NewLimit: integer);
begin

  FViewLimit := newlimit;
	if Assigned(Topic) then
  begin
    //Topic.CancelDownload;

    SaveScrollPosition();
    Topic.SaveIdx();

    // ʃNA
    BrowserInitialize();
    // V擾
    Reload;
  end;
end;

// uEȔ
procedure TTopicBrowserIE.Browser_NavigateComplete2(Sender: TObject;
                                                    const pDisp: IDispatch;
                                                    var URL: OleVariant);
var
  Disp: DispHTMLDocument;//ISimpleCom;

begin
  if FWaitInitialize = true then
  begin
 		FWaitInitialize := false;

    Disp := FBrowser.Document as DispHTMLDocument;
    FHtmlEvent := THTMLDocumentEventSink.Create(Self, Disp, HTMLDocumentEvents2);
    FHtmlEvent.OnContextMenu := OnContextMenu;
  end;
end;

function TTopicBrowserIE.OnContextMenu(Sender: TObject): WordBool;
var
	doc: IHtmlDocument2;
	range: IHTMLTxtRange;
	s: string;
  msgNo: integer;

begin
  result := True;

	doc := FBrowser.Document as IHtmlDocument2;
	range := doc.selection.createRange as IHTMLTxtRange;
	s := StringReplace(range.text, '@', ' ', [rfReplaceAll]);
	s := ZenkakuToHankaku(Trim(s));
  msgNo := StrToIntNeo(s);
  if (msgNo > 0) and inherited ChangePopup('jump://goto/' + IntToStr(msgNo)) then
  begin
    result := false;
  end;
end;

procedure TTopicBrowserIE.BrowserInitialize();
begin
  FReceivedIndex  := 0;
  FLogSkipCount   := 0;
  FStartIndex     := 0;
  FReserveRefresh := false;
  FRestoredPos    := false;
  FOutputedHeader := false;
  FWaitInitialize := true;

  FBrowser.Navigate('about:blank');
  // o܂ő҂
  while FWaitInitialize do
  begin
    Application.ProcessMessages;
  end;
end;

procedure TTopicBrowserIE.SaveScrollPosition;
var
  body: Variant;
  top, scrollheight, lastspace: integer;

begin
  body := (FBrowser.Document as IHTMLDocument2).body;
  top          := body.scrollTop;
  scrollheight := body.scrollHeight;
  lastspace    := scrollheight  -  top;
  Topic.ScrollPosition := lastspace;
end;

procedure TTopicBrowserIE.BrowserOutput(output: string);
begin
  if output = '' then
  begin
    exit;
  end;

  if FReserveRefresh then
  begin
    BrowserInitialize;
  end;

  if not FOutputedHeader then
  begin
    output := StringReplace(gConfig.HeaderHtml,
                            '&THREADURL',
                            Topic.BrowserUrl,
                            [rfReplaceAll]) + output;
    FOutputedHeader := true;
  end;
  //OleVariant(FBrowser.Document as IHTMLDocument2).write(output);
   FBrowser.OleObject.Document.Write(output);
end;

procedure TTopicBrowserIE.SearchText(const str: string);
var
  i: integer;
  msg: TTopicMessage;
  html: string;
  find: boolean;

begin
  BrowserInitialize;

  for i := 0 to Topic.MessageList.Count -1 do
  begin
    msg := TTopicMessage(Topic.MessageList[i]);

    find := AnsiContainsText(msg.PostName, str);
    if not find then
    begin
      find := AnsiContainsText(msg.Postemail, str);
      if not find then
      begin
        find := AnsiContainsText(msg.RestStr, str);
        if not find then
        begin
          find := AnsiContainsText(msg.Body, str);
        end;
      end;
    end;

    if find then
    begin
      msg  := TTopicMessage(Topic.MessageList[I]);
      html := MsgToHtml(msg);
      BrowserOutput(html);
      Application.ProcessMessages;
    end;
  end;

  FReserveRefresh := true;
end;

// XN[
procedure TTopicBrowserIE.RestoreScrollPosition;
var
  body: OleVariant;
  scrollheight, top: integer;

begin
  inherited;

  if FRestoredPos then
  begin
    exit;
  end;
  FRestoredPos := true;

  if FNoScroll then
  begin
    FNoScroll := false;
    exit;
  end;
  body := (FBrowser.Document as IHTMLDocument2).body;
  scrollheight := body.scrollHeight;
  top := scrollheight  -  Topic.ScrollPosition;
  body.scrollTop := top;
end;

procedure TTopicBrowserIE.Browser_BeforeNavigate(Sender: TObject;
                                                 const pDisp: IDispatch;
                                                 var URL,
                                                     Flags,
                                                     TargetFrameName,
                                                     PostData,
                                                     Headers: OleVariant;
                                                 var Cancel: WordBool);
begin
  if URL = 'about:blank' then
  begin
    exit;
  end;

  Cancel := true;
  inherited RaiseNavigateUrlEvent(URL);
end;

procedure TTopicBrowserIE.JumpMessage(const msgNo: integer);
begin
  if msgNo < FStartIndex then
  begin
    FNoScroll := true;
    ChangeViewLimit(Topic.GotMessageCount - msgno + 1);
  end else
  begin
    OleVariant(FBrowser.Document).body.scrollTop
	  	:= OleVariant(FBrowser.Document).anchors.item('a' + IntToStr(msgno) ).offsetTop;
  end;
end;

// >>1 ̕ϊ
function TTopicBrowserIE.DatToHtml(body: string): string;
var
  awk: TAwkStr;

begin
  body := EraseATag(body);
  awk := TAwkStr.Create(nil);
  awk.OnReplaceString := ReplaceString;

  // XԍɃN\
  FReplaceMode := 1;
  awk.RegExp := '(&gt;|)+[0-9O-X]+([-|[][0-9O-X]+)?';
  awk.GSub('', body);

  // URLɃN\
  FReplaceMode := 2;
  awk.RegExp := 'h*ttp://[a-zA-Z_/%@\-~\.0-9&=%\?#;:\,\+]+';
  awk.GSub('', body);

  awk.Free;
  result := body;
end;

function TTopicBrowserIE.ReplaceString(MatchStr: string): string;
var
  strNum, check: string;
  i: integer;
  isNum: char;

begin
  case FReplaceMode of
    1:
    begin
      check := ZenkakuToHankaku(MatchStr);
      for i := Length(check)  downto 1 do
      begin
        isNum := check[i];
        if (isNum in ['0'..'9']) or (isNum = '-') then
        begin
          strNum := isNum + strNum;
        end;
      end;

      result := '<A HREF="jump://goto/' + strNum + '">' + MatchStr + '</A>';
    end;
    2:
    begin
      check := Matchstr;
      if Copy(check, 1, 1) <> 'h' then
      begin
        check := 'h' + check;
      end;

      if Pos('#', check) <> 0 then
      begin
        result := '<a href="' + AnsiReplaceText(check, '#', '[%23]') + '">' + MatchStr + '</a>'
      end else
      begin
        result := '<a href="' + check + '">' + MatchStr + '</a>';
      end;
    end;
  end;
end;

procedure TTopicBrowserIE.Topic_ChangeDownloadState(Sender: TObject);
begin
  inherited;

  Case Topic.State of
    dsNone:
    begin
      FDownloadComplete := true;
    end;
    else
    begin
      FDownloadComplete := false;
    end;
  end;
end;

procedure TTopicBrowserIE.CloseTopic;
begin
  inherited;

  FHtmlEvent.Free;
  BrowserInitialize();
end;

procedure TTopicBrowserIE.SetTextSize(const TextSize: Integer);
var
  size, rc: OleVariant;

begin
  if (TextSize < 0) or (TextSize > 4) then
  begin
    Exit;
  end;

  if Assigned(FBrowser.Document) then
  begin
    size := TextSize;
    FBrowser.ExecWB(OLECMDID_ZOOM, OLECMDEXECOPT_DONTPROMPTUSER, size, rc);
  end;
end;

function TTopicBrowserIE.GetTextSize: integer;
var
  size, rc: OleVariant;

begin
  if Assigned(FBrowser.Document) then
  begin
    FBrowser.ExecWB(OLECMDID_ZOOM, OLECMDEXECOPT_DONTPROMPTUSER, rc, size);
    result := size;
  end else
  begin
    result := 0;
  end;
end;


function TTopicBrowserIE.MsgToHtml(msg: TTopicMessage): string;
var
  outputHtml, mailName, strBody: string;

begin
  if msg.IsNewMessage then
  begin
    outputHtml := gConfig.NewResHtml;
    Inc(Topic.DisplayMsgCount);
  end else
  begin
    outputHtml := gConfig.ResHtml
  end;

  if msg.PostEmail <> '' then
  begin
    if not gConfig.DispMailAddress then
    begin
      mailName := '<A HREF="mailto:' + msg.PostEmail+ '">' +
                  msg.PostName +
                  '</A>';
    end else
    begin
      mailName := '<B>' + msg.PostName + '</B></B> [' + msg.PostEmail+ ']';
    end;
  end else
  begin
    mailName := msg.PostName;
  end;

  outputHtml := StringReplace(outputHtml,
                              '&MAILNAME',
                              '<B>' + mailName + '</B>',
                              [rfReplaceAll]);
  outputHtml := StringReplace(outputHtml,
                              '&NUMBER',
                              '<a href="menu://at/' + IntToStr(msg.Index) + '">' + IntToStr(msg.Index) + '</a>',
                              [rfReplaceAll]);
  outputHtml := StringReplace(outputHtml,
                              '&DATE',
                              msg.RestStr,
                              [rfReplaceAll]);
  outputHtml := StringReplace(outputHtml,
                              '&PLAINNUMBER',
                              IntToStr(msg.Index),
                              [rfReplaceAll]);
  outputHtml := StringReplace(outputHtml,
                              '&MAIL',
                              msg.Postemail,
                              [rfReplaceAll]);
  outputHtml := StringReplace(outputHtml,
                              '&NAME',
                              '<B>' + msg.PostName + '</B>',
                              [rfReplaceAll]);
  outputHtml := StringReplace(outputHtml,
                              '&THREADURL',
                              Topic.BrowserUrl,
                              [rfReplaceAll]);

  strBody := DatToHtml(msg.Body);
  outputHtml := StringReplace(outputHtml,
                              '&MESSAGE',
                              strBody,
                              [rfReplaceAll]);
  outputHtml := '<a name="a' + IntToStr(msg.Index) + '"></a>' +
                outputhtml + #13#10;
  result := outputHtml;
end;

end.

