unit untTaskManager;

interface

uses
  Classes, Contnrs;

type
  TRequestTask = (reqtDownload, reqtTrash, reqtOpen, reqtAbone, reqtClose,
                  reqbOpenBoard, reqtReload);

  TTask = class
  public
    Topic:         TObject;
    Board:         TObject;
    TopicBrowser:  TObject;
    TopicListView: TObject;
    Request: TRequestTask;
    Canceled: boolean;
  end;

  TTaskManager = class(TThread)
  private
    FCount: integer;
    FRequestList: TObjectList;
    FTopicTask: TTask;
  protected
    procedure Execute; override;
    procedure DeleteTask;
    procedure GetTask;
    procedure GetCount;
  public
    constructor Create;
    destructor  Destroy; override;
    procedure Cancel;
    procedure Request(Topic: TObject;
                      TopicBrowser: TObject;
                      const r: TRequestTask);
    procedure RequestBoard(TopicListView: TObject;
                           Board: TObject;
                           const r: TRequestTask);
  end;

implementation

uses
  Forms, Windows, Dialogs, SysUtils,
  untTopic, untOnlineBoard, untTopicBrowser, untGlobal, untBoard,
  untTopicListView;

procedure TTaskManager.GetTask;
begin
  FTopicTask := TTask(FRequestList[0]);
end;

procedure TTaskManager.GetCount;
begin
  FCount := FRequestList.Count;
end;

procedure TTaskManager.DeleteTask;
begin
  FRequestList.Delete(0);
end;

procedure TTaskManager.Execute;
var
  tp: TTopic;
  topicBrowser: TTopicBrowser;
  topicListView: TTopicListView;

begin
  while not Terminated do
  begin
    try
      Synchronize(GetCount);
      if FCount > 0 then
      begin
        try
          Synchronize(GetTask);
          if FTopicTask.Canceled then
          begin
            continue;
          end;

          if Assigned(FTopicTask.Topic) then
          begin
            // X̃^XN

            tp := FTopicTask.Topic as TTopic;
            if Assigned(FTopicTask.TopicBrowser) then
            begin
              topicBrowser := FTopicTask.TopicBrowser as TTopicBrowser;
            end else
            begin
              topicBrowser := nil;
            end;

            case FTopicTask.Request of
              reqtAbone:
              begin
                tp.Abone;
              end;
              reqtOpen:
              begin
                topicBrowser.OpenTopic(tp);
                topicBrowser.CompleteEvent.WaitFor(CONNECT_TIMEOUT);
              end;
              reqtDownload:
              begin
                tp.Download;
                tp.CompleteEvent.WaitFor(CONNECT_TIMEOUT);
              end;
              reqtTrash:
              begin
                if Assigned(topicBrowser) then
                begin
                  // uEŨ{^NbNꂽꍇ
                  topicBrowser.TrashTopic;
                end else
                begin
                  // j[NbNꂽꍇ
                  tp.EraseLog;
                end;
              end;
              reqtClose:
              begin
                topicBrowser.CloseTopic;
              end;
              reqtReload:
              begin
                topicBrowser.Reload;
              end;
            end;
          end else
          begin
            // ̃^XN

            topicListView := FTopicTask.TopicListView as TTopicListView;
            if reqbOpenBoard = FTopicTask.Request then
            begin
              TopicListView.OpenBoard(FTopicTask.Board as TBoard);
              TopicListView.CompleteEvent.WaitFor(CONNECT_TIMEOUT);
            end;
          end;
        finally
          Synchronize(DeleteTask);
        end;
      end;
      Sleep(7);
    except
      on e: Exception do
      begin
        ShowMessage(e.Message);
      end;
    end;
  end;
end;

procedure TTaskManager.Cancel;
var
  i: integer;

begin
  for i := 1 to FRequestList.Count - 1 do
  begin
    (FRequestList[i] as TTask).Canceled := true;
  end;
end;

procedure TTaskManager.Request(Topic: TObject; TopicBrowser: TObject; const r: TRequestTask);
var
  foundIndex, i: integer;
  tt: TTask;

begin
  foundIndex := 0;
  for i := 1 to FRequestList.Count - 1 do
  begin
    tt := TTask(FRequestList[i]);
    if (tt.Topic = Topic) and (tt.Request = r) then
    begin
      foundIndex := i;
      break;
    end;
  end;
  if foundIndex > 0 then
  begin
    if (r = reqtOpen) and (foundIndex > 2) then
    begin
      FRequestList.Move(foundIndex, 2);
    end;
  end else
  begin
    tt := TTask.Create;
    if Assigned(Topic) then
    begin
      tt.Topic := Topic;
    end;
    if Assigned(TopicBrowser) then
    begin
      tt.TopicBrowser := TopicBrowser;
    end;
    tt.Request := r;
    if (r = reqtOpen) and (FRequestList.Count > 0) then
    begin
      // XJƂ͂łɓĂXJNGXgLZ
      for i := 0 to FRequestList.Count - 1 do
      begin
        if reqtOpen = (FRequestList[i] as TTask).Request then
        begin
          (FRequestList[i] as TTask).Canceled := true;
        end;
      end;
      // 񎞂ɗDIɏĐɊJ悤ɂ
      FRequestList.Insert(1, tt);
    end else
    begin
      FRequestList.Add(tt);
    end;
  end;
end;

procedure TTaskManager.RequestBoard(TopicListView: TObject;
                                    Board: TObject;
                                    const r: TRequestTask);
var
  bt: TTask;

begin
  Cancel;
  bt := TTask.Create;
  if Assigned(Board) then
  begin
    bt.Board := Board;
    bt.TopicListView := TopicListView;
  end;
  bt.Request := r;
  FRequestList.Add(bt);
end;

constructor TTaskManager.Create;
begin
  inherited Create(false);

  FRequestList := TObjectList.Create;
end;

destructor TTaskManager.Destroy;
begin
  FRequestList.Free;
  inherited;
end;

end.
