unit untTopic;

interface

uses
  SysUtils, Classes, Contnrs, SyncObjs,
  RegExpr, IdHttp, IdComponent, Forms,
  untStreamTool, untGlobal, untHttp;

type
  TTopicMessage = class
  private
    function GetForPopup: string;
  public
    Index: Integer;
    Body:      string;
    PostName:  string;
		PostEmail: string;
    RestStr:   string;
    IsNewMessage: Boolean;
    property ForPopup: string read GetForPopup;
  end;

  TTopicStatusSet = set of (tsError, tsFreezed, tsGotLog, tsRetryed,
                            tsFavorite, tsInBox, tsPosting, tsOpened);

  TTopicState = (dsNone, dsStarting, dsDatLoaded, dsComplete);

  TTopic = class
  private
    FMsg: TTopicMessage;
    FLogLoaded: boolean;
    FNoBrowser: boolean;
    FMessageList: TList;
    FErrorCode: TFrameworkErrorType;
    FState: TTopicState;
  protected
    FHttp: TAsyncHttp;
    FPostHttp: TIdHttp;
    function GetTopicURL: string; virtual; abstract;
    function GetBrowserUrl: string; virtual; abstract;
    function ParseDat(const line: string; var aTitle: string): TTopicMessage;
    procedure RaiseError(const ErrorCode: TFrameworkErrorType); overload;
    procedure RaiseError(ErrorCode: TFrameworkErrorType;
                         ErrorString: string); overload;
    procedure HttpComplete; virtual;
    procedure HttpReceived(Sender: TObject); virtual;
    procedure HttpStatusChange(axSender: TObject;
                               const axStatus: TIdStatus;
                               const asStatusText: string);

    procedure SendTopic; virtual;
    procedure ChangeStatusText(const NewText: string);
    procedure WriteToDat(const newDat: string);
    procedure WriteState(const s: TTopicState);
    procedure SyncOnComplete;
    procedure SyncOnReceived;
    procedure SyncOnStateChange;
    procedure AddNewMessage;
  public
    CompleteEvent: TSimpleEvent;
    OnlineBoard: TObject;
    ArticleList: TStringList;
    Status: TTopicStatusSet;
    DoNotify: boolean;
    GZip:     boolean;
    NoIndex:  boolean;
    TopicId:       string;
    Title:         string;
    WroteName:     string;
    WroteEmail:    string;
    LocalDir:      string;
    Memo:          string;
    WriteError:    string;
    StatusText:    string;
    LastModified:  string;
    LastReadDate:  string;
    LastWriteDate: string;
    DatUrl:        string;
    DisplayMsgCount: integer;
    MessageCount:    integer;
    Index:           integer;
    GotMessageCount: integer;
    NewMessageCount: integer;
    ScrollPosition:  integer;
    Priority:        integer;
    DatSize:         integer;
    FileSize:        integer;
    AboneNumber:     integer;
    FileDate: TDateTime;
    OnComplete: TNotifyEvent;
    OnReceived: TNotifyEvent;
    OnError: TFrameworkError;
    OnStateChange: TNotifyEvent;
    property State: TTopicState read FState write WriteState;
    property ErrorCode: TFrameworkErrorType read FErrorCode;
    property MessageList: TList read FMessageList;
    property BrowserUrl: string read GetBrowserUrl;
    constructor Create(b: TObject; ti: string);
    destructor  Destroy; override;
    procedure Download;
    procedure CancelDownload;
    procedure Post(const PostName, PostEmail, Body: string); virtual;
    procedure LoadIdx;
    procedure LoadDat;
    procedure SaveIdx;
    procedure SaveDat;
    procedure EraseIdx;
    procedure EraseDat;
    procedure EraseLog;
    procedure CheckWriteFolder;
    procedure FreeMessage;
    procedure Abone;
  end;

implementation

uses
  untOnlineBoard, untConfig, untTool, untBoard, untBoardList;

procedure TTopic.SyncOnReceived;
begin
  OnReceived(self);
end;

procedure TTopic.SyncOnStateChange;
begin
  OnStateChange(self);
end;

procedure TTopic.SyncOnComplete;
begin
  OnComplete(self);
end;

procedure TTopic.Abone;
begin
  if AboneNumber = 0 then
  begin
    exit;
  end;

  with TTopicMessage(MessageList[AboneNumber - 1]) do
  begin
    Body := '';
    PostName := 'ځ`';
    RestStr := PostName;
    PostEmail := APP_NAME;
  end;
  SaveDat;
end;

procedure TTopic.CancelDownload;
begin
  // 
  //DoNotify := false;
  {if State <> dsNone then
  begin
    OnStateChange := nil;
    OnReceived := nil;
    OnComplete := nil;
    FHttp.Terminate;
  end;}
end;

procedure TTopic.WriteState(const s: TTopicState);
begin
  FState := s;
  case s of
    dsStarting:
    begin
      StatusText := '';
      Exclude(Status, tsFreezed);
      Exclude(Status, tsError);
    end;
  end;
end;

procedure TTopic.Download;
begin
  CompleteEvent.ResetEvent;
  State := dsStarting;

  CheckWriteFolder;
  FNoBrowser := not Assigned(OnReceived);
  NewMessageCount := NewMessageCount - DisplayMsgCount;
  DisplayMsgCount := 0;
  if NewMessageCount > 0 then
  begin
    GotMessageCount := GotMessageCount - NewMessageCount;
  end;

  LoadDat;
  if Assigned(OnReceived) and DoNotify then
  begin
    gSynchronizer.DoSynchronize(SyncOnReceived);
  end;

  SendTopic;
end;

procedure TTopic.SendTopic;
begin
  FHttp := TAsyncHttp.Create;
  FHttp.UserAgent := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  gConfig.InitReadProxy(FHttp);
  FHttp.OnStatus := HttpStatusChange;
  FHttp.LastModified := LastModified;
end;

procedure TTopic.RaiseError(const ErrorCode: TFrameworkErrorType);
begin
  FErrorCode := ErrorCode;
  Include(Status, tsError);
  case ErrorCode of
    etAbone:
    begin
      StatusText := '폜ځ[ŃOl܂悤ł';
    end;
    etParse:
    begin
      StatusText := '̓G[';
    end;
    etDatFreezed:
    begin
      StatusText := 'DAT܂';
      Include(Status, tsFreezed);
    end;
    etBrokenGZip:
    begin
      StatusText := 'gzipG[';
    end;
    etSocketError:
    begin
      StatusText := 'ڑɎs܂';
    end;
  end;
end;

procedure TTopic.RaiseError(ErrorCode: TFrameworkErrorType;
                            ErrorString: string);
begin
  if Assigned(OnError) then
  begin
    OnError(self, ErrorCode, ErrorString);
  end;
end;

procedure TTopic.HttpReceived(Sender: TObject);
var
  aTitle: string;
  i: integer;
  newDat: string;

begin
  FMessageList.Capacity := FMessageList.Count + ArticleList.Count;

  newDat := '';
  for i := 0 to ArticleList.Count - 1 do
  begin
    FMsg := ParseDat(ArticleList[i], aTitle);
    FMsg.IsNewMessage := true;
    gSynchronizer.DoSynchronize(AddNewMessage);

    newDat := newDat + ArticleList[i] + #13#10;

    if (FMsg.Index = 1) and (aTitle <> '') then
    begin
      Title := aTitle;
    end;
  end;
  if NewMessageCount > 0 then
  begin
    NewMessageCount := NewMessageCount + ArticleList.Count;
  end else
  begin
    NewMessageCount := ArticleList.Count;
  end;
  ArticleList.Clear;
  if gConfig.DoLogSave or (tsInBox in Status) or (tsGotLog in Status) then
  begin
    WriteToDat(newDat);
  end;
  if Assigned(OnReceived) and DoNotify then
  begin
    gSynchronizer.DoSynchronize(SyncOnReceived);
  end;
end;

destructor TTopic.Destroy;
begin
  FreeMessage;
  FMessageList.Free;
  ArticleList.Free;
  CompleteEvent.Free;

  inherited;
end;

procedure TTopic.HttpComplete;
begin
  // L^
  LastModified := FHttp.LastModified;
  FHttp.Free;

  if NewMessageCount > 0 then
  begin
    GotMessageCount := GotMessageCount + NewMessageCount;
    LastReadDate := DateTimeToStr(Now());
  end else
  begin
    NewMessageCount := 0;
  end;
  MessageCount := GotMessageCount;

  if not (tsError in Status) then
  begin
    if NewMessageCount <= 0 then
    begin
      StatusText := 'VȂ'
    end else
    begin
      StatusText := IntToStr(NewMessageCount) + '̃XM';
    end;
  end else
  begin
    if tsRetryed in Status then
    begin
      StatusText := 'ēǂݍ݂܂'
    end;
  end;

  if gConfig.DoLogSave or (tsInBox in Status) or (tsGotLog in Status) then
  begin
    SaveIdx;
  end;

  State := dsComplete;
  if Assigned(OnComplete) and DoNotify then
  begin
    gSynchronizer.DoSynchronize(SyncOnComplete);
  end;
  CompleteEvent.SetEvent;
  State := dsNone;
  Application.ProcessMessages;
end;

procedure TTopic.ChangeStatusText(const NewText: string);
begin
  StatusText := NewText;
  if Assigned(OnStateChange) and DoNotify then
  begin
    gSynchronizer.DoSynchronize(SyncOnStateChange);
  end;
end;

procedure TTopic.HttpStatusChange(axSender: TObject;
                                  const axStatus: TIdStatus;
                                  const asStatusText: string);
begin

  case axStatus of
    hsConnecting:
    begin
      ChangeStatusText((OnlineBoard as TOnlineBoard).Server + 'ɐڑ');
    end;
    hsConnected:
    begin
      Application.ProcessMessages;
      ChangeStatusText((OnlineBoard as TOnlineBoard).Server + 'ɐڑ܂');
    end;
  end;
end;

procedure TTopic.SaveDat;
var
  i: integer;
  msg: TTopicMessage;
  newDat: string;

begin
  DeleteFile(LocalDir + TopicId + '.d');

  newDat := '';
  for i := 0 to MessageList.Count - 1 do
  begin
    msg := TTopicMessage(MessageList[i]);
    newDat := newDat + msg.PostName + '<>' +
                       msg.PostEmail + '<>' +
                       msg.RestStr + '<>' +
                       msg.Body + #13#10;
  end;
  WriteToDat(newDat);
end;

procedure TTopic.WriteToDat(const newDat: string);
var
  logpath: string;
  datFile: TextFile;

begin
  Include(Status, tsGotLog);

  // DATt@C̏o
  logpath := LocalDir + TopicId + '.d';
  AssignFile(datFile, logpath);
  if not FileExists(logpath) then
  begin
    ReWrite(datFile);
  end;
  Append(datFile);
  Write(datFile, newDat);
  Flush(datFile);
  CloseFile(datFile);
end;

procedure TTopic.LoadDat;
var
  i, j: Integer;
  lines: TStringList;
  items: TStringArray;
  aTitle, logpath: string;

begin
  if FLogLoaded then
  begin
    exit;
  end;
  FLogLoaded := true;
  SetLength(items, 0);
  lines := TStringList.Create;
  logpath := LocalDir + TopicId + '.d';

  if FileExists(logpath) then
  begin
    // [Jǂݍ
    lines.LoadFromFile(logpath);
    for i := 0 to lines.Count - 1 do
    begin
      FMsg := ParseDat(lines[i], aTitle);
      AddNewMessage;
      if (i = 0) and (aTitle <> '') then
      begin
        self.Title := aTitle;
      end;
    end;
  end else
  begin
    // Of[^AÂ``
    // ÔȂ炻炩ǂݍ
    logpath := LocalDir + TopicId + '.dat';
    if FileExists(logpath) then
    begin
      lines.LoadFromFile(logpath);
      for i := 0 to lines.Count - 1 do
      begin
        items := Split(lines[i], ',');
        for j := 0 to 3 do
        begin
          items[j] := StringReplace(items[j], 'M', ',', [rfReplaceAll]);
        end;

        FMsg := TTopicMessage.Create;
        FMsg.PostName  := items[0];
        FMsg.PostEmail := items[1];
        FMsg.RestStr   := items[2];
        FMsg.Body      := items[3];
        AddNewMessage;
        WriteToDat(items[0] + '<>' +
                   items[1] + '<>' +
                   items[2] + '<>' +
                   items[3] + #13#10);
      end;
    end;
  end;
  lines.Free;
  State := dsDatLoaded;
  if MessageList.Count > 0 then
  begin
  	GotMessagecount := MessageList.Count;
  end;
end;

function TTopic.ParseDat(const line: string; var aTitle: string): TTopicMessage;
var
  items: TStringArray;
  msg: TTopicMessage;

begin
  msg := TTopicMessage.Create;
  items := Split(line, '<>');
  if Length(items) > 3 then
  begin
    msg.PostName  := items[0];
    msg.PostEmail := items[1];
    msg.RestStr   := items[2];
    msg.Body      := items[3];
  end;

  aTitle := '';
  if Length(items) > 4 then
  begin
    aTitle := items[4];
  end;

  result := msg
end;


procedure TTopic.Post(const PostName, PostEmail, Body: string);
var
  proxyhost: string;
  proxyport: integer;

begin
  FPostHttp := TIdHttp.Create(nil);
  FPostHttp.OnStatus := HttpStatusChange;
  FPostHttp.Request.UserAgent := gConfig.UserAgent;
  FPostHttp.Request.RawHeaders.Add('X-2ch-UA: ' + APP_2chUA);

  // proxy
  if gConfig.WriteProxyUse then
  begin
    gConfig.ParseProxy(gConfig.WriteProxy, proxyhost, proxyport);
    FPostHttp.ProxyParams.ProxyServer := proxyhost;
    FPostHttp.ProxyParams.ProxyPort   := proxyport;
  end;
end;

constructor TTopic.Create(b: TObject; ti: string);
begin
  ArticleList := TStringList.Create;

  OnlineBoard := b as TOnlineBoard;
  TopicId := ti;
  FLogLoaded := false;

  GotMessageCount := 0;
  NewMessageCount := -1;

  FMessageList := TList.Create;

  CompleteEvent := TSimpleEvent.Create;

  if not gFolderAlias.GetFolderPath((OnlineBoard as TOnlineBoard).Server,
                                    (OnlineBoard as TOnlineBoard).BoardName,
                                    TopicId + '.i',
                                    LocalDir) then
  begin
    gFolderAlias.GetFolderPath((OnlineBoard as TOnlineBoard).Server,
                               (OnlineBoard as TOnlineBoard).BoardName,
                               TopicId + '.idx',
                               LocalDir)
  end;
end;

procedure TTopic.LoadIdx;
var
  idxPath: string;
  idxLines: TStringList;
  idxItems: TStringArray;
  state: Integer;
  isGotLog, isFreezed, isFavorite, isInBox: boolean;

begin
  SetLength(idxitems, 0);

  // IDX t@CΓǂݍ
  NoIndex := true;
  if DirectoryExists(LocalDir) then
  begin
    idxPath := localdir + TopicId + '.i';
    if not FileExists(idxPath) then
    begin
      idxPath := localDir + TopicId + '.idx';
      if not FileExists(idxPath) then
      begin
        exit;
      end;
    end;

    idxLines := TStringList.Create();
    idxLines.LoadFromFile(idxPath);
    if idxLines.Count > 0 then
    begin
      idxItems := Split(idxLines[0], #9);
      if Length(idxItems) >= 18 then
      begin
        NoIndex := false;

        state := StrToIntNeo(idxItems[1]);
        isFreezed  := Boolean(state and 16);
        isGotLog   := Boolean(state and 32);
        isFavorite := Boolean(state and 64);

        if isFreezed then
        begin
          Include(Status, tsFreezed);
        end else
        begin
          Exclude(Status, tsFreezed);
        end;
        if isGotLog then
        begin
          Include(Status, tsGotLog);
        end else
        begin
          Exclude(Status, tsGotLog);
        end;
        if isFavorite then
        begin
          Include(Status, tsFavorite);
        end else
        begin
          Exclude(Status, tsFavorite);
        end;

        Priority        := StrToInt(idxItems[2]);
        Title           :=          idxItems[3];
        // 4`6͌ݎgĂȂ
        MessageCount    := StrToInt(idxItems[7]);
        GotMessageCount := StrToInt(idxItems[8]);
        //NewMessageCount := StrToInt(idxItems[9]);
        LastReadDate    :=          idxItems[10];
        LastWriteDate   :=          idxItems[11];
        // FBoardName := idxItems[12]; ͌ݎgĂȂ
        DatSize         := StrToInt(idxItems[13]);
        WroteName       :=          idxItems[14];
        WroteEmail      :=          idxItems[15];
        ScrollPosition  := StrToInt(idxItems[16]);
        Memo            :=          idxItems[17];
        DatUrl          :=          idxItems[18];
      end;

      // only 88 item
      if Length(idxItems) > 21 then
      begin
        LastModified := idxItems[21];
      end;

      // ver0.23 add
      if Length(idxItems) > 22 then
      begin
        state := StrToIntNeo(idxItems[22]);
        isInBox := Boolean(state and 16);
        Gzip    := Boolean(state and 32);
        if isInBox then
        begin
          Include(Status, tsInBox);
        end else
        begin
          Exclude(Status, tsInBox);
        end;
      end;
    end;
    idxLines.Free;
  end;
end;

// Idxt@C̋L^
procedure TTopic.SaveIdx;
var
  line, idxPath: string;
  state, state2: Integer;

begin
  if (tsFreezed in Status) and (MessageCount = 0) then
  begin
    exit;
  end;

  CheckWriteFolder;

  NoIndex := false;

  state := 0;
  if tsFreezed in Status then
  begin
    state := state or 16;
  end;
  if tsGotLog in Status then
  begin
    state := state or 32;
  end;
	if tsFavorite in Status then
  begin
    state := state or 64;
  end;

  state2 := 0;
  if tsInBox in Status then
  begin
    state2 := state2 or 16;
  end;
  if GZip then
  begin
    state2 := state2 or 32;
  end;

  line := '88' + #9 +
          IntToStr(state) + #9 +
					IntToStr(Priority) + #9 +
					Title + #9 +
          #9 +
					#9 +
				  #9 +
					IntToStr(MessageCount) + #9 +
					IntToStr(GotMessageCount) + #9 +
          IntToStr(NewMessageCount) + #9 +
					LastReadDate  + #9 +
					LastWriteDate + #9 +
					#9 +
					IntToStr(Datsize) + #9 +
					WroteName + #9 +
					WroteEmail + #9 +
					IntToStr(ScrollPosition) + #9 +
					Memo + #9 +
          DatUrl + #9 +
          #9 +
          #9 +
          LastModified + #9 +
          IntToStr(state2) + #9;

  // ۑ
  idxPath := LocalDir + TopicId + '.i';
  WriteFile(idxPath, line);
end;

procedure TTopic.FreeMessage;
var
  i: Integer;

begin
  for i := 0 to FMessageList.Count - 1 do
  begin
    TTopicMessage(FMessageList[i]).Free;
  end;
  FMessageList.Clear;

  FLogLoaded := false;
end;

procedure TTopic.EraseDat;
begin
  GotMessageCount := 0;
  NewMessageCount := -1;
  Datsize      := 0;
  LastModified := '';
  DeleteFile(LocalDir + TopicId + '.d');
end;

procedure TTopic.EraseIdx;
begin
  DeleteFile(LocalDir + TopicId + '.i');
end;

// O̍폜
procedure TTopic.EraseLog;
var
  b: TOnlineBoard;

begin
  //CancelDownload;
  
  // 폜
  EraseDat;
  EraseIdx;

  FreeMessage;

  Priority        := 0;
  LastReadDate    := '';
  LastWriteDate   := '';
  Memo            := '';
  Exclude(Status, tsGotLog);

  StatusText := 'u' + Title + 'ṽO폜܂';
  if tsFavorite in Status then
  begin
    // Cɓ肩͂
    Exclude(Status, tsFavorite);
    b := OnlineBoard as TOnlineBoard;
    (b.BoardList as TBoardList).MyFolder.FavoriteBoard.RemoveTopic(self);
  end;
  if Assigned(OnComplete) then
  begin
    gSynchronizer.DoSynchronize(SyncOnComplete);
  end;
end;

procedure TTopic.CheckWriteFolder;
begin
  // tH_Ȃ΍
  if DirectoryExists(LocalDir) = false then
  begin
    CreateFullDir(LocalDir);
  end;
end;

procedure TTopic.AddNewMessage;
begin
  FMsg.Index := FMessageList.Count + 1;
  FMessageList.Add(FMsg);
end;

{ TTopicMessage }

// |bvAbvp̃bZ[W
function TTopicMessage.GetForPopup: string;
var
  pureText: string;
  regEx: TRegExpr;

begin
  pureText := IntToStr(Index) + ' ' +
              'OF' + PostName + ' ';
  if gConfig.DispMailAddress and (PostEmail <> '') then
  begin
    pureText := pureText + '[' + PostEmail + ']';
  end;
  pureText := pureText + 'eF' + RestStr  + #10 + Body;

  // HTML^O
	puretext := StringReplace(pureText, '<br>', #10, [rfReplaceAll]);
  regEx := TRegExpr.Create;
  regEx.Expression := '<.*?>';
  pureText := regEx.Replace(pureText, '');
  regEx.Free;

  // ꕶϊ
  pureText := StringReplace(pureText, '&gt;', '>', [rfReplaceAll]);
  pureText := StringReplace(pureText, '&lt;', '<', [rfReplaceAll]);

  result := pureText;
end;

end.
