unit untLogSweeper;

interface

uses
  Classes,
  untBoard, untTopic, untTool, untBoardList, untOfflineBoard;

type

  TLogSweeper = class(TThread)
  private
    FSelectedBoard: TOfflineBoard;
    FTopicList:          TList;
    FNotDeleteTopicList: TList;
    FAllSize : Currency;
    procedure TopicReceived(Sender: TObject);
    procedure NotDeleteTopicReceived(Sender: TObject);
  public
    LogLimitSize: integer;
    BoardList: TBoardList;
    procedure Execute; override;
    constructor Create;
    destructor Destroy; override;
  end;

implementation

uses
  Contnrs, SysUtils, StrUtils, Dialogs, Math,
  untConfig, untGlobal, untAllSubscribedTopics;

function SortCompare(Item1, Item2: Pointer): Integer;
begin
  result := CompareValue(TTopic(Item1).FileDate, TTopic(Item2).FileDate);
end;

{ TLogSweeper }

procedure TLogSweeper.TopicReceived(Sender: TObject);
var
  i: integer;

begin
  for i := 0 to FSelectedBoard.TopicList.Count - 1 do
  begin
    if FNotDeleteTopicList.IndexOf(FSelectedBoard.TopicList[i]) = -1 then
    begin
      FTopicList.Add(FSelectedBoard.TopicList[i]);
    end;
  end;
end;

procedure TLogSweeper.NotDeleteTopicReceived(Sender: TObject);
var
  i: integer;
  
begin
  for i := 0 to FSelectedBoard.TopicList.Count - 1 do
  begin
    FNotDeleteTopicList.Add(FSelectedBoard.TopicList[i]);
  end;
end;

procedure TLogSweeper.Execute;
var
  i: integer;
  deleteSize: currency;
  limitSize: currency;

  procedure BoardDownload(b: TOfflineBoard);
  begin
    FSelectedBoard := b;
    if b is TAllSubscribedTopics then
    begin
      b.OnReceived := TopicReceived;
    end else
    begin
      b.OnReceived := NotDeleteTopicReceived;
    end;
    b.SendTopicList;
  end;

begin
  // 폜ȂgsbNXg擾
  for i := 0 to BoardList.MyFolder.Boards.Count - 1 do
  begin
    if not (TBoard(BoardList.MyFolder.Boards[i]) is TAllSubscribedTopics) then
    begin
      BoardDownload(BoardList.MyFolder.Boards[i]);
    end;
  end;

  BoardDownload(BoardList.MyFolder.AllSubscribedTopics);
  FTopicList.Sort(SortCompare);

  FAllSize := 0;
  for i := 0 to FNotDeleteTopicList.Count - 1 do
  begin
    FAllSize := FAllSize + TTopic(FNotDeleteTopicList[i]).FileSize;
  end;
  for i := 0 to FTopicList.Count - 1 do
  begin
    FAllSize := FAllSize + TTopic(FTopicList[i]).FileSize;
  end;

  limitSize := LogLimitSize * power(2, 20);
  if FAllSize <= limitSize then
  begin
    Terminate;
    exit;
  end;

  // wTCYɎ܂悤ɍ폜
  deleteSize := 0;
  for i := 0 to FTopicList.Count - 1 do
  begin
    deleteSize := deleteSize + TTopic(FTopicList[i]).FileSize;
    if Terminated then
    begin
      break;
    end;
    Synchronize(TTopic(FTopicList[i]).EraseLog);
    if FAllSize - deleteSize <= limitSize then
    begin
      break;
    end;
  end;
end;

constructor TLogSweeper.Create;
begin
  inherited Create(True);
  
  FTopicList := TList.Create;
  FNotDeleteTopicList := TList.Create;
end;

destructor TLogSweeper.Destroy;
begin
  FTopicList.Clear;
  FTopicList.Free;
  FNotDeleteTopicList.Clear;
  FNotDeleteTopicList.Free;

  inherited;
end;

end.
