unit untGlobal;
// O[oȃNXBB

interface

uses
  Classes, Messages,
  untJaneConfig, untFolderAlias, untDolibLogin, untConfig, untTool,
  untTaskManager;

const
  CONNECT_TIMEOUT = 4000;
  APP_NAME = 'katju88kid';
  CM_OPENURL = WM_APP + 88;

type
  TFrameworkErrorType = (etNoError, etAbone, etParse, etPostArticle,
                         etDatFreezed, etSocketError, etBrokenGZip, etBoardState);

  TFrameworkError = procedure(Sender: TObject;
                              const ErrorCode: TFrameworkErrorType;
                              const ErrorString: string) of object;

  TBBSType = (btAuto, bt2ch, btDolib, btKako, btJBBS, btShitaraba,
              btMitinoku, btYahoo, btWinny, btLiveSoccer, btNone);

  TSynchronizer = class(TThread)
  protected
    procedure Execute; override;
  public
    procedure DoSynchronize(m: TThreadMethod);
    procedure DoProcessMessage;
  end;

  function GetBBSType(const Server: string): TBBSType;

var
  gConfig:      TConfig;
  gFolderAlias: TFolderAlias;
  gJaneConfig:  TJaneConfig;
  gDolibLogin:  TDolibLogin;
  gTaskManager: TTaskManager;
  gSynchronizer: TSynchronizer;

implementation

uses
  ActiveX, Forms;

procedure TSynchronizer.DoProcessMessage;
begin
  Application.ProcessMessages;
end;

procedure TSynchronizer.DoSynchronize(m: TThreadMethod);
begin
  Synchronize(m);
end;

procedure TSynchronizer.Execute;
begin
  // ĂяoȂ
end;

function GetBBSType(const Server: string): TBBSType;
begin
  // BBSType𔻒f
  if (Pos('machi.to', Server) > 0) or
     (Pos('machibbs.com', Server) > 0) or
     (Pos('jbbs', Server) > 0) then
  begin
    result := btJBBS;
  end else if Pos('shitaraba.com', Server) > 0 then
  begin
    result := btShitaraba;
  end else if Pos('www.mitinoku.jp', Server) > 0 then
  begin
    result := btMitinoku;
  end else if Pos('livesoccer.net', Server) > 0 then
  begin
    result := btLiveSoccer;
  end else
  begin
    result := bt2ch;
  end;
end;

initialization
  OleInitialize(nil);

  // ݒǂݏo
  gConfig := TConfig.Create(AppPath(FILE_OPTIONINI));
  gConfig.ReadOption();

  // eCX^X̍쐬
  gFolderAlias := TFolderAlias.Create;
  gJaneConfig  := TJaneConfig.Create;
  gDolibLogin  := TDolibLogin.Create;
  gTaskManager := TTaskmanager.Create;
  gSynchronizer := TSynchronizer.Create(True);

  if gConfig.AutoLogin then
  begin
    gDolibLogin.Login;
  end;

finalization
  // eCX^X̔p
  gJaneConfig.Free;
  gFolderAlias.Free;
  gDolibLogin.Free;
  gTaskManager.Free;
  gSynchronizer.Free;

  // ݒ菑o
  gConfig.WriteOption();
  gConfig.Free;

  OleUninitialize;

end.
