unit untBoardCategory;

interface

uses
  Graphics, Classes, Contnrs,
  untOnlineBoard;

type
  TBoardCategory = class
  protected
    FBoardList: TObject;
    FBoardCache: TObjectList;
  public
    Opened: boolean;
    CategoryName: string;
    Color: TColor;
    Boards: TList;
    constructor Create(bl: TObject);
    destructor  Destroy; override;
    function AddBoard(const Server, BoardName, DisplayName: string): TOnlineBoard;
    function GetBoard(const Server, BoardName: string): TOnlineBoard;
  end;

implementation

uses
  untBoard, untGlobal, untBoard2ch, untBoardJBBS;

function TBoardCategory.GetBoard(const Server, BoardName: string): TOnlineBoard;
var
  i: integer;
  b: TOnlineBoard;

begin
  result := nil;
  for i := 0 to FBoardCache.Count - 1 do
  begin
    b := TOnlineBoard(FBoardCache[i]);
    // T[o[͕ʖ̂ŔrȂł̂낤
    // 
    // (b.Server = Server)
    if (b.BoardName = BoardName) then
    begin
      result := b;
      break;
    end;
  end;
end;

function TBoardCategory.AddBoard(const Server, BoardName, DisplayName: string): TOnlineBoard;
var
  newBoard: TOnlineBoard;
  bbs: TBBSType;

begin
  bbs := GetBBSType(Server);
  if (bbs = bt2ch) or (bbs = btLiveSoccer) then
  begin
    newBoard := TBoard2ch.Create;
  end else if bbs = btJBBS then
  begin
    newBoard := TBoardJBBS.Create;
  end else
  begin
    newBoard := nil;
  end;
  newBoard.Server      := Server;
  newBoard.BoardName   := BoardName;
  newBoard.DisplayName := DisplayName;
  newBoard.BoardList   := FBoardList;
  newBoard.Category    := self;
  newBoard.SubjectURL  := 'http://' + Server + '/' + BoardName + '/subject.txt';
  FBoardCache.Add(newBoard);
  Boards.Add(newBoard);

  result := newBoard;
end;

constructor TBoardCategory.Create(bl: TObject);
begin
  inherited Create;

  FBoardList := bl;
  FBoardCache := TObjectList.Create;
  Boards := TList.Create;
end;

destructor TBoardCategory.Destroy;
begin
  Boards.Free;
  FBoardCache.Clear;
  FBoardCache.Free;

  inherited;
end;

end.
