unit untBoardListView;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, ComCtrls, Contnrs,
  untBoardCategory, untBoard, untBoardList;

type
  TBoardListViewItem = class
  public
    Category: TBoardCategory;
    Board: TBoard;
    ViewString: string;
  end;

  TBoardListView = class(TListView)
  private
    { Private 錾 }
     FListItemToClear:    TObjectList;
     FBoardListViewItems: TObjectList;
  protected
    { Protected 錾 }
    procedure BoardListViewData(Sender: TObject; Item: TListItem);
    procedure BoardListViewCustomDrawItem(Sender: TCustomListView;
                                          Item: TListItem;
                                          State: TCustomDrawState;
                                          var DefaultDraw: Boolean);
  public
    { Public 錾 }
    procedure OpenCategory(bc: TBoardCategory);
    procedure OpenBoard(board: TBoard);
    procedure CloseCategory(bc: TBoardCategory);
    procedure Reload(boardList: TBoardList);
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    function SelectedItem: TBoardListViewItem;
    function GetItem(const i: integer): TBoardListViewItem;
  published
    { Published 錾 }
  end;

procedure Register;

implementation

uses
  Graphics, Commctrl, untGlobal;

procedure TBoardListView.OpenCategory(bc: TBoardCategory);
var
  i, foundIndex: integer;
  newItem, lvItem: TBoardListViewItem;
  item: TListItem;
begin
  foundIndex := -1;
  for i := 0 to FBoardListViewItems.Count - 1 do
  begin
    lvItem := (FBoardListViewItems[i] as TBoardListViewItem);
    if lvItem.Category = bc then
    begin
      bc.Opened := true;
      lvItem.ViewString := '' + bc.CategoryName;

      foundIndex := i;
      break;
    end;
  end;
  Items.BeginUpdate;
  if foundIndex > -1 then
  begin
    for i := 0 to bc.Boards.Count - 1 do
    begin
      newItem := TBoardListViewItem.Create;
      newItem.Category := bc;
      newItem.Board := TBoard(bc.Boards[i]);
      newItem.ViewString := '@' + newItem.Board.DisplayName;
      FBoardListViewItems.Insert(foundIndex + 1 + i, newItem);

      item := Items.Insert(foundIndex + 1 + i);
      FListItemToClear.Insert(foundIndex + 1 + i, item);
    end;
    Items[foundIndex + bc.Boards.Count].MakeVisible(false);
  end;
  Items[foundIndex].Focused := true;
  Items[foundIndex].Selected := true;
  Items.EndUpdate;
  DoubleBuffered := true;
  Repaint;
  DoubleBuffered := false;
end;

procedure TBoardListView.CloseCategory(bc: TBoardCategory);
var
  i, foundIndex: integer;
  lvItem: TBoardListViewItem;

begin
  foundIndex := -1;
  for i := 0 to FBoardListViewItems.Count - 1 do
  begin
    lvItem := FBoardListViewItems[i] as TBoardListViewItem;
    if lvItem.Category = bc then
    begin
      bc.Opened := false;
      lvItem.ViewString := '' + bc.CategoryName;

      foundIndex := i;
      break;
    end;
  end;
  Items.BeginUpdate;
  if foundIndex > -1 then
  begin
    for i := 0 to bc.Boards.Count - 1 do
    begin
      Items.Delete(foundIndex + 1);
      FListItemToClear.Delete(foundIndex + 1);
      FBoardListViewItems.Delete(foundIndex + 1);
    end;
  end;
  Items[foundIndex].Focused := true;
  Items[foundIndex].Selected := true;
  Items.EndUpdate;
  DoubleBuffered := true;
  Repaint;
  DoubleBuffered := false;
end;

procedure TBoardListView.OpenBoard(board: TBoard);
var
  i: integer;

begin
  for i := 0 to Items.Count - 1 do
  begin
    if (FBoardListViewItems[i] as TBoardListViewItem).Board = board then
    begin
      Items[i].Focused := true;
      Items[i].Selected := true;
      Items[i].MakeVisible(false);
      break;
    end;
  end;
end;

procedure TBoardListView.BoardListViewData(Sender: TObject; Item: TListItem);
var
  boardItem: TBoardListViewItem;

begin
  if (Item.Index >= 0) and (Item.Index < Items.Count) then
  begin
    boardItem := GetItem(Item.Index);
    Item.Caption := boardItem.ViewString;
  end;
end;

procedure TBoardListView.BoardListViewCustomDrawItem(Sender: TCustomListView;
                                                     Item: TListItem;
                                                     State: TCustomDrawState;
                                                     var DefaultDraw: Boolean);
var
  ARect, colorRect: TRect;
  defaultBrush: TColor;
  boardItem: TBoardListViewItem;

begin
  DefaultDraw := true;

  if (Item.Index < 0) or (Item.Index >= Items.Count) then
  begin
    exit;
  end;

  boardItem := GetItem(Item.Index);

  ListView_GetItemRect(Handle, Item.Index, ARect, LVIR_BOUNDS);
  // FÂ
  if not gConfig.BoardListNoColor then
  begin
    colorRect.Left   := ARect.Left;
    colorRect.Top    := ARect.Top;
    colorRect.Bottom := ARect.Bottom;
    colorRect.Right  := ARect.Left + 4;
    defaultBrush := Sender.Canvas.Brush.Color;
    Sender.Canvas.Brush.Color := boardItem.Category.Color;
    Sender.Canvas.Brush.Style := bsSolid;
    Sender.Canvas.FillRect(colorRect);
    Sender.Canvas.Brush.Color := defaultBrush;
  end;

  {colorRect.Left := colorRect.Left + 4;
  Sender.Canvas.TextRect(colorRect,
                         colorRect.Left + 1,
                         colorRect.Top + 1,
                         boardItem.ViewString);

  colorRect.Left := colorRect.Left - 4;

  if cdsFocused in State then
  begin
    // tH[JX̘g
    Sender.Canvas.DrawFocusRect(colorRect);
  end;}
end;

function TBoardListView.SelectedItem: TBoardListViewItem;
begin
  if ItemIndex > -1 then
  begin
    result := FBoardListViewItems[ItemIndex] as TBoardListViewItem;
  end else
  begin
    result := nil;
  end;
end;

function TBoardListView.GetItem(const i: integer): TBoardListViewItem;
begin
  result := FBoardListViewItems[i] as TBoardListViewItem;
end;

procedure TBoardListView.Reload(boardList: TBoardList);
var
  c_Category: TBoardCategory;
  newItem: TBoardListViewItem;
  categoryName: string;
  i, j, oldIndex, numOfChildBoards: integer;
  item: TListItem;

begin
  oldIndex := ItemIndex;
  if oldIndex > -1 then
  begin
    categoryName := Items[oldIndex].Caption;
    categoryName := Copy(categoryName, 3, Length(categoryName) - 1);
  end;
  numOfChildBoards := 0;

  Items.BeginUpdate;
  Items.Clear;
  FListItemToClear.Clear;
  FBoardListViewItems.Clear;

  for i := 0 to boardList.Categorys.Count - 1 do
  begin
    c_Category := TBoardCategory(boardList.Categorys[i]);

    newItem := TBoardListViewItem.Create;
    if c_Category.Opened then
    begin
      newItem.ViewString := '' + c_Category.CategoryName
    end else
    begin
      newItem.ViewString := '' + c_Category.CategoryName;
    end;
    newItem.Category := c_Category;
    newItem.Board    := nil;

    FBoardListViewItems.Add(newItem);

    if c_Category.Opened then
    begin
      for j := 0 to c_Category.Boards.Count - 1 do
      begin
        newItem := TBoardListViewItem.Create;
        newItem.Category   := c_Category;
        newItem.Board      := TBoard(c_Category.Boards[j]);
        newItem.ViewString := '@' + newItem.Board.DisplayName;

        FBoardListViewItems.Add(newItem);
        if categoryName = c_Category.CategoryName then
        begin
          Inc(numOfChildBoards);
        end;
      end;
    end;
  end;
  for i := 0 to FBoardListViewItems.Count - 1 do
  begin
    item := Items.Add;
    FListItemToClear.Add(item);
  end;
  //Items.Count := FBoardListViewItems.Count;
  Items.EndUpdate;
  DoubleBuffered := true;
  Repaint;
  DoubleBuffered := false;
  if oldIndex > -1 then
  begin
    Items[oldIndex].Selected := true;
    Items[oldIndex + numOfChildBoards].MakeVisible(false);
  end;
end;

constructor TBoardListView.Create(AOwner: TComponent);
begin
  inherited;

  FBoardListViewItems := TObjectList.Create;
  FListItemToClear    := TObjectList.Create;

  OnCustomDrawItem := BoardListViewCustomDrawItem;
  OnData           := BoardListViewData;
end;

destructor TBoardListView.Destroy;
begin
  FListItemToClear.Free;
  FBoardListViewItems.Free;

  inherited;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TBoardListView]);
end;

end.
