unit untConfig;

interface

uses
  Graphics,
  untHttp;

const
  APP_USERAGENT    = 'Monazilla/1.00 hage/1.00 (88000)';
  APP_2chUA        = 'katju88kid';
  DIR_LOG          = 'log\';
  FILE_BOARDALIAS  = 'board.alias';
  FILE_OPTIONINI   = 'katju88.ini';

type
  TBrowserType = (ubIE = 0 , ubDoe = 1);

  TConfig = class
  private
    FOptionIniPath : string;
    procedure SetProxy(Http: TAsyncHttp; ProxyString: string);
  public
    AlwaysNewTab: Boolean;
    AutoFocus: boolean;
    AutoLogin: boolean;
    BoardListViewWidth: Integer;
    BoardListNoColor: Boolean;
    BoardListOneCategory: Boolean;
    BoardListUrl: string;
    BrowserType: TBrowserType;
    CoolBarBandBreak: string;
    CoolBarBandId: string;
    CoolBarBandWidth: string;
    DefaultSage: Boolean;
    HeaderHtml: string;
    IsOffLineMode: Boolean;
    MainFormHeight: Integer;
    MainFormLeft: Integer;
    MainFormStyleSub1: Boolean;
    MainFormStyleSub2: Boolean;
    MainFormStyleSub3: Boolean;
    MainFormStyleType3: Boolean;
    MainFormTop: Integer;
    MainFormWidth: Integer;
    MainFormWindowState: Integer;
    MultiLineTab: Boolean;
    NewResHtml: string;
    Password: string;
    ReadProxy: string;
    ReadProxyUse: Boolean;
    ResHtml: string;
    SavePassword: boolean;
    SessionID: string;
    TopicListViewColumnFontSize: Integer;
    TopicListViewColumnOrders: string;
    TopicListViewColumnPadding: Integer;
    TopicListViewColumnWidths: string;
    TopicListViewGridLines: boolean;
    TopicListViewWidth  : Integer;
    TopicListViewHeight : Integer;
    UserAgent: string;
    UserId: string;
    ViewLimit: Integer;
    WriteProxyUse : Boolean;
    WriteProxy    : String;
    DispMailAddress: boolean;

    // OuEUݒ
    BrowserPath: string;
    InsertURL: string;
    UseDefaultBrowser: Boolean;

    //݃tH[֘A
    KoteHan: string;
    KoteMail: string;
    MailListFile: string;
    NameListFile: string;
    WriteFormWidth  : Integer;
    WriteFormHeight : Integer;
    WriteFormLeft   : Integer;
    WriteFormTop    : Integer;

    // XꗗF֘A
    TopicListColorUse: Boolean;
    TopicListFavoriteColor: TColor;
    TopicListNewMesColor: TColor;
    TopicListNewTopicColor: TColor;
    TopicListNoNewMesColor: TColor;
    TopicListNotGotColor: TColor;

    DoLogClear: boolean;
    LogLimitSize: integer;
    DoLogSave: boolean;
    constructor Create(IniPath : string);
    procedure ReadOption;
    procedure WriteOption;
    procedure InitWriteProxy(Http : TAsyncHttp);
    procedure InitReadProxy (Http : TAsyncHttp);
    procedure ParseProxy(ProxyString: string; out ProxyHost : string; out ProxyPort : Integer);
  end;

implementation

uses
  IniFiles, SysUtils, Forms,
  untCrypt, untTool;

const
  FILE_HEADERHTML    = 'Header.htm';
  FILE_RESHTML       = 'Res.htm';
  FILE_NEWRESHTML    = 'NewRes.htm';
  FILE_NAMELIST      = 'namelist.txt';
  FILE_MAILLIST      = 'maillist.txt';
  SEC_MAIN           = 'Main';
  SEC_PROXY          = 'Proxy';
  SEC_MAINFORM       = 'MainForm';
  SEC_BOARDLISTBOX   = 'BoardListBox';
  SEC_TOPICLISTVIEW  = 'TopicListView';
  SEC_COOLBAR        = 'CoolBar';
  SEC_KATJU88        = 'katju88';
  SEC_LOGIN          = 'Login';
  SEC_WRITEFORM      = 'WriteForm';
  SEC_BROWSER        = 'Browser';
  KEY_USERAGENT      = 'UserAgent';
  KEY_BOARDLISTURL   = 'BoardListUrl';
  KEY_WRITEPROXYUSE  = 'WriteProxyUse';
  KEY_WRITEPROXY     = 'WriteProxy';
  KEY_READPROXYUSE   = 'ReadProxyUse';
  KEY_READPROXY      = 'ReadProxy';
  KEY_WINDOWSTATE    = 'WindowState';
  KEY_WIDTH          = 'Width';
  KEY_HEIGHT         = 'Height';
  KEY_TOP            = 'Top';
  KEY_LEFT           = 'Left';
  KEY_STYLETYPE3     = 'StyleType3';
  KEY_STYLESUB1      = 'StyleSub1';
  KEY_STYLESUB2      = 'StyleSub2';
  KEY_STYLESUB3      = 'StyleSub3';
  KEY_VIEWLIMIT      = 'ViewLimit';
  KEY_COLUMNWIDTHS   = 'ColumnWidths';
  KEY_COLUMNORDERS   = 'ColumnOrders';
  KEY_COLUMNPADDING  = 'ColumnPadding';
  KEY_COLUMNFONTSIZE = 'ColumnFontSize';
  KEY_DEFAULTSAGE    = 'DefaultSage';
  KEY_BANDID         = 'BandId';
  KEY_BANDWIDTH      = 'BandWidth';
  KEY_BANDBREAK      = 'BandBreak';
  KEY_BROWSERTYPE    = 'BrowserType';
  KEY_ALWAYSNEWTAB   = 'AlwaysNewTab';
  KEY_MULTILINETAB   = 'MultiLineTab';
  KEY_AUTOLOGIN      = 'AutoLogin';
  KEY_USERID         = 'UserId';
  KEY_PASSWORD       = 'Password';
  KEY_SAVEPASSWORD   = 'SavePassword';
  KEY_GRIDLINES      = 'GridLines';
  KEY_NAMELIST       = 'NameListFile';
  KEY_MAILLIST       = 'MailListFile';
  KEY_NoColor        = 'NoColor';
  KEY_ONECATEGORY    = 'OneCategory';
  KEY_KOTEHAN        = 'KoteHan';
  KEY_KOTEMAIL       = 'KoteMail';
  KEY_USEDEFBROWSER  = 'UseDefBrowser';
  KEY_BROWSERPATH    = 'BrowserPath';
  KEY_INSERTURL      = 'InsertUrl';
  KEY_AUTOFOCUS      = 'AutoFocus';
  KEY_USECOLOR       = 'UseColor';
  KEY_CLNOTGOT       = 'NotGotColor';
  KEY_CLFAVORITE     = 'FavoriteColor';
  KEY_CLNEWMES       = 'NewMessageColor';
  KEY_CLNONEWMES     = 'NoNewMessageColor';
  KEY_CLNEWTOPIC     = 'NewTopicColor';
  KEY_DISPMAILADDRESS = 'DispMailAddress';
  KEY_LOGLIMITSIZE = 'LogLimitSize';
  KEY_DOLOGCLEAR = 'DoLogClear';
  KEY_DOLOGSAVE = 'DoLogSave';

{ TConfig }

//  \bh

constructor TConfig.Create(IniPath: string);
begin
  FOptionIniPath := IniPath;
end;

procedure TConfig.ReadOption;
var
  OptionIni : TIniFile;
  strPath   : string;
begin

  OptionIni      := TIniFile.Create(FOptionIniPath);

  // Main
  BoardListUrl  := OptionIni.ReadString(SEC_MAIN, KEY_BOARDLISTURL, 'http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html');
  ViewLimit     := OptionIni.ReadInteger(SEC_MAIN, KEY_VIEWLIMIT, 50);
  DefaultSage   := OptionIni.ReadBool(SEC_MAIN, KEY_DEFAULTSAGE, false);
  BrowserType   := TBrowserType(OptionIni.ReadInteger(SEC_MAIn, KEY_BROWSERTYPE, 0));
  UserAgent     := OptionIni.ReadString(SEC_MAIN, KEY_USERAGENT, APP_USERAGENT);
  AlwaysNewTab  := OptionIni.ReadBool(SEC_MAIN, KEY_ALWAYSNEWTAB, false);
  MultiLineTab  := OptionIni.ReadBool(SEC_MAIN, KEY_MULTILINETAB, false);
  AutoFocus     := OptionIni.ReadBool(SEC_MAIN, KEY_AUTOFOCUS, true);

  DispMailAddress := OptionIni.ReadBool(SEC_MAIN, KEY_DISPMAILADDRESS, false);
  DoLogClear := OptionIni.ReadBool(SEC_MAIN, KEY_DOLOGCLEAR, false);
  LogLimitSize := OptionIni.ReadInteger(SEC_MAIN, KEY_LOGLIMITSIZE, 20);
  DoLogSave := OptionIni.ReadBool(SEC_MAIN, KEY_DOLOGSAVE, true);

  // Proxy
  WriteProxyUse := OptionIni.ReadBool(  SEC_PROXY, KEY_WRITEPROXYUSE, false);
  WriteProxy    := OptionIni.ReadString(SEC_PROXY, KEY_WRITEPROXY,    '');
  ReadProxyUse  := OptionIni.ReadBool(  SEC_PROXY, KEY_READPROXYUSE,  false);
  ReadProxy     := OptionIni.ReadString(SEC_PROXY, KEY_READPROXY,     '');

  // MainForm Layout
  MainFormWindowState := OptionIni.ReadInteger(SEC_MAINFORM, KEY_WINDOWSTATE, Integer(wsNormal));
  MainFormWidth       := OptionIni.ReadInteger(SEC_MAINFORM, KEY_WIDTH,  600);
  MainFormHeight      := OptionIni.ReadInteger(SEC_MAINFORM, KEY_HEIGHT, 500);
  MainFormLeft        := OptionIni.ReadInteger(SEC_MAINFORM, KEY_LEFT,   10);
  MainFormTop         := OptionIni.ReadInteger(SEC_MAINFORM, KEY_TOP,    10);
  MainFormStyleType3  := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLETYPE3, false);
  MainFormStyleSub1   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB1,  false);
  MainFormStyleSub2   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB2,  false);
  MainFormStyleSub3   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB3,  false);
  BoardListViewWidth  := OptionIni.ReadInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,  120);
  BoardListNoColor    := OptionIni.ReadBool(SEC_BOARDLISTBOX, KEY_NoColor, false);
  BoardListOneCategory:= OptionIni.ReadBool(SEC_BOARDLISTBOX, KEY_ONECATEGORY, False);
  TopicListViewWidth  := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,  300);
  TopicListViewHeight := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT, 100);
  TopicListViewColumnOrders := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_COLUMNORDERS, '');
  TopicListViewColumnWidths := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_COLUMNWIDTHS, '');
  TopicListViewColumnPadding := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_COLUMNPADDING, 2);
  TopicListViewColumnFontSize := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_COLUMNFONTSIZE, 9);
  TopicListViewGridLines      := OptionIni.ReadBool   (SEC_TOPICLISTVIEW, KEY_GRIDLINES, false);
  CoolBarBandId             := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDID, '');
  CoolBarBandWidth          := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDWIDTH, '');
  CoolBarBandBreak          := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDBREAK, '');

  // OuEUݒ
  UseDefaultBrowser := OptionIni.ReadBool  (SEC_BROWSER, KEY_USEDEFBROWSER, True);
  BrowserPath       := OptionIni.ReadString(SEC_BROWSER, KEY_BROWSERPATH,   '');
  InsertURL         := OptionIni.ReadString(SEC_BROWSER, KEY_INSERTURL,     '');

  // wb_pHTML
  strPath := AppPath(FILE_HEADERHTML);
  if FileExists(strPath) = true then
  begin
    HeaderHtml := GetFile(strPath)
  end else
  begin
    HeaderHtml := '<html lang="ja"><body><font face="lr oSVbN"><dl>';
  end;

  // X\pHTML
  strPath := AppPath(FILE_RESHTML);
  if FileExists(strPath) = true then
  begin
    ResHtml := GetFile(strPath)
  end else
  begin
    ResHtml := '<dt>&NUMBER OF<font color="forestgreen">&MAILNAME</font> eF&DATE</dt><dd>&MESSAGE<BR></dd><br>';
  end;

  // VX\pHTML
  strPath := AppPath(FILE_NEWRESHTML);
  if FileExists(strPath) = true then
  begin
    NewResHtml := GetFile(strPath)
  end else
  begin
    NewResHtml := '<dt><b>&NUMBER</b> OF<font color="forestgreen">&MAILNAME</font> eF&DATE</dt><dd>&MESSAGE<BR></dd><br>';
  end;

  // Dolib֘A
  AutoLogin    := OptionIni.ReadBool  (SEC_LOGIN, KEY_AUTOLOGIN,    false);
  UserId       := Decrypt(OptionIni.ReadString(SEC_LOGIN, KEY_USERID,  ''));
  Password     := Decrypt(OptionIni.ReadString(SEC_LOGIN, KEY_PASSWORD,''));
  SavePassword := OptionIni.ReadBool  (SEC_LOGIN, KEY_SAVEPASSWORD, false);

  // ݊֘A
  NameListFile    := OptionIni.ReadString(SEC_WRITEFORM, KEY_NAMELIST, FILE_NAMELIST);
  MailListFile    := OptionIni.ReadString(SEC_WRITEFORM, KEY_MAILLIST, FILE_MAILLIST);
  WriteFormWidth  := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_WIDTH,  450);
  WriteFormHeight := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_HEIGHT, 370);
  WriteFormLeft   := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_LEFT,   385);
  WriteFormTop    := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_TOP,    180);
  KoteHan         := OptionIni.ReadString (SEC_WRITEFORM, KEY_KOTEHAN,  '');
  KoteMail        := OptionIni.ReadString (SEC_WRITEFORM, KEY_KOTEMAIL, '');

  // XꗗF֘A
  TopicListColorUse      := OptionIni.ReadBool   (SEC_TOPICLISTVIEW, KEY_USECOLOR,   True);
  TopicListNotGotColor   := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNOTGOT,   clBlack);
  TopicListFavoriteColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLFAVORITE, clBlack);
  TopicListNewMesColor   := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNEWMES,   16711680);
  TopicListNoNewMesColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNONEWMES, clBlack);
  TopicListNewTopicColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNEWTOPIC, 4227327);

  OptionIni.Free;
end;

procedure TConfig.WriteOption;
var
  OptionIni : TIniFile;
begin
  OptionIni := TIniFile.Create(FOptionIniPath);

  // Main
  OptionIni.WriteString(SEC_MAIN, KEY_BOARDLISTURL, BoardListUrl);
  OptionIni.WriteInteger(SEC_MAIN, KEY_VIEWLIMIT, ViewLimit);
  OptionIni.WriteBool(SEC_MAIN, KEY_DEFAULTSAGE, DefaultSage);
  OptionIni.WriteInteger(SEC_MAIn, KEY_BROWSERTYPE, Integer(BrowserType));
  //OptionIni.WriteString(SEC_MAIN, KEY_USERAGENT, FUserAgent);
  OptionIni.WriteBool(SEC_MAIN, KEY_ALWAYSNEWTAB, AlwaysNewTab);
  OptionIni.WriteBool(SEC_MAIN, KEY_MULTILINETAB, MultiLineTab);
  OptionIni.WriteBool(SEC_MAIN, KEY_AUTOFOCUS, AutoFocus);

  OptionIni.WriteBool(SEC_MAIN, KEY_DISPMAILADDRESS, DispMailAddress);
  OptionIni.WriteInteger(SEC_MAIN, KEY_LOGLIMITSIZE, LogLimitSize);
  OptionIni.WriteBool(SEC_MAIN, KEY_DOLOGCLEAR, DoLogClear);
  OptionIni.WriteBool(SEC_MAIN, KEY_DOLOGSAVE, DoLogSave);

  // Proxy
  OptionIni.WriteBool(  SEC_PROXY, KEY_WRITEPROXYUSE, WriteProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_WRITEPROXY,    WriteProxy);
  OptionIni.WriteBool(  SEC_PROXY, KEY_READPROXYUSE,  ReadProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_READPROXY,     ReadProxy);

  // MainForm Layout
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_WINDOWSTATE, MainFormWindowState);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_WIDTH,       MainFormWidth);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_HEIGHT,      MainFormHeight);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_LEFT,        MainFormLeft);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_TOP,         MainFormTop);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLETYPE3, MainFormStyleType3);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB1,  MainFormStyleSub1);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB2,  MainFormStyleSub2);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB3,  MainFormStyleSub3);
  OptionIni.WriteInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,   BoardListViewWidth);
  OptionIni.WriteBool(SEC_BOARDLISTBOX, KEY_NOCOLOR,     BoardListNoColor);
  OptionIni.WriteBool(SEC_BOARDLISTBOX, KEY_ONECATEGORY, BoardListOneCategory);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,        TopicListViewWidth);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT,       TopicListViewHeight);
  OptionIni.WriteString (SEC_TOPICLISTVIEW, KEY_COLUMNWIDTHS, TopicListViewColumnWidths);
  OptionIni.WriteString (SEC_TOPICLISTVIEW, KEY_COLUMNORDERS, TopicListViewColumnOrders);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_COLUMNPADDING, TopicListViewColumnPadding);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_COLUMNFONTSIZE, TopicListViewColumnFontSize);
  OptionIni.WriteBool   (SEC_TOPICLISTVIEW, KEY_GRIDLINES, TopicListViewGridLines);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDID, CoolBarBandId);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDWIDTH, CoolBarBandWidth);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDBREAK, CoolBarBandBreak);

  // OuEUݒ
  OptionIni.WriteBool  (SEC_BROWSER, KEY_USEDEFBROWSER, UseDefaultBrowser);
  OptionIni.WriteString(SEC_BROWSER, KEY_BROWSERPATH,   BrowserPath);
  OptionIni.WriteString(SEC_BROWSER, KEY_INSERTURL,     InsertURL);

  // Dolib֘A
  OptionIni.WriteBool  (SEC_LOGIN, KEY_AUTOLOGIN,    AutoLogin);
  OptionIni.WriteString(SEC_LOGIN, KEY_USERID,       Crypt(UserId));
  OptionIni.WriteBool  (SEC_LOGIN, KEY_SAVEPASSWORD, SavePassword);
  if SavePassword then
    OptionIni.WriteString(SEC_LOGIN, KEY_PASSWORD,   Crypt(Password))
  else
    OptionIni.DeleteKey(SEC_LOGIN, KEY_PASSWORD);

  // ݊֘A
  OptionIni.WriteString(SEC_WRITEFORM, KEY_NAMELIST, NameListFile);
  OptionIni.WriteString(SEC_WRITEFORM, KEY_MAILLIST, MailListFile);
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_WIDTH,  WriteFormWidth);
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_HEIGHT, WriteFormHeight);
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_LEFT,   WriteFormLeft);
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_TOP,    WriteFormTop);
  OptionIni.WriteString (SEC_WRITEFORM, KEY_KOTEHAN,  KoteHan);
  OptionIni.WriteString (SEC_WRITEFORM, KEY_KOTEMAIL, KoteMail);

  // XꗗF֘A
  OptionIni.WriteBool   (SEC_TOPICLISTVIEW, KEY_USECOLOR,   TopicListColorUse);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNOTGOT,   TopicListNotGotColor);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLFAVORITE, TopicListFavoriteColor);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNEWMES,   TopicListNewMesColor);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNONEWMES, TopicListNoNewMesColor);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNEWTOPIC, TopicListNewTopicColor);

  OptionIni.Free;
end;

procedure TConfig.SetProxy(Http: TAsyncHttp; ProxyString : string);
var
  host : string;
  port : integer;
begin
  ParseProxy(ReadProxy, host, port);
  Http.ProxyHost := host;
  Http.ProxyPort := port;
end;

procedure TConfig.InitReadProxy(Http: TAsyncHttp);
begin
  if ReadProxyUse then
    SetProxy(Http, ReadProxy);
end;

procedure TConfig.InitWriteProxy(Http: TAsyncHttp);
begin
  if WriteProxyUse then
    SetProxy(Http, WriteProxy);
end;

procedure TConfig.ParseProxy(ProxyString: string; out ProxyHost: string;
  out ProxyPort: Integer);
var
  proxyitem : TStringArray;
begin

  SetLength(proxyitem, 0);
  if ProxyString <> '' then
  begin
    proxyitem := Split(ProxyString, ':');
    if length(proxyitem) >= 2 then
      proxyport := StrToIntNeo(proxyitem[1])
    else
      proxyport := 8080;
    proxyhost := proxyitem[0];
  end;

end;

end.
