unit unt2chUrlParser;

{ 2ch url ̓jbg }

interface

type

  T2chUrlParser = class
  private
    FIs2chUrl: boolean;
    FServer:    string;
    FBoardName: string;
    FTopicId:   string;
  public
    StartNo: integer;
    EndNo:   integer;
    procedure Parse(const URI: string);
    property Is2chUrl: boolean read FIs2chUrl;
    property Server:    string read FServer;
    property BoardName: string read FBoardName;
    property TopicId:   string read FTopicId;
  end;

implementation

uses
  RegExpr, Classes, SysUtils, StrUtils,
  untTool, untGlobal;

procedure T2chUrlParser.Parse(const URI: string);
const
  reg2chServer = '(2ch\.net|bbspink\.com)';
  regMachiServer = '(machi\.to|machibbs\.com)';

var
  regEx, regExOpt: TRegExpr;
  match: boolean;
  bt: TBBSType;

begin
  FIs2chUrl := false;

  bt := GetBBSType(URI);
  if (bt = bt2ch) and (Pos('2ch.net/', URI) = 0) and (Pos('bbspink.com/', URI) = 0) then
  begin
    // uEUŊJ
    exit;
  end;

  regEx := TRegExpr.Create;

  case bt of
    bt2ch:
    begin
      // http://server.2ch.net/test/read.cgi/bbs/dat/opt
      regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/test/read\.cgi/(\w+)/(\w+)/(.*)';
      match := regEx.Exec(URI);
      if not match then
      begin
        // http://server.2ch.net/bbs/dat/nnn.dat
        regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/(\w+)/dat/(\w+)\.dat';
        match := regEx.Exec(URI);
        if not match then
        begin
          // http://server.2ch.net/bbs/kako/nnn/dat.html
          regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/(\w+)/kako/(\w+)/dat\.html';
          match := regEx.Exec(URI);
          if not match then
          begin
            // http://server.2ch.net/sub/test/read.cgi?bbs=bbs&key=dat
            regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/sub/test/read\.cgi\?bbs=(\w+)&key=(\w+)';
            match := regEx.Exec(URI);
            if not match then
            begin
              // http://server.2ch.net/bbs/kako/nnn/nnnn/dat.html
              regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/(\w+)/kako/\w+/\w+/(\w+)\.html';
              match := regEx.Exec(URI);
            end;
          end;
        end;
      end;
      if match then
      begin
        FServer := regEx.Match[1] + regEx.Match[2];
        FBoardName := regEx.Match[3];
        FTopicId := regEx.Match[4];
        FIs2chUrl := true;
        if regEx.SubExprMatchCount > 4 then
        begin
          regExOpt := TRegExpr.Create;
          regExOpt.Expression := '(\d{1,3})(.?)(\d{1,3})?';
          if regExOpt.Exec(regEx.Match[5]) then
          begin
            if regExOpt.Match[2] = '-' then
            begin
              StartNo := StrToInt(regExOpt.Match[1]);
              if regExOpt.SubExprMatchCount > 2 then
              begin
                EndNo := StrToInt(regExOpt.Match[3]);
              end else
              begin
                EndNo := 0;
              end;
            end else
            begin
              StartNo := StrToInt(regExOpt.Match[1]);
              EndNo   := StartNo;
            end;
          end;
        end;
      end else
      begin
        // 
        // http://server.2ch.net/test/read.cgi/bbs/?opt
        regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/test/read\.cgi/(\w+)/.*';
        match := regEx.Exec(URI);
        if not match then
        begin
          // http://server.2ch.net/bbs/
          regEx.Expression := 'http://(\w+\.)' + reg2chServer + '/(\w+)/';
          match := regEx.Exec(URI);
        end;
        if match then
        begin
          FServer := regEx.Match[1] + regEx.Match[2];
          FBoardName := regEx.Match[3];
          FIs2chUrl := true;
        end;
      end;
    end;
    btJBBS:
    begin
      // ܂BBS
      // http://server.mach.to/bbs/read.cgi?bbs=bbs&key=dat
      regEx.Expression := 'http://(\w+\.)' + regMachiServer + '/bbs/read\.(cgi|pl)\?BBS=(\w+)&KEY=(\w+)&?.*';
      match := regEx.Exec(URI);
      if match then
      begin
        FServer := regEx.Match[1] + regEx.Match[2];
        FBoardName := regEx.Match[4];
        FTopicId := regEx.Match[5];
        FIs2chUrl := true;
      end else
      begin
        // http://server.mach.to/bbs/
        regEx.Expression := 'http://(\w+\.)' + regMachiServer + '/(\w+)/';
        match := regEx.Exec(URI);
        if match then
        begin
          FServer := regEx.Match[1] + regEx.Match[2];
          FBoardName := regEx.Match[3];
          FIs2chUrl := true;
        end;
      end;
    end;
    btLiveSoccer:
    begin
      // TbJ[
      // http://livesoccer.net/cgi-bin/12ch/test/read.cgi/bbs/dat/
      regEx.Expression := 'http://livesoccer.net/cgi-bin/12ch/test/read.cgi/(\w+)/(\w+)/&?.*';
      match := regEx.Exec(URI);
      if match then
      begin
        FServer := 'livesoccer.net/cgi-bin/12ch';
        FBoardName := regEx.Match[1];
        FTopicId := regEx.Match[2];
        FIs2chUrl := true;
      end else
      begin
        regEx.Expression := 'http://livesoccer.net/cgi-bin/12ch/(\w+)/index.html';
        match := regEx.Exec(URI);
        if match then
        begin
          FServer := 'livesoccer.net/cgi-bin/12ch';
          FBoardName := regEx.Match[1];
          FIs2chUrl := true;
        end;
      end;
    end;
  end;
end;

end.
