unit untUpdateBoardForm;

interface 

uses 
  Classes, Controls, StdCtrls, ComCtrls, Forms, ExtCtrls,
  IdComponent, IdHTTP, IdException,
  untBoardList;

type 
  TUpdateBoardListForm = class(TForm) 
    ProgressBar1: TProgressBar; 
    Button1: TButton; 
    Timer1: TTimer; 
    procedure Timer1Timer(Sender: TObject);
  private 
    FIsProxyConnected : boolean;
    procedure Timer1Status(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string); 
    procedure HostNotFoundError(E : EIdSocketError); 
    procedure FileNotFoundOrForbiddenError(E : EIdHTTPProtocolException); 
  public 
    { Public 錾 }
    BoardList: TBoardList;
  end; 

var 
  UpdateBoardListForm: TUpdateBoardListForm; 

implementation

uses
  jconvert, SysUtils, Dialogs,
  untGlobal, untTool;

{$R *.DFM}
const 
  PROXY_ERROR = 'vLVڑɃG[N܂B'#10; 
  LIST_ERROR  = '{[hꗗt@C擾ɃG[N܂B'#10; 

procedure TUpdateBoardListForm.Timer1Timer(Sender: TObject); 
var 
  http: TIdHttp;
  src: string;
  proxyHost: string;
  proxyPort: integer;

begin
  Timer1.Enabled := false; 
  FIsProxyConnected := false; 
  // XV 
  http := TIdHttp.Create(nil);
  http.OnStatus := Timer1Status;

  // proxy
  if gConfig.ReadProxyUse then
  begin
    gConfig.ParseProxy(gConfig.ReadProxy, proxyHost, proxyPort);
    http.ProxyParams.ProxyServer := proxyHost;
    http.ProxyParams.ProxyPort   := proxyPort;
  end;

  try
    http.ConnectTimeout := CONNECT_TIMEOUT;
    src := http.Get(gConfig.BoardListUrl);
    src := ConvertJCode(src, SJIS_OUT);
    ProgressBar1.Position := 100; 
    Application.ProcessMessages;
     
    BoardList.UpdateBoard(src);
  except 
    on E: EIdSocketError do 
      HostNotFoundError(E); 
    on E: EIdHTTPProtocolException do 
      FileNotFoundOrForbiddenError(E); 
    on E: Exception do
      ShowMessage('{[hꗗt@C擾ɃG[N܂B ' + E.Message);
  end;

  Http.Free;
  Close; 
end; 

procedure TUpdateBoardListForm.Timer1Status(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string); 
begin 
  // Ƃ₵ł 
  if AStatus = hsConnected then
  begin
    FIsProxyConnected := true;
  end;
end;

procedure TUpdateBoardListForm.HostNotFoundError(E: EIdSocketError);
begin
  if gConfig.ReadProxyUse and not FIsProxyConnected then
  begin
    ShowMessage(PROXY_ERROR + gConfig.ReadProxy + ' ͌܂B')
  end else
  begin
    ShowMessage(LIST_ERROR + 'T[o ' + Split(gConfig.BoardListUrl, '/')[2] + ' ͌܂B');
  end;
end;

procedure TUpdateBoardListForm.FileNotFoundOrForbiddenError(E: EIdHTTPProtocolException);
begin 
  if gConfig.ReadProxyUse then
  begin
    ShowMessage(PROXY_ERROR + gConfig.ReadProxy + ' ɐڑۂ܂')
  end else if E.ReplyErrorCode = 403 then
  begin
    ShowMessage(LIST_ERROR + gConfig.BoardListUrl + ' ւ̃ANZX͋ۂ܂B')
  end else if E.ReplyErrorCode = 404 then
  begin
    ShowMessage(LIST_ERROR + gConfig.BoardListUrl + ' ͂܂łB');
  end;
end; 

end.
