unit ThProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, ComCtrls, Buttons, Katjusha, OleCtrls, SHDocVw,
  ThreadView, ExtCtrls, FavUtils, Spin;

type
	TThreadPropertyForm = class(TForm)
    OKBtn: TBitBtn;
		BitBtn2: TBitBtn;
		PageControl1: TPageControl;
		TabSheet1: TTabSheet;
		Label1: TLabel;
		Label2: TLabel;
    TitleEdit: TEdit;
    URLText: TEdit;
    TabSheet2: TTabSheet;
    ThreadViewFrame1: TThreadViewFrame;
    NormalCheck: TCheckBox;
    DatDropCheck: TCheckBox;
    InFavoriteCheck: TCheckBox;
    Label3: TLabel;
    Bevel1: TBevel;
    BitBtn1: TBitBtn;
    Label4: TLabel;
    BoardNameEdit: TEdit;
    Label5: TLabel;
    ServerNameEdit: TEdit;
    ResSpinEdit: TSpinEdit;
    Label6: TLabel;
    Label7: TLabel;
    BeforeResSpinEdit: TSpinEdit;
    NewResSpinEdit: TSpinEdit;
    Label8: TLabel;
    RegetDatBtn: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure RegetDatBtnClick(Sender: TObject);
	private
		{ Private 錾 }
		GripRect, OldGripRect: TRect;
		ThreadIdx: T2chThreadIndex;
		procedure SetThreadIdxData;
		procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
	public
		{ Public 錾 }
		class function Execute(Owner: TComponent; ThreadIdx: T2chThreadIndex): Boolean;
	end;

implementation

uses IdHttp, IdException, regex, AWKFunc, IdTCPConnection, gzip;

{$R *.dfm}
	
{ TThreadPropertyForm }

class function TThreadPropertyForm.Execute(Owner: TComponent; ThreadIdx: T2chThreadIndex): Boolean;
var
	ThreadPropertyForm: TThreadPropertyForm;
begin
	ThreadPropertyForm := TThreadPropertyForm.Create(Owner);
	try
		ThreadPropertyForm.ThreadIdx := ThreadIdx;
		Execute := (ThreadPropertyForm.ShowModal = mrOk);
	finally
		ThreadPropertyForm.Free;
	end;
end;

procedure TThreadPropertyForm.FormShow(Sender: TObject);
begin
	SetThreadIdxData;
	
	ThreadViewFrame1.FrameCreate(Self);
	ThreadViewFrame1.LoadDatFile(ThreadIdx);
end;

procedure TThreadPropertyForm.FormPaint(Sender: TObject);
begin
	if WindowState = wsNormal then
	begin
		DrawFrameControl(Canvas.Handle, GripRect, DFC_SCROLL, DFCS_SCROLLSIZEGRIP);
		OldGripRect := GripRect;
	end;
end;

procedure TThreadPropertyForm.WMNCHitTest(var Message: TWMNCHitTest);
var
	P: TPoint;
begin
	inherited;
	P := ScreenToClient(Point(Message.XPos, Message.YPos));
	if PtInRect(GripRect, P) then
		Message.Result := HTBOTTOMRIGHT;
end;

procedure TThreadPropertyForm.FormCreate(Sender: TObject);
begin
	GripRect := ClientRect;
	GripRect.Top := GripRect.Bottom - 15;
	GripRect.Left := GripRect.Right - 15;
	OldGripRect := GripRect;
end;

procedure TThreadPropertyForm.FormResize(Sender: TObject);
begin
	GripRect := ClientRect;
	GripRect.Top := GripRect.Bottom - 15;
	GripRect.Left := GripRect.Right - 15;
	InvalidateRect(Handle, @OldGripRect, True);
	InvalidateRect(Handle, @GripRect, True);
end;

procedure TThreadPropertyForm.OKBtnClick(Sender: TObject);
var
	State: T2chThreadStates;
begin
	State := [];

	if NormalCheck.Checked then State := State + [stNormal];
	if DatDropCheck.Checked then State := State + [stLog];
	if InFavoriteCheck.Checked then State := State + [stFavorite];

	ThreadIdx.State := State;

	ThreadIdx.ThreadName := TitleEdit.Text;
	ThreadIdx.BoardName := BoardNameEdit.Text;
	ThreadIdx.ServerName := ServerNameEdit.Text;
	ThreadIdx.ResCount := ResSpinEdit.Value;
	ThreadIdx.BeforeResCount := BeforeResSpinEdit.Value;
	ThreadIdx.NewResCount := NewResSpinEdit.Value;
end;

procedure TThreadPropertyForm.BitBtn1Click(Sender: TObject);
var
	URL, LogPath, DatPath: string;
	HTTP: TIdHTTP;
	Range, RangeStart, RangeEnd, ReadCount, I, J, K, ResCount: Integer;
	CommParams: TKatjushaCommunicationParams;
	TempIdx: T2chThreadIndex;
	Dat, ResponseDat: T2chThreadDat;
	Stream, LastResStream: TMemoryStream;
	ResTime, ResponseResTime: TDateTime;
	OrigCursor: TCursor;
	DateVar: Variant;
begin
	OrigCursor := Screen.Cursor;
	HTTP := nil;
	TempIdx := nil;
	Dat := nil;
	ResponseDat := nil;
	Stream := nil;
	LastResStream := nil;
	ResCount := 0;
	DateVar := Null;

	try
		{ J[\ύX }
		OrigCursor := Screen.Cursor;
		Screen.Cursor := crHourGlass;

		HTTP := TIdHTTP.Create(nil);
		Dat := T2chThreadDat.Create;
		ResponseDat := T2chThreadDat.Create;
		TempIdx := T2chThreadIndex.Create;
		Stream := TMemoryStream.Create;
		LastResStream := TMemoryStream.Create;

		LogPath := TKatjusha.GetKatjushaBaseDir + 'log\' + ThreadIdx.LogPath;
		DatPath := TKatjusha.GetKatjushaBaseDir + 'log\' + ChangeFileExt(ThreadIdx.LogPath, '.dat');

		TempIdx.LoadFromFile(LogPath);
		Dat.LoadFromFile(DatPath);
		URL := TempIdx.DatPath;

		{ DATPs̕ϕvZ }
		ReadCount := 0;
		for I := 0 to Dat.Count - 1 do
			ReadCount := ReadCount + Length(Dat[I]) + 1;
		ReadCount := (ReadCount div Dat.Count) * 50;	{ 50s܂Ƃ߂ēǂݍ }

		CommParams := TKatjusha.GetCommParams;

		{ ܂HeadNGXgŃTCYmF }

		with HTTP do
		begin
			Request.Clear;
			Request.UserAgent := CommParams.UserAgent;
			ProxyParams.Clear;
			if CommParams.ProxyParams.ProxyServer <> '' then
				ProxyParams.Assign(CommParams.ProxyParams);
			ReadTimeout := CommParams.ReadTimeOut;
			Response.Clear;
		end;

		try
			HTTP.Head(URL);
		except
			on E: EIdException do
				begin
					ShowMessage('ʐMG[: ' + E.Message);
					Exit;
				end;
		end;

{		if TempIdx.DatSize = HTTP.Response.ContentLength then
		begin
			ShowMessage('O͋l܂Ă܂łB');
			Exit;
		end; }

		RangeStart := HTTP.Response.ContentLength;
		RangeEnd := 0;
		
		repeat
			with HTTP do
			begin
				Request.Clear;
				Request.UserAgent := CommParams.UserAgent;
				ProxyParams.Clear;
				if CommParams.ProxyParams.ProxyServer <> '' then
					ProxyParams.Assign(CommParams.ProxyParams);
				ReadTimeout := CommParams.ReadTimeOut;
				Response.Clear;
			end;

			Stream.Clear;
			if RangeStart < ReadCount
				then RangeStart := 0
				else Dec(RangeStart, ReadCount);
			with HTTP.Request do
			begin
				ContentRangeStart := RangeStart;
				ContentRangeEnd := RangeEnd;
				if (ContentRangeStart = 0) and (ContentRangeEnd = 0) then
					AcceptEncoding := 'gzip';
			end;
			
			try
				HTTP.Get(URL, Stream);
			except
				on E: EIdException do
					begin
						ShowMessage('ʐMG[: ' + E.Message);
						Exit;
					end;
			end;

      RangeStart := HTTP.Response.ContentRangeStart;

			if HTTP.Response.ContentEncoding = 'gzip' then
				UnzipStream(Stream);

			if LastResStream.Size > 0 then
			begin
				LastResStream.Seek(0, soFromBeginning);
				Stream.Seek(0, soFromEnd);
				Stream.CopyFrom(LastResStream, LastResStream.Size);
			end;
			
			Stream.Seek(0, soFromBeginning);
			ResponseDat.LoadFromStream(Stream);
			{ 擪słꍇ̂߂CommaSplitedŏIsĐݒ肷 }
			if ResponseDat.Count > 0 then
				ResponseDat.CommaSplited := Pos('<>', ResponseDat[ResponseDat.Count - 1]) = 0;
			
			ResponseResTime := -1;
			ResTime := -1;
			J := 0;
			
			for I := ResponseDat.Count - 1 downto 1 do
			begin
				ResCount := I;

				DateVar := ResponseDat.DateTimes[I];
				if DateVar <> Null
					then ResponseResTime := DateVar
					else Continue;	{ t̕ϊɎsƂ͎̍s }

				J := Dat.Count;
				ResTime := -1;
				repeat
					if J <= 0 then Break;
					Dec(J);

					ResTime := -1;
					DateVar := Dat.DateTimes[J];
					if DateVar <> Null
						then ResTime := DateVar
						else Continue;
				until ResTime = ResponseResTime;

				if (ResTime <> -1) and (ResTime = ResponseResTime) then
					Break;
			end;

			{ ̓t }
			if (ResTime <> -1) and (ResTime = ResponseResTime) then
			begin
        { ̓t܂ō폜 }
				for K := Dat.Count - 1 downto J + 1 do
					Dat.Delete(K);
				{ dat̕ۑ }
				if (Dat.Count - 1) >= (J + 1) then
					Dat.SaveToFile(DatPath);
				Range := RangeStart;
				for K := 0 to ResCount do
					Range := Range + Length(ResponseDat[K]) + 1;
				TempIdx.ResCount := Dat.Count;
				TempIdx.DatSize := Range;
				Break;
			end;

			LastResStream.Clear;
			if ResponseDat.Count > 1 then
			begin
				K := Length(ResponseDat[0]) + 1;
				Stream.Seek(0, soFromBeginning);
				LastResStream.CopyFrom(Stream, K);
			end else
			begin	{ ResponseDat.Count <= 1 ̏ꍇ }
				Stream.Seek(0, soFromBeginning);
				LastResStream.CopyFrom(Stream, Stream.Size);
			end;

			RangeEnd := RangeStart - 1;
		until RangeStart <= 0;

		if (RangeStart = 0) and (not TempIdx.Modified) then
			ShowMessage('Ol܂CɎs܂B')
		else if not TempIdx.Modified then
				ShowMessage('O͋l܂Ă܂łB')
		else begin
			TempIdx.SaveToFile(LogPath);
			ThreadIdx.Assign(TempIdx);
			ThreadIdx.DatSize := 0;	{ ModifiedTrueɂ邽 }
			ThreadIdx.DatSize := TempIdx.DatSize;
      SetThreadIdxData;
			ShowMessage('Ol܂C܂B');
		end;
	finally
		Screen.Cursor := OrigCursor;
		
		Dat.Free;
		ResponseDat.Free;
		Stream.Free;
		LastResStream.Free;
		TempIdx.Free;
		HTTP.Free;
	end;
end;

procedure TThreadPropertyForm.RegetDatBtnClick(Sender: TObject);
var
	HTTP: TIdHTTP;
	URL, Path, S: string;
	I, J, Count: Integer;
	Stream: TMemoryStream;
	List: TStringList;
	CommParams: TKatjushaCommunicationParams;
	r: regex_t;
	Token: array [0 .. 4] of string;
begin
	HTTP := nil;
	Stream := nil;
	List := nil;
	AWKClearPattern(r);

	try
		HTTP := TIdHTTP.Create(nil);
		Stream := TMemoryStream.Create;
		List := TStringList.Create;

		AWKCompilePattern(r, '<>');
		URL := ThreadIdx.DatPath;

		CommParams := TKatjusha.GetCommParams;
		with HTTP do
		begin
			Request.Clear;
			Request.UserAgent := CommParams.UserAgent;
			Request.AcceptEncoding := 'gzip';
			if CommParams.ProxyParams.ProxyServer <> '' then
			begin
				ProxyParams.Assign(CommParams.ProxyParams);
			end else begin
				ProxyParams.ProxyPort := 80;
				ProxyParams.ProxyServer := '';
			end;
			ReadTimeout := CommParams.ReadTimeOut;
			Response.Clear;
		end;
		
		HTTP.Get(URL, Stream);

		if HTTP.Response.ContentEncoding = 'gzip' then
			UnzipStream(Stream);
		
		Stream.Seek(0, soFromBeginning);
		List.LoadFromStream(Stream);

		ThreadIdx.ResCount := List.Count;

		for I := 0 to List.Count - 1 do
		begin
			if Pos('<>', List[I]) > 0 then
			begin
				S := StringReplace(List[I], ',', 'M', [rfReplaceAll]);
				Count := AWKSplit(r, S, Token);

				Token[0] := '<b>' + Token[0] + '</b>';

				S := Token[0];
				for J := 1 to Count - 1 do
					S := S + ',' + Token[J];
				List[I] := S;
			end;
		end;

		Path := TKatjusha.GetKatjushaBaseDir + 'log\' + ChangeFileExt(ThreadIdx.LogPath, '.dat');

		List.SaveToFile(Path);

		ShowMessage('Ď擾܂B');
	finally
		AWKFreePattern(r);
		List.Free;
		Stream.Free;
		HTTP.Free;
	end;
end;

procedure TThreadPropertyForm.SetThreadIdxData;
begin
	Caption := '"' + ThreadIdx.ThreadName + '"' + Caption;
	TitleEdit.Text := ThreadIdx.ThreadName;
	URLText.Text := ThreadIdx.URL;

	if stNormal in ThreadIdx.State then NormalCheck.Checked := True;
	if stLog in ThreadIdx.State then DatDropCheck.Checked := True;
	if stFavorite in ThreadIdx.State then InFavoriteCheck.Checked := True;

	BoardNameEdit.Text := ThreadIdx.BoardName;
	ServerNameEdit.Text := ThreadIdx.ServerName;
	ResSpinEdit.Value := ThreadIdx.ResCount;
	BeforeResSpinEdit.Value := ThreadIdx.BeforeResCount;
	NewResSpinEdit.Value := ThreadIdx.NewResCount;
end;

end.

