unit OptDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, Buttons, ComCtrls, Mask, ToolEdit, RxCombos,
  Spin, ExtCtrls, Katjusha, FavUtils;

type
  TOptionDlg = class(TForm)
    OkBtn: TBitBtn;
    BitBtn2: TBitBtn;
    PageControl1: TPageControl;
    TabSheet3: TTabSheet;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    AddressEdit: TEdit;
    Label2: TLabel;
    PortEdit: TEdit;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    SpinEdit1: TSpinEdit;
    Label4: TLabel;
		Label5: TLabel;
		ArchiveExtEdit: TEdit;
    TabSheet1: TTabSheet;
    DblClickActionRadioGroup: TRadioGroup;
		CallBrowserActionRadioGroup: TRadioGroup;
    GroupBox3: TGroupBox;
    AlreadyFullCheckBox: TCheckBox;
    UseNewThreadReportCheckBox: TCheckBox;
    URLCopyActionRadioGroup: TRadioGroup;
    UseDepthColumnCheckBox: TCheckBox;
    Label6: TLabel;
    BrowserFilenameEdit: TFilenameEdit;
    TabSheet2: TTabSheet;
    NewResCheckUseSavedSubjectCheckBox: TCheckBox;
    NewResCheckUpdateIndexCheckBox: TCheckBox;
    NewResCheckNoUpdateRunningKatjushaCheckBox: TCheckBox;
    Label7: TLabel;
    SaveConfirmationCheckBox: TCheckBox;
    OtherTabSheet: TTabSheet;
    ScriptGroupBox: TGroupBox;
    ScriptDumpBtn: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
    procedure NewResCheckUpdateIndexCheckBoxClick(Sender: TObject);
    procedure ScriptDumpBtnClick(Sender: TObject);
  private
    { Private 錾 }
  public
		{ Public 錾 }
		KatfavIniFile: TKatfavIniFile;
  end;

var
  OptionDlg: TOptionDlg;

implementation

uses FavTypes;

{$R *.dfm}

procedure TOptionDlg.FormShow(Sender: TObject);
begin
	AddressEdit.Text := KatfavIniFile.ProxyAddress;
	PortEdit.Text := IntToStr(KatfavIniFile.ProxyPort);
	SpinEdit1.Value := KatfavIniFile.TimeOut;
	ArchiveExtEdit.Text := KatfavIniFile.ArchiveExt;
	BrowserFilenameEdit.Text := KatfavIniFile.DefaultBrowserCommand;
	SaveConfirmationCheckBox.Checked := KatfavIniFile.SaveConfirmation;
	with KatfavIniFile.ThreadListParams do
	begin
		DblClickActionRadioGroup.ItemIndex := Ord(DblClickAction);
		CallBrowserActionRadioGroup.ItemIndex := Ord(BrowserType);
		AlreadyFullCheckBox.Checked := AlreadyGetFull;
		UseNewThreadReportCheckBox.Checked := UseNewThreadReport;
		URLCopyActionRadioGroup.ItemIndex := Ord(URLCopyAction);
		UseDepthColumnCheckBox.Checked := UseDepth;
	end;
	with KatfavIniFile.NewResCheckParams do
	begin
		NewResCheckUseSavedSubjectCheckBox.Checked := UseSavedSubject;
		NewResCheckUpdateIndexCheckBox.Checked := UpdateIndexFile;
		NewResCheckNoUpdateRunningKatjushaCheckBox.Enabled := UpdateIndexFile;
		NewResCheckNoUpdateRunningKatjushaCheckBox.Checked := NoUpdateRunningKatjusha;
	end;

	PageControl1.ActivePageIndex := 0;
	AddressEdit.SetFocus;
end;

procedure TOptionDlg.OkBtnClick(Sender: TObject);
begin
	KatfavIniFile.ProxyAddress := AddressEdit.Text;
	KatfavIniFile.ProxyPort := StrToIntDef(PortEdit.Text, 8080);
	KatfavIniFile.TimeOut := SpinEdit1.Value;
	KatfavIniFile.ArchiveExt := ArchiveExtEdit.Text;
	KatfavIniFile.DefaultBrowserCommand := BrowserFilenameEdit.Text;
	KatfavIniFile.SaveConfirmation := SaveConfirmationCheckBox.Checked;
	with KatfavIniFile.ThreadListParams do
	begin
		DblClickAction := TThreadListDblClickAction(DblClickActionRadioGroup.ItemIndex);
		BrowserType := TThreadListBrowserType(CallBrowserActionRadioGroup.ItemIndex);
		AlreadyGetFull := AlreadyFullCheckBox.Checked;
		UseNewThreadReport := UseNewThreadReportCheckBox.Checked;
		URLCopyAction := TThreadListURLCopyAction(URLCopyActionRadioGroup.ItemIndex);
		UseDepth := UseDepthColumnCheckBox.Checked;
	end;
	with KatfavIniFile.NewResCheckParams do
	begin
		UseSavedSubject := NewResCheckUseSavedSubjectCheckBox.Checked;
		UpdateIndexFile := NewResCheckUpdateIndexCheckBox.Checked;
		NoUpdateRunningKatjusha := NewResCheckNoUpdateRunningKatjushaCheckBox.Checked;
	end;
end;

procedure TOptionDlg.NewResCheckUpdateIndexCheckBoxClick(Sender: TObject);
begin
	NewResCheckNoUpdateRunningKatjushaCheckBox.Enabled := (Sender as TCheckBox).Checked;
end;

procedure TOptionDlg.ScriptDumpBtnClick(Sender: TObject);
var
	ScriptManager: TKatfavScriptManager;
begin
	ScriptManager := TKatfavScriptManager(TKatjusha.GetScriptManager);

	if FileExists(ScriptManager.ScriptFileName) then
		if MessageDlg(ScriptManager.ScriptFileName + '͊ɑ݂Ă܂B'#13#10 +
				'㏑Ă낵łH', mtWarning, mbOKCancel, -1) = mrCancel
			then Exit;

	ScriptManager.Dump;

	MessageDlg(ScriptManager.ScriptFileName + 'ɕۑ܂B', mtInformation, [mbOK], -1);
end;

end.

