unit CustomSortEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Katjusha;

type
  TCustomSortEditDlg = class(TForm)
    ListBox: TListBox;
    SortTypeComboBox: TComboBox;
    DirectionComboBox: TComboBox;
    AddBtn: TBitBtn;
    DelBtn: TBitBtn;
    OkBtn: TBitBtn;
    BitBtn4: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    RepBtn: TBitBtn;
    NameEdit: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RepBtnClick(Sender: TObject);
  private
		{ Private 錾 }
		SortList: T2chCustomSortList;
		SortListName: string;
  public
		{ Public 錾 }
		class function Execute(var Name: string; SortList: T2chCustomSortList): Boolean;
  end;

implementation

{$R *.dfm}

procedure TCustomSortEditDlg.FormCreate(Sender: TObject);
var
	I: Integer;
begin
	for I := Low(SortTypeName) + 1 to High(SortTypeName) do
		SortTypeComboBox.Items.Add(SortTypeName[I].Name);

	SortTypeComboBox.ItemIndex := 0;
	DirectionComboBox.ItemIndex := 0;
end;

procedure TCustomSortEditDlg.AddBtnClick(Sender: TObject);
var
	Text: string;
	SortType: T2chThreadSortTypes;
const
	AscDec: array [0 .. 1] of T2chThreadSortType = (tsAsc, tsDec);
begin
	Text := SortTypeComboBox.Text;
	Text := Text + ' - ' + DirectionComboBox.Text;
	SortType := [SortTypeName[SortTypeComboBox.ItemIndex + 1].SortType, AscDec[DirectionComboBox.ItemIndex]];
	ListBox.Items.AddObject(Text, PPointer(@SortType)^);
end;

procedure TCustomSortEditDlg.ListBoxClick(Sender: TObject);
var
	P: Pointer;
	SortType: T2chThreadSortTypes;
	I: Integer;
begin
	if ListBox.ItemIndex < 0 then Exit;
	P := ListBox.Items.Objects[ListBox.ItemIndex];
	SortType := P2chThreadSortTypes(@P)^;

	if tsAsc in SortType
		then DirectionComboBox.ItemIndex := 0
		else DirectionComboBox.ItemIndex := 1;

	for I := Low(SortTypeName) + 1 to High(SortTypeName) do
		if SortTypeName[I].SortType in SortType then
		begin
			SortTypeComboBox.ItemIndex := I - 1;
			Break;
		end;
end;

procedure TCustomSortEditDlg.DelBtnClick(Sender: TObject);
begin
	with ListBox do
	begin
		if ItemIndex < 0 then Exit;
		Items.Delete(ItemIndex);
	end;
end;

class function TCustomSortEditDlg.Execute(
	var Name: string; SortList: T2chCustomSortList): Boolean;
var
	CustomSortEditDlg: TCustomSortEditDlg;
begin
	CustomSortEditDlg := TCustomSortEditDlg.Create(Application.MainForm);
	try
		CustomSortEditDlg.SortList := SortList;
		CustomSortEditDlg.SortListName := Name;
		Result := (CustomSortEditDlg.ShowModal = mrOk);
		if Result then
			Name := CustomSortEditDlg.SortListName;
	finally
		CustomSortEditDlg.Free;
	end;
end;

procedure TCustomSortEditDlg.OkBtnClick(Sender: TObject);
var
	P: Pointer;
	I: Integer;
begin
	SortList.Clear;

	for I := 0 to ListBox.Items.Count - 1 do
	begin
		P := ListBox.Items.Objects[I];
		SortList.Add(P2chThreadSortTypes(@P)^);
	end;

	SortListName := NameEdit.Text;
end;

procedure TCustomSortEditDlg.FormShow(Sender: TObject);
var
	Text: string;
	SortType: T2chThreadSortTypes;
	I: Integer;
begin
	NameEdit.Text := SortListName;

	for I := 0 to SortList.Count - 1 do
	begin
		SortType := SortList[I];
		Text := SortTypeToName(SortList[I]);
		if tsAsc in SortType
			then Text := Text + ' - ' + DirectionComboBox.Items[0]
			else Text := Text + ' - ' + DirectionComboBox.Items[1];
		ListBox.Items.AddObject(Text, PPointer(@SortType)^);
	end;
end;

procedure TCustomSortEditDlg.RepBtnClick(Sender: TObject);
var
	Text: string;
	SortType: T2chThreadSortTypes;
const
	AscDec: array [0 .. 1] of T2chThreadSortType = (tsAsc, tsDec);
begin
	if ListBox.ItemIndex < 0 then Exit;;
	Text := SortTypeComboBox.Text;
	Text := Text + ' - ' + DirectionComboBox.Text;
	SortType := [SortTypeName[SortTypeComboBox.ItemIndex + 1].SortType, AscDec[DirectionComboBox.ItemIndex]];
	with ListBox do
	begin
		Items[ItemIndex] := Text;
		Items.Objects[ItemIndex] := PPointer(@SortType)^;
	end;
end;

end.

