# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import web

from karesansui.lib.rest import Rest, auth
import karesansui.plus.updater

class HostBy1UpdaterBy1(Rest):

    @auth
    def _GET(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        yu = karesansui.plus.updater.YumUpdater(karesansui.config)
        pkgs = yu.pkgs()
        repos = yu.repos
        # param check
        pkg_name = param[1]
        _is_valid = True
        for repo in repos:
            for pkg in pkgs[repo]:
                if pkg[0] == pkg_name:
                    _is_valid = False
                    break
            if _is_valid is False:
                break
        if _is_valid is True:
            return web.badrequest()

        self.view.pkg_name = pkg_name
        self.view.rpm_detail = yu.rpm_detail(str(pkg_name))
        return True

urls = (
    '/host/(\d+)/updater/([^\./]+)[/]?(\.part)?$', HostBy1UpdaterBy1,
    )

