#!/usr/bin/env

import os
import sys
import glob

top_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
if (top_dir in sys.path) is False: sys.path.insert(0, top_dir)

misc_dir = "%s/misc" % top_dir


from installer.utils import execute_command

# newt.i386
arch = os.uname()[4]
if arch == "i686":
    command = "rpm -q newt.i386 --queryformat=%{VERSION}"
    (ret, res) = execute_command(command.split(" "))
    if ret == 0 and res[0] == '0.52.2':
        if os.path.exists(misc_dir):
            updates = []
            for _file in glob.glob("%s/RPMS/newt-*.rpm" % misc_dir):
                updates.append(_file)

            if len(updates) != 0:
                command = "rpm -Fvh %s" % " ".join(updates)
                (ret, res) = execute_command(command.split(" "))

