#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import sys

from installer.trans import _, N_
import installer

""" Product Information """
TITLE     = installer.__name__
VERSION   = installer.__version__
RELEASE   = installer.__release__
COPYRIGHT = "Copyright (C) 2009-2010 Karesansui Project"
WEBSITE   = "http://karesansui-project.info"
FLOG      = "            _\ \n        \  \  \n      O--`--\ \n     < ====  )\n      O--.--/ \n        /  /_ \n            / \n"

""" Paths """
INITRDDIR = "/etc/init.d"

SCRIPT_DIR            = "%s" % os.path.dirname(os.path.realpath(sys.argv[0]))
DEFAULT_INSTALL_LOG   = "/root/karesansui-install.log"
DEFAULT_INSTALL_INI   = "/root/karesansui-install.ini"
DEFAULT_UNINSTALL_LOG = "/root/karesansui-uninstall.log"
DEFAULT_INITDB_LOG    = "/root/karesansui-initdb.log"
RPMBUILD_TMPFILE_PREFIX = "/tmp/karesansui-rpmbuild"
GENERATE_RPMDIR       = "/root/karesansui-rpm"

SUPPORTED_DISTROS = [
   ("centos",  "^5-[12345].*$"),
   ("redhat",  "^5Server-5.[12345].*$"),
   #("redhat",  "^(5Server-5.[12345]|6-6\.).*$"),
]
SUPPORTED_ARCHS = [
   "^(i[3456]86)$",
   "^(x86_64)$",
]

VENDOR_PREFIX     = "/opt/hde"
VENDOR_BINDIR     = "%s/bin" % VENDOR_PREFIX
VENDOR_SYSCONFDIR = "/etc/opt/hde"
VENDOR_DATADIR    = "/var/opt/hde"
VENDOR_PYTHONPATH = "%s/lib/python" % VENDOR_PREFIX

SILHOUETTE_PREFIX     = "/opt/pysilhouette"
SILHOUETTE_SYSCONFDIR = "/etc/opt/pysilhouette"
SILHOUETTE_DATADIR    = "/var/opt/pysilhouette"
SILHOUETTE_PYTHONPATH = "%s/lib/python" % SILHOUETTE_PREFIX
DEFAULT_SILHOUETTE_CONF      = "%s/silhouette.conf" % SILHOUETTE_SYSCONFDIR
DEFAULT_SILHOUETTE_WHITELIST = "%s/whitelist.conf"  % SILHOUETTE_SYSCONFDIR
DEFAULT_SILHOUETTE_DB_URI = "sqlite:///%s/pysilhouette.db" % SILHOUETTE_DATADIR
SILHOUETTE_SYSCONFIG = "/etc/sysconfig/silhouetted"

KARESANSUI_PREFIX     = "/opt/karesansui"
KARESANSUI_SYSCONFDIR = "/etc/opt/karesansui"
KARESANSUI_DATADIR    = "/var/opt/karesansui"
KARESANSUI_PYTHONPATH = "%s/lib/python" % KARESANSUI_PREFIX
DEFAULT_KARESANSUI_CONF   = "%s/application.conf" % KARESANSUI_SYSCONFDIR
DEFAULT_KARESANSUI_DB_URI = "sqlite:///%s/karesansui.db"   % KARESANSUI_DATADIR

PYSILHOUETTE_PREFIX     = "/opt/pysilhouette"
PYSILHOUETTE_SYSCONFDIR = "/etc/opt/pysilhouette"
PYSILHOUETTE_DATADIR    = "/var/opt/pysilhouette"
PYSILHOUETTE_PYTHONPATH = "%s/lib/python" % PYSILHOUETTE_PREFIX
DEFAULT_PYSILHOUETTE_CONF   = "%s/silhouette.conf" % PYSILHOUETTE_SYSCONFDIR
DEFAULT_PYSILHOUETTE_DB_URI = "sqlite:///%s/pysilhouette.db"   % PYSILHOUETTE_DATADIR

VIRT_SYSCONFDIR = VENDOR_SYSCONFDIR + "/libvirt"
VIRT_LIBVIRTD_CONFIG_FILE = VIRT_SYSCONFDIR + "/libvirtd.conf"


DEFAULT_PYTHONPATH="%s:%s:%s:%s" % (SCRIPT_DIR,VENDOR_PYTHONPATH,SILHOUETTE_PYTHONPATH,KARESANSUI_PYTHONPATH,)

LIGHTY_SSL_CONF  = "%s/lighttpd/conf.d/karesansui/ssl.conf"  % VENDOR_SYSCONFDIR
LIGHTY_PORT_CONF = "%s/lighttpd/conf.d/karesansui/port.conf" % VENDOR_SYSCONFDIR

PKI_DATA_PREFIX        = VENDOR_SYSCONFDIR + "/pki"
PKI_CA_DIR             = PKI_DATA_PREFIX + "/CA"
PKI_CA_INFO            = PKI_CA_DIR + "/ca.info"
PKI_CA_PRIVATE_KEY     = PKI_CA_DIR + "/cakey.pem"
PKI_CA_SELFSIGNED_CRT  = PKI_CA_DIR + "/cacert.pem"
PKI_SERVER_INFO        = PKI_DATA_PREFIX + "/libvirt/server.info"
PKI_SERVER_PRIVATE_KEY = PKI_DATA_PREFIX + "/libvirt/private/serverkey.pem"
PKI_SERVER_CRT         = PKI_DATA_PREFIX + "/libvirt/servercert.pem"
PKI_CLIENT_INFO        = PKI_DATA_PREFIX + "/libvirt/client.info"
PKI_CLIENT_PRIVATE_KEY = PKI_DATA_PREFIX + "/libvirt/private/clientkey.pem"
PKI_CLIENT_CRT         = PKI_DATA_PREFIX + "/libvirt/clientcert.pem"

COMMAND_IFCONFIG  = "/sbin/ifconfig"
COMMAND_CHKCONFIG = "/sbin/chkconfig"
COMMAND_SERVICE   = "/sbin/service"
COMMAND_IPTABLES  = "/sbin/iptables"
COMMAND_IPTABLES_SAVE = "/sbin/iptables-save"
COMMAND_CERTTOOL      = "certtool"
COMMAND_VIRSH     = "%s/virsh" % VENDOR_BINDIR

DEFAULT_MAIL_HOST = "localhost"
DEFAULT_MAIL_PORT = 25

PROVIDED_SERVICES = [
    "hde-libvirtd",
    "hde-lighttpd",
    "silhouetted",
    "hde-collectd",
    "hde-rrdcached",
]

CORE_RPMS = [
    "karesansui",
    "pysilhouette",
    "hde-libvirt",
    "hde-libvirt-python",
    "hde-lighttpd",
    "hde-collectd",
]

CONFLICT_RPMS = {
    "/usr/bin/qemu-img": "qemu",
}

DEPENDENCIES_RPMS = {
    "karesansui"  :["PyXML"],
    "hde-collectd":["perl-HTML-Parser","perl-URI"],
    "hde-libvirt" :["cyrus-sasl-md5","iscsi-initiator-utils","gnutls-utils"],
}

DEFAULT_BUILD_PKGS_LINENUM = 1000
BUILD_PKGS_LINENUMS = {
                          "hde-python-pysqlite":250,
                          "hde-lighttpd"       :1500,
                          "hde-libvirt"        :2500,
                         }

#UNINSTALL_PKGS_REGEX = [
#    "^karesansui",
#    "^hde-libvirt",
#    "^hde-python-",
#    "^pysilhouette",
#]
UNINSTALL_PKGS_REGEX = [
    "^karesansui",
    "^hde-libvirt",
    "^hde-collectd-libvirt",
]

DATABASE_MODULES = {
    "ibase":["kinterbasdb"],
    "maxdb":["sapdb"],
    "mysql":["MySQLdb"],
    "oracle":["cx_Oracle"],
    "postgres":["psycopg2"],
    "sqlite":["pysqlite2","sqlite3"],
}

RPM_VERIFY = False
BUTTON_COMPACT = False
NEWT_MONO = False

FLAG_RPM_INST    = 1<<0
FLAG_WRITE_CONF  = 1<<1
FLAG_CREATE_ADM  = 1<<2
FLAG_CONFIG_DB   = 1<<3
FLAG_START_SERV  = 1<<4
FLAG_RPM_REBUILD = 1<<5
FLAG_CREATE_CRT  = 1<<6
FLAG_MIGRATION   = 1<<7
FLAG_RESTART_NET = 1<<8
FLAG_CONFIG_PROXY       = 1<<9
FLAG_CONFIG_MAIL        = 1<<10
FLAG_RESOLVE_DEPENDENCY = 1<<11
#FLAG_DO_ALL = FLAG_RPM_INST|FLAG_WRITE_CONF|FLAG_CREATE_ADM|FLAG_CONFIG_DB|FLAG_START_SERV|FLAG_CREATE_CRT|FLAG_MIGRATION
FLAG_DO_ALL = FLAG_RPM_INST|FLAG_WRITE_CONF|FLAG_CREATE_ADM|FLAG_CONFIG_DB|FLAG_CONFIG_PROXY|FLAG_CONFIG_MAIL|FLAG_START_SERV|FLAG_CREATE_CRT|FLAG_MIGRATION
FLAG_SHOW_VERSION = 1<<20

#try:
#    import platform
#    if platform.processor() == "x86_64":
#        FLAG_DO_ALL |= FLAG_RPM_REBUILD
#except:
#    pass

OK_VALUE     = 0
CANCEL_VALUE = 1
BACK_VALUE   = 2
YES_VALUE    = 3
NO_VALUE     = 4
EXIT_VALUE   = 5
F12_VALUE    = 6

OK_BUTTON     = [ _("OK"),     OK_VALUE ]
CANCEL_BUTTON = [ _("Cancel"), CANCEL_VALUE ]
BACK_BUTTON   = [ _("Back"),   BACK_VALUE ]
YES_BUTTON    = [ _("Yes"),    YES_VALUE ]
NO_BUTTON     = [ _("No"),     NO_VALUE ]
EXIT_BUTTON   = [ _("Exit"),   EXIT_VALUE ]

FLOW_PANEL = [OK_BUTTON, BACK_BUTTON, CANCEL_BUTTON]

