#!/bin/sh
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

kss_user=kss
kss_group=kss

#########################
# Karesansuiのインストール

rpm -Uvh ftp://centos5x86.prd.local.hde.co.jp/karesansui/karesansui-release-*rpm

sed -e 's#^enabled=0#enabled=1#' /etc/yum.repos.d/karesansui.repo >/etc/yum.repos.d/karesansui.repo.$$
cp -f /etc/yum.repos.d/karesansui.repo.$$ /etc/yum.repos.d/karesansui.repo
rm -f /etc/yum.repos.d/karesansui.repo.$$

yum -y install hde-python-Mako hde-python-psycopg2 hde-python-SQLAlchemy hde-python-simplejson hde-python-flup hde-python-webpy hde-libvirt hde-lighttpd hde-libvirt-python hde-openssl098

yum -y install pysilhouette

mkdir -p /etc/opt/karesansui
mkdir -p /var/opt/karesansui
mkdir -p /var/log/karesansui

#########################
# 開発環境のインストール

# perl-Errorをインストール
rpm -Uvh ftp://centos5x86.prd.local.hde.co.jp/common/perl-Error-0.17010-1.el5.noarch.rpm

sed -e 's#^enabled=0#enabled=1#' /etc/yum.repos.d/karesansui-devel.repo >/etc/yum.repos.d/karesansui-devel.repo.$$
cp -f /etc/yum.repos.d/karesansui-devel.repo.$$ /etc/yum.repos.d/karesansui-devel.repo
rm -f /etc/yum.repos.d/karesansui-devel.repo.$$

yum -y install hde-graphviz hde-libvirt-devel hde-graphviz-gd hde-python-epydoc hde-python-Beaker hde-python-setuptools hde-python-Babel emacs-Pymacs emacs-epydoc emacs-js2 emacs-python-mode emacs-yasnippet

# gitをインストール
yum -y install perl-DBI
rpm -Uvh ftp://centos5x86.prd.local.hde.co.jp/pkgs/git/RPMS/i386/git-1*.rpm ftp://centos5x86.prd.local.hde.co.jp/pkgs/git/RPMS/i386/perl-Git*.rpm

# emacs pdbモードで利用する
if [ ! -e /usr/bin/pdb ]; then
  cat <<_EOT_ >/usr/bin/pdb
#!/bin/sh
exec python /usr/lib/python2.4/pdb.py \$1 \$2 \$3 \$4 \$5 \$6 \$7 \$8 \$9

_EOT_
  chmod +x /usr/bin/pdb
fi

# gitリポジトリから取り寄せ
if [ ! -e /opt/karesansui/lib/python/karesansui ]; then
  mkdir -p /opt/karesansui/lib/python

  echo -n "Please input your account on 'raid.local.hde.co.jp' :"
  read username

  pushd $HOME
  git clone ssh://${username}@raid.local.hde.co.jp/hde/karesansui/karesansui.git karesansui.git.$$
  popd

  # 設定ファイルコピー
  if [ ! -e /opt/karesansui/lib/python/karesansui ]; then
  ln -s $HOME/karesansui.git.$$/karesansui /opt/karesansui/lib/python/karesansui
  fi
  if [ ! -e /etc/opt/karesansui/application.conf ]; then
  cp $HOME/karesansui.git.$$/doc/{application,log}.conf /etc/opt/karesansui/
  sed -e "s#^application.log.config=.*#application.log.config=/etc/opt/karesansui/log.conf#" /etc/opt/karesansui/application.conf >/etc/opt/karesansui/application.conf.$$
  cp -f /etc/opt/karesansui/application.conf.$$ /etc/opt/karesansui/application.conf
  rm -f /etc/opt/karesansui/application.conf.$$
  fi

  mv -f /etc/opt/hde/lighttpd/lighttpd.conf{,.$$}
  cp -f $HOME/karesansui.git.$$/doc/lighttpd/karesansui.conf /etc/opt/hde/lighttpd/conf.d/karesansui.conf
  mkdir -p /etc/opt/hde/lighttpd/conf.d/karesansui/
  cp -f $HOME/karesansui.git.$$/doc/lighttpd/{ssl,access,port}.conf /etc/opt/hde/lighttpd/conf.d/karesansui/

  ln -s $HOME/karesansui.git.$$/scripts/karesansui.fcgi /opt/hde/www/
  ln -s $HOME/karesansui.git.$$/bin /opt/karesansui/bin
  ln -s $HOME/karesansui.git.$$/scripts/karesansui.fcgi /opt/karesansui/bin/

  chgrp -R ${kss_group} $HOME/karesansui.git.$$
  chmod -R g+w $HOME/karesansui.git.$$

  /etc/init.d/hde-lighttpd restart

fi
chgrp -R ${kss_group} /etc/opt/karesansui
chgrp -R ${kss_group} /var/opt/karesansui
chgrp -R ${kss_group} /var/log/karesansui
chgrp -R ${kss_group} /opt/karesansui
chmod -R g+w /etc/opt/karesansui
chmod -R g+w /var/opt/karesansui
chmod -R g+w /var/log/karesansui
chmod -R g+w /opt/karesansui

#########################
# その他のパッケージのインストール

yum -y install hde-jquery hde-jquery-ui hde-python-virtinst hde-virt-manager
yum -y install wxPython-common-gtk2-unicode wxPython2.8-gtk2-unicode python-crypto winpdb

user_name=`git config user.name`
user_email=`git config user.email`
if [ "${user_name}" = "" ]; then
  echo -n "Please input username (like as '[1mNamae MYOJI[0m'): "
  read user_name
  git config --global user.name ${user_name}
fi
if [ "${user_email}" = "" ]; then
  echo -n "Please input email address (like as '[1muser@hde.co.jp[0m'): "
  read user_email
  git config --global user.email ${user_email}
fi
