// This file is part of Karesansui Core.
//
// Copyright (C) 2009-2010 HDE, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// Authors:
//     Kei Funagayama <kei@karesansui-project.info>
//


// measures for misalign main screen and grayout screen 
function adjust_grayout_screen(){
    $("#_light_screen_value").scrollTop(0);
    $(document).scrollTop(0);
}

function window_height(){
    var all_height = Math.max(
        document.body.clientHeight , document.body.scrollHeight);
    all_height = Math.max(all_height , document.documentElement.scrollHeight);
    all_height = Math.max(all_height , document.documentElement.clientHeight);
    return all_height;
}

function window_width(){
    var all_width = Math.max(
        document.body.clientWidth , document.body.scrollWidth);
    all_width = Math.max(all_width , document.documentElement.scrollWidth);
    all_width = Math.max(all_width , document.documentElement.clientWidth);
    //all_width = Math.max(all_width , screen.width)
    all_width = Math.max(all_width , screen.availWidth);

    return all_width;
}

function grayout_open(type, url, homepath, async_flag){
    // window height
    all_height = window_height();
    // window width
    all_width = window_width();


    async_flag = set_async_flag(async_flag);
 
    $.ajax({
        type: type,
        url: url,
        async: async_flag,
        success: function(data){
            $('body').css("overflow-y","hidden");
            $("#screen").html(data);
            $("#_screen_lock0").height(all_height).width(all_width).addClass("_screen_lock0");
            $("#_screen_lock1").height(all_height).width(all_width).addClass("_screen_lock1");
            $("#_screen_lock1").css('background-image', 'url(' + homepath + '/static/images/screen_bg.png)');
            $("#_light_screen").addClass("_light_screen");
            $("#_light_screen_title").addClass("_light_screen_title");
            $("#_light_screen_value").addClass("_light_screen_value");
            adjust_grayout_screen();
        }
    });
}

function grayout_close(){
    renew_all(false);
    $('body').css("overflow-y","auto");
    $("#screen").html('');
    $("#cluetip").hide();
}

function grayout_view(type, url, title, reflush, async_flag){
    async_flag = set_async_flag(async_flag);
    timer = setTimeout(function(){
        $.ajax({
            type: type,
            url: url,
            async: true,
            success: function(data) {
                $(".screen_title").html(title);
                $(".screen_value").html(data);
            }
        });
    }, 500);
    g_main_url = reflush;
    return timer
}

/** Dialog **/
function delete_dialog(id, url, param, reflush, button){
    $(id).text("${_('Do you really want to remove the target?')}");

    var _click_flag = false;

    $(id).dialog({
        width: 400,
        modal: true,
        title: "${_('Confirm')}",
        close: function(event, ui){
            if(_click_flag == false){
                _click_flag = true;
                $(".ui-dialog-buttonpane button").attr("disabled","disabled")
                if(button){
                    tool_reset(button);
                }
                $(this).dialog("close");
            }
        },
        buttons:{
            ${_("Delete")} : function(){
                if(_click_flag == false){
                    _click_flag = true;
                    $(".ui-dialog-buttonpane button").attr("disabled", "disabled")
                    $.remove(url,
                        param,
                        function(data, status){
                            if (status == "success") {
                                g_main_url = reflush;
                                renew_all(false);
                                alert_on(".alert", "SUCCEED", "${_('Was removed.')}");
                            }
                        }
                    );
                    $(this).dialog("close");
                }
            },
            ${_("Cancel")} : function() {
                if(_click_flag == false){
                    _click_flag = true;
                    $(".ui-dialog-buttonpane button").attr("disabled", "disabled")
                    if(button){
                        tool_reset(button);
                    }
                    $(this).dialog("close");
                }
            }
        }
    });
}
function apply_dialog(id, url, param, reflush, button){
    $(id).text("${_('OK to apply changes?')}");

    var _click_flag = false;

    $(id).dialog({
        width: 400,
        modal: true,
        title: "${_('Confirm')}",
        close: function(event, ui){
            if(_click_flag == false){
                _click_flag = true;
                $(".ui-dialog-buttonpane button").attr("disabled", "disabled")
                if(button){
                    tool_reset(button);
                }
                $(this).dialog("close");
            }
        },
        buttons:{
            ${_("Apply")}:function(){
                if(_click_flag == false){
                    _click_flag = true;
                    $(".ui-dialog-buttonpane button").attr("disabled", "disabled")
                    $.put(url,
                        param,
                        function(data, status){
                            if (status == "success") {
                                g_main_url = reflush;
                                renew_all(false);
                                alert_on(".alert", "SUCCEED", "${_('Was applied.')}");
                            }
                        }
                    );
                    $(this).dialog("close");
                }
            },
            ${_("Cancel")}:function() {
                if(_click_flag == false){
                    _click_flag = true;
                    $(".ui-dialog-buttonpane button").attr("disabled", "disabled")
                    if(button); tool_reset(button);
                    $(this).dialog("close");
                }
            }
        }
    });
}
