// This file is part of Karesansui Core.
//
// Copyright (C) 2009-2010 HDE, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// Authors:
//     Kei Funagayama <kei@karesansui-project.info>
//

function alert_on(id, status, msg){
    var alt_img = "";
    var alt_cls = "";
    var alt_title = "";

    if(id == '' || status == '' || msg == ''){
        return "";
    }
    
    if(status == 'SUCCEED'){
        alt_title = "${_('SUCCEED')}";
        alt_img = "succeed.gif";
        alt_cls = "succeed-alt";
    } else if(status == 'CAUTION') {
        alt_title = "${_('CAUTION')}";
        alt_img = "alert.gif";
        alt_cls = "caution-alt";
    } else if(status == 'ERROR') {
        alt_title = "${_('ERROR')}";
        alt_img = "alert.gif";
        alt_cls = "error-alt";
    }
    var lmsg = '<div class="alert-bg"><div class="' + alt_cls + '">';
    var msg = '<img src="${ctx.homepath}/static/images/' + alt_img + '" alt="${_("Alert")}" /><pre>' + status + ':  ' + msg + '</pre>';
    var rmsg = '</div><br style="clear:both" /></div>';

    $(id).html(lmsg + msg + rmsg);
    return true;
}

function alert_off(_id){
    $(_id).html("");
    return true;
}

function show_alert_msg(err_msg){
    alert_on(".grayout-alert", "ERROR", err_msg);
    adjust_grayout_screen();
}
