#! /usr/bin/env python
# -*- coding: utf-8 -*-`
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#

from karesansui import KaresansuiTemplateException

def view(text, _):
    """<comment-ja>
    mako#render時にUNDEFINEDが発生する可能性がある場合に利用してください。
    UNDEFINEDが発生した場合は、国際化された_('Undefined')が返却されます。
    @param text: 表示する文字列
    @type text: str
    @param _: translationオブジェクト
    @type _:gettext.GNUTranslations
    @rtype: str
    @return: 表示する文字列
    </comment-ja>
    <comment-en>
    TODO: English Comment
    </comment-en>
    """
    from mako.runtime import UNDEFINED

    if text is UNDEFINED:
        return ""
    elif not text:
        return _('Undefined')
    else:
        return text

def img_status(status, prefix='', extra=''):
    """<comment-ja>
    ゲストOSのステータスを元に指定された形式で出力します。
    @param status: libvirt status
    @type status: int
    @param prefix: 固定画像名の先頭につけるプレフィックスファイル名　example) prefix='bar-' result 'bar-nostate.png'
    @type prefix: str
    @param extra: imgタグに別途追記する属性
    @type extra: str
    @return: form#img
    @rtype: str
    </comment-ja>
    <comment-en>
    TODO: English Comment
    </comment-en>
    """
    import web
    from karesansui.lib.virt.virt import VIR_DOMAIN_NOSTATE, \
         VIR_DOMAIN_RUNNING, \
         VIR_DOMAIN_BLOCKED, \
         VIR_DOMAIN_PAUSED, \
         VIR_DOMAIN_SHUTDOWN, \
         VIR_DOMAIN_SHUTOFF, \
         VIR_DOMAIN_CRASHED

    _img_tpl = '<img src="' + web.ctx.homepath + '/static/images/%s" alt=""' + extra + ' />'

    if status == VIR_DOMAIN_NOSTATE:
        return _img_tpl % (prefix+'nostate.png')
    elif status == VIR_DOMAIN_CRASHED:
        return _img_tpl % (prefix+'crashed.png')
    elif status == VIR_DOMAIN_SHUTOFF:
        return _img_tpl % (prefix+'shutoff.png')
    elif status == VIR_DOMAIN_SHUTDOWN:
        return _img_tpl % (prefix+'shutdown.png')
    elif status == VIR_DOMAIN_PAUSED:
        return _img_tpl % (prefix+'paused.png')
    elif status == VIR_DOMAIN_BLOCKED:
        return _img_tpl % (prefix+'blocked.png')
    elif status == VIR_DOMAIN_RUNNING:
        return _img_tpl % (prefix+'running.png')
    else:
        raise KaresansuiTemplateException("Not specify the status.")

def str_status(status, _):
    """<comment-ja>
    ゲストOSステータスの名称を出力します。
    @param status: libvirt status
    @type status: int
    @param _: translationオブジェクト
    @type _:gettext.GNUTranslations
    @return: 名称
    @rtype: str
    </comment-ja>
    <comment-en>
    TODO: English Comment
    </comment-en>
    """
    import web
    from karesansui.lib.virt.virt import VIR_DOMAIN_NOSTATE, \
         VIR_DOMAIN_RUNNING, \
         VIR_DOMAIN_BLOCKED, \
         VIR_DOMAIN_PAUSED, \
         VIR_DOMAIN_SHUTDOWN, \
         VIR_DOMAIN_SHUTOFF, \
         VIR_DOMAIN_CRASHED

    if status == VIR_DOMAIN_NOSTATE:
        return _('NOSTATE')
    elif status == VIR_DOMAIN_CRASHED:
        return _('CRASHED')
    elif status == VIR_DOMAIN_SHUTOFF:
        return _('SHUTOFF')
    elif status == VIR_DOMAIN_SHUTDOWN:
        return _('SHUTDOWN')
    elif status == VIR_DOMAIN_PAUSED:
        return _('PAUSED')
    elif status == VIR_DOMAIN_BLOCKED:
        return _('BLOCKED')
    elif status == VIR_DOMAIN_RUNNING:
        return _('RUNNING')
    else:
        raise KaresansuiTemplateException("Not specify the status.")

def str_attribute(attribute):
    """<comment-ja>
    マシン属性の名称を出力します。
    @param attribute: マシン属性値
    @type attribute: int
    @return: 名称
    @rtype: str
    </comment-ja>
    <comment-en>
    TODO: English Comment
    </comment-en>
    """
    from karesansui.lib.const import MACHINE_ATTRIBUTE

    for key, value in MACHINE_ATTRIBUTE.items():
        if attribute == value:
            return key
    else:
        raise KaresansuiTemplateException("Not specify the attribute.")

def locale_hypervisor(hypervisor, _):
    """<comment-ja>
    Japanese Comment
    </comment-ja>
    <comment-en>
    TODO: English Comment
    </comment-en>
    """
    from karesansui.lib.const import MACHINE_HYPERVISOR
    if (hypervisor in MACHINE_HYPERVISOR.values()) is True:
        for x in MACHINE_HYPERVISOR.items():
            if hypervisor == x[1]:
                return _(x[0])

        raise KaresansuiTemplateException("Hypervisor is not defined.")
    else:
        raise KaresansuiTemplateException("Hypervisor is not defined.")

def lnewline(text):
    from mako.runtime import UNDEFINED
    if text is UNDEFINED:
        return ""
    ret = ""
    for t in text:
        ret += t + '\n'
    return ret

def clipping(text, num):
    """<comment-ja>
    テキストが任意の文字数を超えていたら、
    省略したテキストに … を加えたものをを返却する。
    そうでないなら、テキストをそのまま返却する。
    半角は1文字、全角は2文字としてカウントする。

    @param text: 省略するテキスト
    @type text: str
    @param num: 省略する文字数
    @type num: int
    @return: str
    </comment-ja>
    <comment-en>
    TODO: English Comment
    </comment-en>
    """
    from mako.runtime import UNDEFINED
    if text is UNDEFINED:
        return ""

    ret = text

    count = 0
    for i in xrange(len(text)):
        if ord(text[i]) <= 255:
            count += 1;
        else:
            count += 2;

        if num < count:
            ret = text[0:i] + u"…"
            break

    return ret

def replace_empty(value, replace_value):
    """<comment-ja>
    値がNone、または、空文字('')のものを指定の値に置き換えます
    @param value: 置き換え元の要素
    @type value: str
    @param replace_value: 置き換え先の要素
    @type replace_value: str
    @return: 存在するマシン名
    @rtype: str
    </comment-ja>
    <comment-en>
    TODO: English Comment
    </comment-en>
    """
    if value == None or value == "":
        return replace_value
    else:
        return value

def get_exist_machine_name(machines, _):
    """<comment-ja>
    存在するマシン名を返却します。
    マシン名が複数あるときはカンマ区切りで返却します。
    マシン名が存在しない、または、マシンが削除されているときは、「Unregistered」を返却します。
    @param machines: マシンの配列
    @type machines: list
    @param _: translationオブジェクト
    @type _:gettext.GNUTranslations
    @return: 存在するマシン名
    @rtype: str
    </comment-ja>
    <comment-en>
    TODO: English Comment
    </comment-en>
    """
    if machines is None:
        return _('N/A')

    _names = []
    for machine in machines:
        if machine.is_deleted is False:
            _names.append(machine.name)
    
    if len(_names) > 0:
        return  ",".join(_names)
    else:
        return  _('N/A')
