#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#

import math

import karesansui

DEFAULT_LANGS = {"ja_JP": {'DATE_FORMAT' : ("%Y/%m/%d", "%Y/%m/%d %H:%M:%S", "yy-mm-dd")},
                 "en_US": {'DATE_FORMAT' : ("%m/%d/%Y", "%m/%d/%Y %H:%M:%S", "mm-dd-yy")},
                 }
"""<comment-ja>
DATE_FORMAT
 - [年月日, 年月日時分秒, jquery.ui.datepicker,]
</comment-ja>
<comment-en>
TODO: English Comment
</comment-en>
"""

# define karesansui paths & users
KARESANSUI_USER  = "kss"
KARESANSUI_GROUP = "kss"
KARESANSUI_PREFIX = "/opt/karesansui"
KARESANSUI_TMP_DIR     = KARESANSUI_PREFIX + "/tmp"
KARESANSUI_SYSCONF_DIR = "/etc/opt/karesansui"

MACHINE_ATTRIBUTE = {'HOST':0,
                     'GUEST':1,
                    }
MACHINE_HYPERVISOR = {'REAL':0,
                      'XEN':1,
                      'KVM':2,
                     }

# define vendor paths
VENDOR_PREFIX      = "/opt/hde"
VENDOR_SYSCONF_DIR = "/etc/opt/hde"
VENDOR_DATA_DIR    = "/var/opt/hde"
VENDOR_LIBVIRT_RUN_DIR = "/var/run/hde-libvirt"
XEN_SYSCONF_DIR    = "/etc/xen"

#LOGOUT_FILE_PREFIX = "%s/logout." % karesansui.config['application.tmp.dir']
LOGOUT_FILE_PREFIX = KARESANSUI_TMP_DIR + "/logout."
ICON_DIR_TPL = "%s/static/icon/%s"
MSG_LIMIT = 5
TAG_CLIPPING_RANGE = 12
MACHINE_NAME_CLIPPING_RANGE = 20

DEFAULT_LIST_RANGE = 10
JOB_LIST_RANGE = DEFAULT_LIST_RANGE
USER_LIST_RANGE = DEFAULT_LIST_RANGE
TAG_LIST_RANGE = DEFAULT_LIST_RANGE

# use for virt library
VIRT_LIBVIRT_DATA_DIR    = VENDOR_DATA_DIR + "/libvirt"
VIRT_XENDOMAINS_AUTO_DIR = XEN_SYSCONF_DIR + "/auto"

VIRT_LIBVIRT_SOCKET_RW = VENDOR_LIBVIRT_RUN_DIR + "/libvirt-sock";
VIRT_LIBVIRT_SOCKET_RO = VENDOR_LIBVIRT_RUN_DIR + "/libvirt-sock-ro";

# kvm
KVM_VIRTUAL_DISK_PREFIX = "hd"
KVM_VIRT_CONFIG_DIR  = VENDOR_SYSCONF_DIR + "/kvm"
KVM_VIRT_URI_RW = "qemu+tls://127.0.0.1:16514/system?no_verify=1"
KVM_VIRT_URI_RO = "qemu+tls://127.0.0.1:16514/system?no_verify=1"
KVM_KARESANSUI_TMP_DIR = KARESANSUI_TMP_DIR + "/kvm"
KVM_KEYMAP_DIR = '/usr/share/kvm/keymaps'

# xen
XEN_VIRTUAL_DISK_PREFIX = "xvd"
XEN_VIRT_CONFIG_DIR  = VENDOR_SYSCONF_DIR + "/xen"
XEN_VIRT_URI_RW = "xen:///?socket=" + VIRT_LIBVIRT_SOCKET_RW
XEN_VIRT_URI_RO = "xen:///?socket=" + VIRT_LIBVIRT_SOCKET_RO
XEN_KARESANSUI_TMP_DIR = KARESANSUI_TMP_DIR + "/xen"
XEN_KEYMAP_DIR = '/usr/share/xen/qemu/keymaps'

VIRT_XML_CONFIG_DIR  = VENDOR_SYSCONF_DIR + "/libvirt/qemu"

VIRT_SYSCONF_DIR = VENDOR_SYSCONF_DIR + "/libvirt"
OLD_VIRT_DISK_DIR       = VIRT_LIBVIRT_DATA_DIR + "/disk"
OLD_VIRT_DISK_IMAGE_DIR = VIRT_LIBVIRT_DATA_DIR + "/images"
OLD_VIRT_BOOT_IMAGE_DIR = VIRT_LIBVIRT_DATA_DIR + "/boot"
OLD_VIRT_SNAPSHOT_DIR   = VIRT_LIBVIRT_DATA_DIR + "/snapshot"
VIRT_DOMAINS_DIR        = VIRT_LIBVIRT_DATA_DIR + "/domains"
VIRT_NETWORK_CONFIG_DIR = VIRT_SYSCONF_DIR + "/qemu/networks"
VIRT_AUTOSTART_CONFIG_DIR = VIRT_SYSCONF_DIR + "/qemu/autostart"
VIRT_LIBVIRTD_CONFIG_FILE = VIRT_SYSCONF_DIR + "/libvirtd.conf"

# virt command
VIRT_COMMAND_APPLY_SNAPSHOT = "apply_snapshot.py"
VIRT_COMMAND_CREATE_GUEST = "create_guest.py"
VIRT_COMMAND_DELETE_GUEST = "delete_guest.py"
VIRT_COMMAND_DELETE_SNAPSHOT = "delete_snapshot.py"
VIRT_COMMAND_GET_MEMORY_USAGE = "get_memory_usage.py"
VIRT_COMMAND_SET_MEMORY = "set_memory.py"
VIRT_COMMAND_START_GUEST = "start_guest.py"
VIRT_COMMAND_REBOOT_GUEST = "reboot_guest.py"
VIRT_COMMAND_DESTROY_GUEST = "destroy_guest.py"
VIRT_COMMAND_AUTOSTART_GUEST = "autostart_guest.py"
VIRT_COMMAND_CREATE_NETWORK = "create_network.py"
VIRT_COMMAND_DELETE_NETWORK = "delete_network.py"
VIRT_COMMAND_UPDATE_NETWORK = "update_network.py"
VIRT_COMMAND_REPLICATE_GUEST = "replicate_guest.py"
VIRT_COMMAND_SET_VCPUS = "set_vcpus.py"
VIRT_COMMAND_SUSPEND_GUEST = "suspend_guest.py"
VIRT_COMMAND_ADD_DISK = "add_disk.py"
VIRT_COMMAND_APPEND_DISK = "append_disk.py"
VIRT_COMMAND_DELETE_DISK = "delete_disk.py"
VIRT_COMMAND_ADD_NIC = "add_nic.py"
VIRT_COMMAND_DELETE_NIC = "delete_nic.py"
VIRT_COMMAND_CPUTOP = "cputop.py"
VIRT_COMMAND_GET_CPU_USAGE = "get_cpu_usage.py"
VIRT_COMMAND_RESUME_GUEST = "resume_guest.py"
VIRT_COMMAND_SHUTDOWN_GUEST = "shutdown_guest.py"
VIRT_COMMAND_TAKE_SNAPSHOT = "take_snapshot.py"
VIRT_COMMAND_SET_MAC_ADDRESS = "set_mac_address.py"
VIRT_COMMAND_SET_VNC = "set_vnc.py"
FIREWALL_COMMAND_SAVE_FIREWALL = "save_firewall.py"
FIREWALL_COMMAND_RESTORE_FIREWALL = "restore_firewall.py"
UPDATE_COMMAND_SOFTWARE="update_software.py"

# use for firewall library
FIREWALL_XML_FILE  = KARESANSUI_SYSCONF_DIR + "/firewall.xml"
FIREWALL_USERCHAIN = "KARESANSUI-Firewall"
RH_USERCHAIN = "RH-Firewall-1-INPUT"

# Proxy Server use Status
PROXY_ENABLE = '1'
PROXY_DISABLE = '0'

# lighttpd config
LIGHTTPD_COMMAND_UPDATE_CONFIG = "apply_lighttpdconf.py"
LIGHTTPD_CONF_TEMP_DIR = KARESANSUI_TMP_DIR + "/lighttpd"
LIGHTTPD_DEFAULT_PORT = 80
LIGHTTPD_DEFAULT_SSL = "disable"
LIGHTTPD_DEFAULT_ACCESS = "all"
LIGHTTPD_PORT_CONFIG = "port.conf"
LIGHTTPD_ACCESS_CONFIG = "access.conf"
LIGHTTPD_SSL_CONFIG = "ssl.conf"
LIGHTTPD_SSL_ON = "enable"
LIGHTTPD_SSL_OFF = "disable"

# port number
PORT_MIN_NUMBER = 1
PORT_MAX_NUMBER = 65535
WELKNOWN_PORT_MIN_NUMBER = 1
WELKNOWN_PORT_MAX_NUMBER = 1024
UNKNOWN_PORT_MIN_NUMBER = 1025
UNKNOWN_PORT_MAX_NUMBER = 65535
VNC_PORT_MIN_NUMBER = 5900
VNC_PORT_MAX_NUMBER = PORT_MAX_NUMBER

# input value length
ID_MIN_LENGTH = 1
ID_MAX_LENGTH = int(math.pow(2, 31)) - 1  # signed int max (2^31-1) SQLAlchemy SQLType.Integer
USER_MIN_LENGTH = 1
USER_MAX_LENGTH = 16
EMAIL_MIN_LENGTH = 1 + 1 + 4
EMAIL_MAX_LENGTH = 256
PASSWORD_MIN_LENGTH = 4
PASSWORD_MAX_LENGTH = 40
LANGUAGES_MIN_LENGTH = 1
LANGUAGES_MAX_LENGTH = 6
TAG_MIN_LENGTH = 1
TAG_MAX_LENGTH = 24
SEARCH_MIN_LENGTH = 0
SEARCH_MAX_LENGTH = 256
PAGE_MIN_SIZE = 0
PAGE_MAX_SIZE = int(math.pow(2, 31)) - 1  # signed int max (2^31-1)
MACHINE_NAME_MIN_LENGTH = 1
MACHINE_NAME_MAX_LENGTH = 256
HYPERVISOR_MIN_SIZE = 0
HYPERVISOR_MAX_SIZE = 2
MEMORY_MIN_SIZE = 64
DISK_MIN_SIZE = 1
CHECK_DISK_QUOTA = 0.95
DOMAIN_NAME_MIN_LENGTH = 1
DOMAIN_NAME_MAX_LENGTH = 32
NOTE_TITLE_MIN_LENGTH = 0
NOTE_TITLE_MAX_LENGTH = 64
IMAGE_EXT_LIST = ["gif", "png", "jpeg"]
VCPUS_MIN_SIZE = 1
FQDN_MIN_LENGTH = 0
FQDN_MAX_LENGTH = 256

DEFAULT_KEYMAP = 'en-us'
