%define name pysilhouette
%define version 0.6.1
%define release 1
%define date %(echo `LANG=C date +%%Y%%m%%d%%H%%M%%S`)

%define _prefix /opt

%define __python $(which python)
%define __app pysilhouette
%define __prog silhouette
%define __progd %{__prog}d
%define __sysconfdir %{_sysconfdir}/opt/%{__app}
%define __bindir %{_prefix}/%{__app}/bin
%define __datadir %{_var}/opt/%{__app}
%define _defaultdocdir %{_prefix}/%{__app}/share/doc
%define python_sitelib  %{_prefix}/%{__app}/lib/python

%define _user           pysilhouette
%define _group          pysilhouette
%define _uid_min        300
%define _uid_max        350

Summary: A python-based background job manager
Summary(ja): オープンソースのバックグラウンドジョブマネージャー
Name: %{name}
Version: %{version}
#Release: %{release}.%{date}
Release: %{release}
Source0: %{name}-%{version}.tar.gz
License: MIT/X11
Group: System Environment/Daemons
Vendor: Karesansui Project
URL: http://sourceforge.jp/projects/pysilhouette/
Packager: Taizo ITO <taizo@karesansui-project.info>
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
Prefix: %{_prefix}
BuildArch: noarch

%description
Pysilhouette is a python-based background job manager,
intended to co-work with various python-based web applications.
It makes it available to get job status to programmers,
which was difficult in http-based stateless/interactive session before.
100% Pure Python.

%prep
%setup

%build
python setup.py build

%install
python setup.py install --root=$RPM_BUILD_ROOT --record=INSTALLED_FILES --home=%{_prefix}/%{__app}

mkdir -p $RPM_BUILD_ROOT%{__sysconfdir}
mkdir -p $RPM_BUILD_ROOT%{__bindir}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig
mkdir -p $RPM_BUILD_ROOT/var/log/%{__app}/

install -c -m 644 doc/log.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/log.conf.example
install -c -m 644 doc/log.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/log.conf

install -c -m 644 doc/%{__prog}.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/%{__prog}.conf.example
install -c -m 644 doc/%{__prog}.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/%{__prog}.conf

install -c -m 644 doc/whitelist.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/whitelist.conf.example
install -c -m 644 doc/whitelist.conf.example $RPM_BUILD_ROOT%{__sysconfdir}/whitelist.conf

install -c -m 644 doc/rc.d/init.d/* $RPM_BUILD_ROOT%{_initrddir}/
install -c -m 644 doc/sysconfig/%{__progd} $RPM_BUILD_ROOT/etc/sysconfig/%{__progd}

chmod +x $RPM_BUILD_ROOT%{python_sitelib}/%{__app}/%{__prog}.py
%{__ln_s} %{python_sitelib}/%{__app}/%{__prog}.py $RPM_BUILD_ROOT%{__bindir}

%clean
rm -rf $RPM_BUILD_ROOT

%pre
# Add group
getent group | %{__grep} "^%{_group}:" >/dev/null 2>&1
if [ $? -ne 0 ]; then
  __uid=%{_uid_min}
  while test ${__uid} -le %{_uid_max}
  do
    getent group | %{__grep} "^[^:]*:x:${__uid}:" >/dev/null 2>&1
    if [ $? -ne 0 ]; then
      _gid=${__uid}
      break
    fi
    __uid=`expr ${__uid} + 1`
  done
  /usr/sbin/groupadd -g ${_gid} -f %{_group}
fi

# Add user
getent passwd | %{__grep} "^%{_user}:" >/dev/null 2>&1
if [ $? -ne 0 ]; then
  __uid=%{_uid_min}
  while test ${__uid} -le %{_uid_max}
  do
    getent passwd | %{__grep} "^[^:]*:x:${__uid}:" >/dev/null 2>&1
    if [ $? -ne 0 ]; then
      _uid=${__uid}
      break
    fi
    __uid=`expr ${__uid} + 1`
  done
  /usr/sbin/useradd -c "pysilhouette" -u ${_uid} -g %{_group} -s /bin/false -r %{_user} 2> /dev/null || :
fi

%post
if [ ! -e %{__datadir} ]; then
  mkdir -p %{__datadir} 2> /dev/null
fi

%postun
if [ $1 = 0 ]; then
  /usr/sbin/userdel %{_user} 2> /dev/null || :
  /usr/sbin/groupdel %{_group} 2> /dev/null || :
fi


%files -f INSTALLED_FILES
%defattr(-,root,root)
%doc doc tool
%dir %attr(0755, root, root) %{__sysconfdir}
%attr(0755, root, root) %{_initrddir}/*
%attr(0644, root, root) %config(noreplace) %{__sysconfdir}/log.conf
%attr(0644, root, root) %{__sysconfdir}/log.conf.example
%attr(0644, root, root) %config(noreplace) %{__sysconfdir}/%{__prog}.conf
%attr(0644, root, root) %{__sysconfdir}/%{__prog}.conf.example
%attr(0644, root, root) %config(noreplace) %{__sysconfdir}/whitelist.conf
%attr(0644, root, root) %{__sysconfdir}/whitelist.conf.example
%attr(0644, root, root) %config(noreplace) /etc/sysconfig/%{__progd}
%{__bindir}/%{__prog}.py
%dir /var/log/%{__app}

%changelog
* Tue May 19 2009 Taizo ITO <taizo@karesansui-project.info> - 0.6.1-1
- Update version.

* Tue Feb 4 2009 HDE Package Maintainer <info@hde.co.jp> - 0.1.0-1
- Initial build.

