# Kanbanara Tidy svgcharts folder
# Written by Rebecca Shalfield between 2013 and 2017
# Copyright (c) Rebecca Shalfield 2013-2017
# Released under the GNU AGPL v3

'''Kanbanara's Tidy SVGCharts Folder Subprocess
   Automatically removes .svg charts that are over a day old
'''

import os
import re
import time

CURRENT_DIR = os.path.join(os.path.dirname(os.path.abspath(__file__)), '..')
SVG_PATTERN = re.compile(r'^.*_(\d+)\.svg$')
EPOCH = int(time.time())
PERIOD_DAY = 86400

for filename in os.listdir(os.path.join(CURRENT_DIR, 'svgcharts')):
    results = SVG_PATTERN.findall(filename)
    if results:
        if int(results[0]) < EPOCH-PERIOD_DAY:
            os.remove(os.path.join(CURRENT_DIR, 'svgcharts', filename))
