/*
 * Decompiled with CFR 0.152.
 */
package kamicup.xml.dom.deprecated;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomTool {
    public static final Document newDocument(String filename) throws ParserConfigurationException, SAXException, IOException {
        return DomTool.newDocument(new File(filename));
    }

    public static final Document newDocument(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = DomTool.getDocumentBuilder();
        Document doc = db.parse(stream);
        DomTool.replaceEntityReferenceWithText(doc.getDocumentElement());
        return doc;
    }

    public static final Document newDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = DomTool.getDocumentBuilder();
        Document doc = db.parse(file);
        DomTool.replaceEntityReferenceWithText(doc.getDocumentElement());
        return doc;
    }

    private static final DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        boolean validation = false;
        boolean ignoreWhitespace = false;
        boolean ignoreComments = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validation);
        dbf.setIgnoringComments(ignoreComments);
        dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db;
    }

    public static final String replaceEntityReferenceWithText(Node node) {
        if (node.getNodeType() == 5) {
            if (node.getNodeName().equals("amp")) {
                return "&";
            }
            if (node.getNodeName().equals("lt")) {
                return "<";
            }
            if (node.getNodeName().equals("gt")) {
                return ">";
            }
            if (node.getNodeName().equals("quot")) {
                return "\"";
            }
        } else if (node.getNodeType() == 3) {
            return null;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String str = DomTool.replaceEntityReferenceWithText(child);
            if (str != null) {
                node.replaceChild(node.getOwnerDocument().createTextNode(str), child);
            }
            ++i;
        }
        return null;
    }

    public static final int countNode(Node node, String str) {
        return DomTool.countNode(node, str, 0);
    }

    private static final int countNode(Node node, String str, int counter) {
        Node child = node.getFirstChild();
        while (child != null) {
            counter = DomTool.countNode(child, str, counter);
            child = child.getNextSibling();
        }
        if (node.getNodeName().equals(str)) {
            ++counter;
        }
        return counter;
    }

    public static final void setChildTextNodeValue(Node node, String value) {
        NodeList children = node.getChildNodes();
        if (children.getLength() != 0) {
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 3) {
                    children.item(i).setNodeValue(value);
                    return;
                }
                ++i;
            }
            throw new RuntimeException("any child Node is not TEXT_NODE");
        }
        node.appendChild(node.getOwnerDocument().createTextNode(value));
    }

    public static final void deleteEmptyTextNode(Node node) {
    }

    public static final String getChildTextNodeValue(Node node) {
        String str = "";
        try {
            Node child = node.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 3) {
                    str = String.valueOf(str) + child.getNodeValue();
                }
                node.removeChild(child);
                child = node.getFirstChild();
            }
            node.appendChild(node.getOwnerDocument().createTextNode(str));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static final Node getNamedChildNode(Node node, String nodeName) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals(nodeName)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static Element newElementWithTextNode(Document owner, String nodename) {
        Element element = owner.createElement(nodename);
        element.appendChild(owner.createTextNode(""));
        return element;
    }
}

