#!/usr/bin/env ruby 

$: << "./src"

require 'cgi'
require 'KakiRequestHandler.rb'
require 'PropertyFile.rb'

unless $config then
	CONFIG_FILE = "kaki.conf"
	$config = PropertyFile.load(CONFIG_FILE);
	$config['data_dir'].untaint
	$config['template_dir'].untaint
	$config['theme_dir'].untaint
	$config['theme_base_url'].untaint
	$config['log_file'].untaint
end


unless $page_data_source then
#	$page_data_source = Wiki::FilePageDataSource.new($data_dir)
	#$page_data_source = Wiki::PStorePageDataSource.new($data_dir)
#	$page_data_source.use_cache = $use_cache 
#	$page_data_source.use_memory_cache = $use_memory_cache 
	$page_data_source = Wiki::FilePageDataSource.new($config['data_dir'])
	$page_data_source.use_cache = $config['use_cache']
	$page_data_source.use_memory_cache = $config['use_memory_cache']
end

class WikiCGI < CGI
	def main
		write_log()

		app = KakiRequestHandler.new($page_data_source, ENV, self.params);

#		app.template_dir = $template_dir if $template_dir
#		app.theme_dir = $theme_dir if $theme_dir
#		app.theme_base_url = $theme_base_url if $theme_base_url
		app.template_dir = $config['template_dir'] if $config['template_dir']
		app.theme_dir = $config['theme_dir'] if $config['theme_dir']
		app.theme_base_url = $config['theme_base_url']if $config['theme_base_url']
		app.main()
		header = app.response_header
		body = app.response_body

		self.out(header) {
			body
		}
	end

	def write_log()
		if $config['log_file'] then
			log = self.remote_addr
			log += %Q! [#{Time.now.strftime("%d/%b/%Y:%H:%M:%S %Z")}]!
			log += %Q! "#{self.request_method}!
			log += %Q! #{self.script_name}#{ ('?' + self.query_string) if self.query_string.to_s.length > 0}!
			log += %Q! #{self.server_protocol}"!
			log += %Q! "#{self.referer.to_s.length > 0 ? self.referer : '-'}"!
			log += %Q! "#{self.user_agent}"!

			log += "\n"
			File.open($config['log_file'], "a"){ |log_file|
				log_file.flock(File::LOCK_EX) 
				log_file << log 
				log_file.flock(File::LOCK_UN) 
			}
		end
	end
end

WikiCGI.new().main
