
class Wiki::PageParser
rule
	doc : root_elements 
		{ 
			doc = Page.new(val)
			result = doc
		}

	root_elements : root_element { result = val }
		| root_elements root_element { result << val[1] }

	root_element : NULL_LINE { result = Text.new('') ; }
		| paragraph { result = Paragraph.new(val[0]) }
		| HEADLINE { 
			result = Headline.new(val[0][0], @line_parser.parse(val[0][1]))
		}
		| H_LINE  { result = HorizontalLine.new() }
		| preformat
		| table
		| quotation
		| definition_list
		| ul3 
		| ul2 
		| ul1 
		| ol3 
		| ol2 
		| ol1 

	paragraph : text_lines 

	# preformat
	preformat : preformat_lines { result = Preformat.new(val[0]) }
	preformat_lines : preformat_line  { result = val }
		| preformat_lines preformat_line { result << val[1] }
	preformat_line : PREFORMAT_LINE { result = Text.new(val[0]) }

	# table
	table : table_lines { result = Table.new(val[0]) }
	table_lines : table_line  { result = val }
		| table_lines table_line { result << val[1] }
	table_line : TABLE_LINE { result = @table_line_parser.parse(val[0])}

	# quotation
	quotation : quotation_lines { result = Quotation.new(val[0]) }
	quotation_lines : quotation_line { result = val }
		| quotation_lines quotation_line { result << val[1] }
	quotation_line : QUOT_LINE { result = Text.new(val[0]) }

	# definition_list
	definition_list : definition_lines { result = DefinitionList.new(val[0]) }
	definition_lines : definition_line { result = val }
		| definition_lines definition_line { result << val[1] }
	definition_line : DEFINITION_LINE 
	{ 
		dt, dd = val[0].split(':', 2)
		item = DefinitionItem.new(dt, @line_parser.parse(dd));
		result = item;
	}


	ul1 : ul1_items { result = UnorderedList.new(val[0]) }
	ul1_items : ul1_item { result = val }
		| ul1_items ul1_item { result << val[1] }
	ul1_item : ul1_line { result = ListItem.new(val[0]) }
		| ul1_line text_lines { result = ListItem.new( val) }
		| ul1_line ul2 { result = ListItem.new( val) }
		| ul1_line ul3 { result = ListItem.new( val) }
		| ul1_line ol2 { result = ListItem.new( val) }
		| ul1_line ol3 { result = ListItem.new( val) }
	ul1_line : UL1_LINE { result = @line_parser.parse(val[0]) }

	ul2 : ul2_items { result = UnorderedList.new(val[0]) }
	ul2_items : ul2_item { result = val }
		| ul2_items ul2_item { result << val[1] }
	ul2_item : ul2_line { result = ListItem.new(val[0]) }
		| ul2_line text_lines { result = ListItem.new( val) }
		| ul2_line ul3 { result = ListItem.new( val) }
		| ul2_line ol3 { result = ListItem.new( val) }
	ul2_line : UL2_LINE { result = @line_parser.parse(val[0]) }
 
	ul3 : ul3_items { result = UnorderedList.new(val[0]) }
	ul3_items : ul3_item { result = val }
		| ul3_items ul3_item { result << val[1] }
	ul3_item : ul3_line { result = ListItem.new(val[0]) }
		| ul3_line text_lines { result = ListItem.new( val) }
	ul3_line : UL3_LINE { result = @line_parser.parse(val[0]) }


	ol1 : ol1_items { result = OrderedList.new(val[0]) }
	ol1_items : ol1_item { result = val }
		| ol1_items ol1_item { result << val[1] }
	ol1_item : ol1_line { result = ListItem.new(val[0]) }
		| ol1_line text_lines { result = ListItem.new( val) }
		| ol1_line ol2 { result = ListItem.new( val) }
		| ol1_line ol3 { result = ListItem.new( val) }
		| ol1_line ul2 { result = ListItem.new( val) }
		| ol1_line ul3 { result = ListItem.new( val) }
	ol1_line : OL1_LINE { result = @line_parser.parse(val[0]) }

	ol2 : ol2_items { result = OrderedList.new(val[0]) }
	ol2_items : ol2_item { result = val }
		| ol2_items ol2_item { result << val[1] }
	ol2_item : ol2_line { result = ListItem.new(val[0]) }
		| ol2_line text_lines { result = ListItem.new( val) }
		| ol2_line ol3 { result = ListItem.new( val) }
		| ol2_line ul3 { result = ListItem.new( val) }
	ol2_line : OL2_LINE { result = @line_parser.parse(val[0]) }

	ol3 : ol3_items { result = OrderedList.new(val[0]) }
	ol3_items : ol3_item { result = val }
		| ol3_items ol3_item { result << val[1] }
	ol3_item : ol3_line { result = ListItem.new(val[0]) }
		| ol3_line text_lines { result = ListItem.new(val) }
	ol3_line : OL3_LINE { result = @line_parser.parse(val[0]) }


	# text_line+
	text_lines : text_line { result = val }
		| text_lines text_line { result << val[1] }

	text_line : TEXT_LINE { result = @line_parser.parse(val[0]) }

end



---- header
require 'InLineParser.rb'
require 'TableLineParser.rb'
require 'DocumentModel.rb'
---- inner
def parse(source)
	@yydebug = true;
	@line_parser = InLineParser.new();
	@table_line_parser = TableLineParser.new();

	@tokens = []
	source.each(){ |line|
		case line
		# headline
		when /\A(!{1,5})(.+)/ then
			@tokens.push([:HEADLINE, [$1.length, $2.strip()]])

		# unordered list
		when /\A(\*{1,3})(.+)/ then
			case $1.length
			when 1 then
				@tokens.push([:UL1_LINE, $2.strip()])
			when 2 then
				@tokens.push([:UL2_LINE, $2.strip()])
			when 3 then
				@tokens.push([:UL3_LINE, $2.strip()])
			end

		# ordered list
		when /\A(\#{1,3})(.+)/ then
			case $1.length
			when 1 then
				@tokens.push([:OL1_LINE, $2.strip()])
			when 2 then
				@tokens.push([:OL2_LINE, $2.strip()])
			when 3 then
				@tokens.push([:OL3_LINE, $2.strip()])
			end

		# preformat
		when /\A[ ](.*)/ then
			@tokens.push([:PREFORMAT_LINE, $1.chomp()+"\n"])

		# table
		when /\A,.*/ then
			@tokens.push([:TABLE_LINE, $&.chomp()])

		# quotation
		when /\A""(.*)/ then
			@tokens.push([:QUOT_LINE, $1])

		# definition list
		when /\A:(.*)/ then
			@tokens.push([:DEFINITION_LINE, $1.chomp()])

		# horizontal line
		when /\A----.*/ then
			@tokens.push([:H_LINE, $&])

		# null line
		when /\A\s*\Z/ then
			@tokens.push([:NULL_LINE, $&])

		else
			@tokens.push([:TEXT_LINE, line])
		end
	}
	@tokens.push [:NULL_LINE, "\n"]
	@tokens.push [false, 'end']

#	@tokens.each(){ |token| p token}
	do_parse()
end

def next_token()
	@tokens.shift
end


---- footer
if $0 == __FILE__ then
	require 'ToHtml.rb'
	begin
		parser = Wiki::PageParser.new
		text = ARGF.readlines().join()
		doc =  parser.parse(text);
		html_string = ''
		formatter = Wiki::ToHtml.new(html_string)
		doc.accept(formatter)
		puts html_string
	rescue Racc::ParseError
		p $!
	end
end

