#!/usr/bin/env ruby 

$: << "./src"

require 'cgi'
require 'KakiRequestHandler.rb'
require 'config.rb'

unless $page_data_source then
	$page_data_source = Wiki::FilePageDataSource.new($data_dir)
	#$page_data_source = Wiki::PStorePageDataSource.new($data_dir)
	$page_data_source.use_cache = $use_cache 
	$page_data_source.use_memory_cache = $use_memory_cache 
end

$log_file = './access.log' unless $log_file 

class WikiCGI < CGI
	def main
		write_log()

		app = KakiRequestHandler.new($page_data_source, File.basename(__FILE__));
		app.theme_dir = $theme_dir
		app.theme_base_url = $theme_base_url
		header, body = app.main(ENV, self.params)

		self.out(header) {
			body
		}
	end

	def write_log()
		if $log_file then
			log = self.remote_addr
			log += %Q! [#{Time.now.strftime("%d/%b/%Y:%H:%M:%S %Z")}]!
			log += %Q! "#{self.request_method}!
			log += %Q! #{self.script_name}#{ ('?' + self.query_string) if self.query_string.to_s.length > 0}!
			log += %Q! #{self.server_protocol}"!
			log += %Q! "#{self.referer.to_s.length > 0 ? self.referer : '-'}"!
			log += %Q! "#{self.user_agent}"!

			log += "\n"
			File.open($log_file, "a"){ |log_file|
				log_file.flock(File::LOCK_EX) 
				log_file << log 
				log_file.flock(File::LOCK_UN) 
			}
		end
	end
end

WikiCGI.new().main
