#!/usr/bin/env ruby 

$: << "./src"

require 'cgi'
require 'KakiRequestHandler.rb'
require 'config.rb'

unless $page_data_source then
	$page_data_source = Wiki::FilePageDataSource.new($data_dir)
	#$page_data_source = Wiki::PStorePageDataSource.new($data_dir)
	$page_data_source.use_cache = $use_cache 
	$page_data_source.use_memory_cache = $use_memory_cache 
end

class WikiCGI < CGI
	def main
		request_header = {}
		request_header["accept"] = [self.accept]
		request_header["accept-charset"] = [self.accept_charset ]
		request_header["accept-encoding"] = [self.accept_encoding ]
		request_header["accept-language"] = [self.accept_language ]
		request_header["cache-control"] = [self.cache_control ]
		request_header["from"] = [self.from ]
		request_header["host"] = [self.host ]
		request_header["negotiate"] = [self.negotiate ]
		request_header["pragma"] = [self.pragma ]
		request_header["referer"] = [self.referer] 
		request_header["user-agent"] = [self.user_agent]

		app = KakiRequestHandler.new($page_data_source, File.basename(__FILE__));
		app.theme_dir = $theme_dir
		app.theme_base_url = $theme_base_url
		header, body = app.main(request_header, self.params)

		self.out(header) {
			body
		}
	end
end

WikiCGI.new().main
